/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.split.operation;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.complex.Complex;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.vectorediting.lib.prov.split.operation.SplitOperation;

public class LineSplitOperation
implements SplitOperation {
    @Override
    public Geometry split(Geometry geometryToBeSplitted, Geometry splitter) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        Line lineToBeSplitted = (Line)geometryToBeSplitted;
        Geometry intersection = geometryToBeSplitted.intersection(splitter);
        if (intersection instanceof Complex) {
            intersection = ((Complex)intersection).createAggregate(7, t -> t.getGeometryType().getType() == 7 || t.getGeometryType().getType() == 1);
        }
        MultiLine multilineSplitted = null;
        if (intersection instanceof MultiPoint) {
            MultiPoint intersectionMultiPoint = (MultiPoint)intersection;
            Point firstVertex = intersectionMultiPoint.getPointAt(0);
            Point lastVertex = intersectionMultiPoint.getPointAt(intersectionMultiPoint.getPrimitivesNumber() - 1);
            MultiLine difference = (MultiLine)geometryToBeSplitted.difference(splitter);
            if (difference == null) {
                return geometryToBeSplitted;
            }
            if (!firstVertex.equals(lineToBeSplitted.getVertex(0)) && !lastVertex.equals(lineToBeSplitted.getVertex(0)) && this.isClosed(lineToBeSplitted)) {
                int i;
                Line firstLine = (Line)difference.getPrimitiveAt(0);
                Line lastLine = (Line)difference.getPrimitiveAt(difference.getPrimitivesNumber() - 1);
                Line union = GeometryLocator.getGeometryManager().createLine(geometryToBeSplitted.getGeometryType().getSubType());
                for (i = 0; i < lastLine.getNumVertices(); ++i) {
                    union.addVertex(lastLine.getVertex(i));
                }
                for (i = 0; i < firstLine.getNumVertices(); ++i) {
                    union.addVertex(firstLine.getVertex(i));
                }
                multilineSplitted = GeometryLocator.getGeometryManager().createMultiLine(geometryToBeSplitted.getGeometryType().getSubType());
                multilineSplitted.addPrimitive((Primitive)union);
                for (i = 1; i < difference.getPrimitivesNumber() - 1; ++i) {
                    multilineSplitted.addPrimitive(difference.getPrimitiveAt(i));
                }
            }
        }
        if (multilineSplitted == null) {
            return geometryToBeSplitted.difference(splitter);
        }
        return multilineSplitted;
    }

    private boolean isClosed(Line lineToBeSplitted) {
        Point firstPoint = lineToBeSplitted.getVertex(0);
        Point lastPoint = lineToBeSplitted.getVertex(lineToBeSplitted.getNumVertices() - 1);
        return firstPoint.equals(lastPoint);
    }
}

