/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader.swing.impl;

import java.net.URL;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.downloader.swing.DownloaderConfigController;
import org.gvsig.downloader.swing.DownloaderConfigPanel;
import org.gvsig.downloader.swing.DownloaderConfigServicePanel;
import org.gvsig.downloader.swing.DownloaderSwingManager;
import org.gvsig.downloader.swing.impl.config.DownloaderConfigPanelImpl;
import org.gvsig.downloader.swing.impl.config.DownloaderConfigServicePanelImpl;
import org.gvsig.downloader.swing.impl.configController.DownloaderConfigControllerImpl;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloaderSwingManagerImpl
implements DownloaderSwingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloaderSwingManagerImpl.class);
    public static final String ICON_GROUP_NAME = "Downloader";
    public static final String ICON_PROVIDER_NAME = "Downloader";

    public static void registerIcons(String[][] iconsInfo) {
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        for (String[] icon : iconsInfo) {
            URL url = DownloaderSwingManagerImpl.class.getResource("images/" + icon[2] + ".png");
            theme.registerDefault(icon[0], icon[1], icon[2], null, url);
        }
    }

    public static ImageIcon loadImage(String imageName) {
        String name = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        URL url = DownloaderSwingManagerImpl.class.getResource("images/" + name + ".png");
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public DownloaderConfigPanel createDownloaderConfigPanel() {
        DownloaderConfigPanelImpl c = new DownloaderConfigPanelImpl();
        return c;
    }

    public DownloaderConfigController createDownloaderConfigController(Supplier<String> serviceUrl, JButton btnAddService, JButton btnShowConfig) {
        DownloaderConfigControllerImpl x = new DownloaderConfigControllerImpl(serviceUrl, btnAddService, btnShowConfig);
        return x;
    }

    public DownloaderConfigServicePanelImpl createDownloaderConfigServicePanel() {
        DownloaderConfigServicePanelImpl x = new DownloaderConfigServicePanelImpl();
        return x;
    }

    public DownloaderConfigServicePanel createDownloaderConfigServicePanel(String serviceUrl) {
        DownloaderConfigServicePanelImpl x = new DownloaderConfigServicePanelImpl(serviceUrl);
        return x;
    }
}

