/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wcs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import org.gvsig.remoteclient.ILayer;
import org.gvsig.remoteclient.utils.BoundaryBox;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class WCSCoverage
implements ILayer {
    public static final String SEPARATOR = " +";
    private String name;
    private String title;
    private String _abstract;
    private Hashtable bBoxes = new Hashtable();
    private BoundaryBox lonLatBbox;
    public RectifiedGrid rg;
    private ArrayList timePositions = new ArrayList();
    public String timePeriod;
    private String rangeSetName;
    private String rangeSetLabel;
    public Hashtable axisPool = new Hashtable();
    private String nativeSRS;
    private ArrayList supportedSRSs = new ArrayList();
    private ArrayList interpolationMethods;
    private String nativeFormat;
    private ArrayList formats = new ArrayList();

    public ArrayList getTimePositions() {
        return this.timePositions;
    }

    public void addTimePosition(String timeExpr) {
        if (this.timePositions == null) {
            this.timePositions = new ArrayList();
        }
        this.timePositions.add(timeExpr);
    }

    public ArrayList getFormats() {
        return this.formats;
    }

    public void addFormat(String format) {
        this.formats.add(format);
    }

    public void setNativeFormat(String nativeFormat) {
        this.nativeFormat = nativeFormat;
    }

    public String getNativeFormat() {
        return this.nativeFormat;
    }

    public String getNativeSRS() {
        return this.nativeSRS;
    }

    public void setNativeSRS(String nativeSRS) {
        this.nativeSRS = nativeSRS;
    }

    public ArrayList getSRSs() {
        return this.supportedSRSs;
    }

    public void addSRSs(String srs) {
        this.supportedSRSs.add(srs);
    }

    public String getRangeSetLabel() {
        return this.rangeSetLabel;
    }

    public void setRangeSetLabel(String rangeSetLabel) {
        this.rangeSetLabel = rangeSetLabel;
    }

    public String getRangeSetName() {
        return this.rangeSetName;
    }

    public void setRangeSetName(String rangeSetName) {
        this.rangeSetName = rangeSetName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String _name) {
        this.name = _name;
    }

    public void setTitle(String _title) {
        this.title = _title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAbstract() {
        return this._abstract;
    }

    public void setAbstract(String _abstract) {
        this._abstract = _abstract;
    }

    public void addBBox(BoundaryBox bBox) {
        this.bBoxes.put(bBox.getSrs(), bBox);
    }

    public ArrayList getAllSrs() {
        ArrayList<String> mySrs = new ArrayList<String>();
        mySrs.addAll(this.supportedSRSs);
        if (!mySrs.contains(this.nativeSRS)) {
            mySrs.add(this.nativeSRS);
        }
        return mySrs;
    }

    public BoundaryBox getBbox(String id) {
        if ((id.compareToIgnoreCase("EPSG:4326") == 0 || id.compareToIgnoreCase("CRS:84") == 0) && this.lonLatBbox != null) {
            return this.lonLatBbox;
        }
        return (BoundaryBox)this.bBoxes.get(id);
    }

    public BoundaryBox getLatLonBox() {
        return this.lonLatBbox;
    }

    public void setLonLatBox(BoundaryBox box) {
        this.lonLatBbox = box;
    }

    public void addInterpolationMethod(String method) {
        if (this.interpolationMethods == null) {
            this.interpolationMethods = new ArrayList();
        }
        this.interpolationMethods.add(method);
    }

    public ArrayList getInterpolationMethods() {
        return this.interpolationMethods;
    }

    public abstract void parse(KXmlParser var1) throws XmlPullParserException, IOException;

    public RectifiedGrid getRectifiedGrid() {
        return this.rg;
    }

    public double getResX() {
        if (this.rg == null || this.rg.offsetVector == null) {
            return -1.0;
        }
        return Math.abs(this.rg.offsetVector[0][0]);
    }

    public double getResY() {
        if (this.rg == null || this.rg.offsetVector == null) {
            return -1.0;
        }
        return Math.abs(this.rg.offsetVector[1][1]);
    }

    public Hashtable getBBoxes() {
        if (this.bBoxes == null) {
            return new Hashtable();
        }
        return this.bBoxes;
    }

    public class AxisDescription {
        private String _name;
        private String label;
        private ArrayList singleValues = new ArrayList();
        private String interval;
        private String defaultValue;

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getInterval() {
            return this.interval;
        }

        public void setInterval(String interval) {
            this.interval = interval;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public ArrayList getSingleValues() {
            return this.singleValues;
        }

        public void addSingleValues(String singleValue) {
            this.singleValues.add(singleValue);
        }
    }

    public class RectifiedGrid {
        private int dimensions;
        private String[] axisNames;
        private int[][] lowGridEnvelopLimits;
        private int[][] highGridEnvelopLimits;
        private double[] origins;
        private double[][] offsetVector;

        public RectifiedGrid(int dimensions) {
            this.dimensions = dimensions;
        }

        public void addAxisName(String axisName) {
            if (this.axisNames == null) {
                this.axisNames = new String[1];
                this.axisNames[0] = axisName;
            } else {
                String[] aux = this.axisNames;
                this.axisNames = new String[this.axisNames.length + 1];
                for (int i = 0; i < aux.length; ++i) {
                    this.axisNames[i] = aux[i];
                }
                this.axisNames[this.axisNames.length - 1] = axisName;
            }
        }

        public String[] getAxisNames() {
            return this.axisNames;
        }

        public void addLowGridEnvelopLimit(int[] lowLimit) {
            if (this.lowGridEnvelopLimits == null) {
                this.lowGridEnvelopLimits = new int[1][1];
                this.lowGridEnvelopLimits[0] = lowLimit;
            } else {
                int[][] aux = this.lowGridEnvelopLimits;
                this.lowGridEnvelopLimits = new int[this.lowGridEnvelopLimits.length + 1][1];
                for (int i = 0; i < aux.length; ++i) {
                    this.lowGridEnvelopLimits[i] = aux[i];
                }
                this.lowGridEnvelopLimits[this.lowGridEnvelopLimits.length - 1] = lowLimit;
            }
        }

        public int[][] getLowGridEnvelopLimits() {
            return this.lowGridEnvelopLimits;
        }

        public void addHighGridEnvelopLimit(int[] highLimit) {
            if (this.highGridEnvelopLimits == null) {
                this.highGridEnvelopLimits = new int[1][1];
                this.highGridEnvelopLimits[0] = highLimit;
            } else {
                int[][] aux = this.highGridEnvelopLimits;
                this.highGridEnvelopLimits = new int[this.highGridEnvelopLimits.length + 1][1];
                for (int i = 0; i < aux.length; ++i) {
                    this.highGridEnvelopLimits[i] = aux[i];
                }
                this.highGridEnvelopLimits[this.highGridEnvelopLimits.length - 1] = highLimit;
            }
        }

        public int[][] getHighGridEnvelopLimits() {
            return this.highGridEnvelopLimits;
        }

        public void setOrigin(double[] _origins) {
            this.origins = _origins;
        }

        public double[] getOrigins() {
            return this.origins;
        }

        public void addToOffsetVector(double[] _offsetVector) {
            if (this.offsetVector == null) {
                this.offsetVector = new double[1][1];
                this.offsetVector[0] = _offsetVector;
            } else {
                double[][] aux = this.offsetVector;
                this.offsetVector = new double[this.offsetVector.length + 1][1];
                for (int i = 0; i < aux.length; ++i) {
                    this.offsetVector[i] = aux[i];
                }
                this.offsetVector[this.offsetVector.length - 1] = _offsetVector;
            }
        }

        public double[][] getOffsetVector() {
            return this.offsetVector;
        }

        public int getDimensionCount() {
            return this.dimensions;
        }
    }
}

