/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wcs.wcs_1_0_0;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.remoteclient.utils.BoundaryBox;
import org.gvsig.remoteclient.wcs.WCSCoverage;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class WCSCoverage1_0_0
extends WCSCoverage {
    String axisDescriptionName;

    @Override
    public void parse(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean end = false;
        parser.require(2, null, "CoverageOffering");
        int currentTag = parser.next();
        while (!end && currentTag != 1) {
            switch (currentTag) {
                case 2: {
                    String value;
                    if (parser.getName().compareTo("name") == 0) {
                        value = parser.nextText();
                        if (value == null) break;
                        this.setName(value);
                        break;
                    }
                    if (parser.getName().compareTo("label") == 0) {
                        value = parser.nextText();
                        if (value == null) break;
                        this.setTitle(value);
                        break;
                    }
                    if (parser.getName().compareTo("lonLatEnvelope") == 0) {
                        BoundaryBox bBox = this.parseLonLatGMLEnvelope(parser);
                        bBox.setSrs("WGS84(DD)");
                        this.addBBox(bBox);
                        this.setLonLatBox(bBox);
                        break;
                    }
                    if (parser.getName().compareTo("domainSet") == 0) {
                        this.parseDomainSet(parser);
                        break;
                    }
                    if (parser.getName().compareTo("RangeSet") == 0) {
                        this.parseRangeSet(parser);
                        break;
                    }
                    if (parser.getName().compareTo("supportedCRSs") == 0) {
                        this.parseSupportedCRSS(parser);
                        break;
                    }
                    if (parser.getName().compareTo("supportedFormats") == 0) {
                        this.setNativeFormat(parser.getAttributeValue("", "nativeFormat"));
                        parser.nextTag();
                        parser.require(2, null, "formats");
                        while (parser.getName().compareTo("formats") == 0) {
                            String[] formats = StringUtils.split((String)parser.nextText(), (String)" +");
                            for (int i = 0; i < formats.length; ++i) {
                                this.addFormat(formats[i]);
                            }
                            parser.nextTag();
                        }
                        break;
                    }
                    if (parser.getName().compareTo("supportedInterpolations") == 0) {
                        boolean bInterpolationsEnd = false;
                        int interpolationsTag = parser.next();
                        while (!bInterpolationsEnd) {
                            switch (interpolationsTag) {
                                case 2: {
                                    if (parser.getName().compareTo("interpolationMethod") != 0) break;
                                    this.addInterpolationMethod(parser.nextText());
                                    break;
                                }
                                case 3: {
                                    if (parser.getName().compareTo("supportedInterpolations") != 0) break;
                                    bInterpolationsEnd = true;
                                    break;
                                }
                                case 4: {
                                    if (parser.getName() == null) break;
                                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                                }
                            }
                            interpolationsTag = parser.next();
                        }
                        break;
                    }
                    if (parser.getName().equals("rangeSet")) break;
                    System.out.println("Skiped " + parser.getName());
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("CoverageOffering") != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (parser.getName() == null) break;
                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                }
            }
            currentTag = parser.next();
        }
    }

    private void parseSupportedCRSS(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean end = false;
        parser.require(2, null, "supportedCRSs");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("requestResponseCRSs") == 0) {
                        String[] values = StringUtils.split((String)parser.nextText(), (String)" +");
                        for (int i = 0; i < values.length; ++i) {
                            this.addSRSs(values[i]);
                        }
                        break;
                    }
                    if (parser.getName().compareTo("nativeCRSs") == 0) {
                        this.setNativeSRS(parser.nextText());
                        break;
                    }
                    if (parser.getName().compareTo("requestCRSs") == 0) {
                        System.out.println("Skiped " + parser.getName());
                        break;
                    }
                    if (parser.getName().compareTo("responseCRSs") == 0) {
                        System.out.println("Skiped " + parser.getName());
                        break;
                    }
                    System.out.println("Unrecognized " + parser.getName());
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("supportedCRSs") != 0) break;
                    return;
                }
                case 4: {
                    if (parser.getName() == null) break;
                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                }
            }
            currentTag = parser.next();
        }
    }

    private void parseRangeSet(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean end = false;
        parser.require(2, null, "RangeSet");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (StringUtils.equals((CharSequence)parser.getName(), (CharSequence)"name")) {
                        this.setRangeSetName(parser.nextText());
                        break;
                    }
                    if (StringUtils.equals((CharSequence)parser.getName(), (CharSequence)"label")) {
                        this.setRangeSetLabel(parser.nextText());
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)parser.getName(), (CharSequence)"AxisDescription")) {
                        int axisTag = parser.nextTag();
                        boolean endAxe = false;
                        boolean endRangeSet = false;
                        while (!endAxe) {
                            switch (axisTag) {
                                case 2: {
                                    if (!StringUtils.equals((CharSequence)"AxisDescription", (CharSequence)parser.getName())) break;
                                    WCSCoverage.AxisDescription as = this.parseAxisDescription(parser);
                                    this.axisPool.put(as.getName(), as);
                                    this.axisDescriptionName = as.getName();
                                    endRangeSet = true;
                                    break;
                                }
                                case 3: {
                                    if (!StringUtils.equalsIgnoreCase((CharSequence)"AxisDescription", (CharSequence)parser.getName())) break;
                                    endAxe = true;
                                    break;
                                }
                                case 4: {
                                    if (parser.getName() == null) break;
                                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                                }
                            }
                            axisTag = parser.next();
                            if (!endRangeSet || !StringUtils.equalsIgnoreCase((CharSequence)"RangeSet", (CharSequence)parser.getName())) continue;
                            endAxe = true;
                            end = true;
                        }
                        break;
                    }
                    System.out.println("Unrecognized " + parser.getName());
                    break;
                }
                case 3: {
                    if (!"RangeSet".equals(parser.getName())) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (parser.getName() == null) break;
                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private WCSCoverage.AxisDescription parseAxisDescription(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean end = false;
        parser.require(2, null, "AxisDescription");
        WCSCoverage.AxisDescription as = new WCSCoverage.AxisDescription(this);
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("name") == 0) {
                        as.setName(parser.nextText());
                        break;
                    }
                    if (parser.getName().compareTo("label") == 0) {
                        as.setLabel(parser.nextText());
                        break;
                    }
                    if (parser.getName().compareTo("values") == 0) {
                        int valuesTag = parser.nextTag();
                        boolean valuesEnd = false;
                        while (!valuesEnd) {
                            switch (valuesTag) {
                                case 2: {
                                    if (parser.getName().compareTo("singleValue") == 0) {
                                        as.addSingleValues(parser.nextText());
                                        break;
                                    }
                                    if (parser.getName().compareTo("interval") == 0) {
                                        as.setInterval(parser.nextText());
                                        break;
                                    }
                                    if (parser.getName().compareTo("default") != 0) break;
                                    as.setDefaultValue(parser.nextText());
                                    break;
                                }
                                case 3: {
                                    if (parser.getName().compareTo("values") != 0) break;
                                    valuesEnd = true;
                                    break;
                                }
                                case 4: {
                                    if (parser.getName() == null) break;
                                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                                }
                            }
                            valuesTag = parser.next();
                        }
                        break;
                    }
                    if (parser.getName().compareTo("NullValues") == 0) {
                        System.err.println("Missing NULL VALUE PARSING on WCS 1.0.0 Client");
                        break;
                    }
                    System.out.println("Unrecognized " + parser.getName());
                    break;
                }
                case 3: {
                    if (parser.getName().compareToIgnoreCase("AxisDescription") != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (parser.getName() == null) break;
                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                }
            }
            currentTag = parser.next();
        }
        return as;
    }

    private void parseDomainSet(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean end = false;
        parser.require(2, null, "domainSet");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("spatialDomain") == 0) {
                        this.parseSpatialDomain(parser);
                        break;
                    }
                    if (parser.getName().compareTo("temporalDomain") != 0) break;
                    this.parseTemporalDomain(parser);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("domainSet") != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (parser.getName() == null) break;
                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                }
            }
            currentTag = parser.next();
        }
    }

    private void parseTemporalDomain(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean end = false;
        parser.require(2, null, "temporalDomain");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("gml:timePosition") == 0) {
                        this.addTimePosition(parser.nextText());
                        break;
                    }
                    if (parser.getName().compareTo("timePeriod") == 0) {
                        boolean timePeriodEnd = false;
                        int timePeriodTag = parser.next();
                        String[] myTimePeriod = new String[3];
                        while (!timePeriodEnd) {
                            switch (timePeriodTag) {
                                case 2: {
                                    if (parser.getName().compareTo("beginPosition") == 0) {
                                        myTimePeriod[0] = parser.nextText();
                                        break;
                                    }
                                    if (parser.getName().compareTo("endPosition") == 0) {
                                        myTimePeriod[1] = parser.nextText();
                                        break;
                                    }
                                    if (parser.getName().compareTo("timeResolution") == 0) {
                                        myTimePeriod[2] = parser.nextText();
                                        break;
                                    }
                                    System.out.println("Unrecognized " + parser.getName());
                                    break;
                                }
                                case 3: {
                                    if (parser.getName().compareTo("temporalDomain") != 0) break;
                                    end = true;
                                    break;
                                }
                                case 4: {
                                    if (parser.getName() == null) break;
                                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                                }
                            }
                            timePeriodTag = parser.next();
                        }
                        this.timePeriod = "";
                        for (int i = 0; i < myTimePeriod.length - 1; ++i) {
                            if (myTimePeriod[i] != null) {
                                this.timePeriod = this.timePeriod + myTimePeriod[i];
                            }
                            if (myTimePeriod[i + 1] == null) continue;
                            this.timePeriod = this.timePeriod + "/";
                        }
                        break;
                    }
                    System.out.println("Unrecognized " + parser.getName());
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("temporalDomain") != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (parser.getName() == null) break;
                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                }
            }
            currentTag = parser.next();
        }
    }

    private void parseSpatialDomain(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean end = false;
        parser.require(2, null, "spatialDomain");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("gml:Envelope") == 0) {
                        BoundaryBox bBox = this.parseGMLEnvelope(parser);
                        this.addBBox(bBox);
                        break;
                    }
                    if (parser.getName().compareTo("gml:Grid") == 0) {
                        this.parseGrid(parser);
                        break;
                    }
                    if (parser.getName().compareTo("gml:RectifiedGrid") == 0) {
                        this.parseRectifiedGrid(parser);
                        break;
                    }
                    System.out.println("Unrecognized " + parser.getName());
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("spatialDomain") != 0) break;
                    return;
                }
                case 4: {
                    if (parser.getName() == null) break;
                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                }
            }
            currentTag = parser.next();
        }
    }

    private void parseGrid(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean end = false;
        parser.require(2, null, "gml:Grid");
        this.rg = new WCSCoverage.RectifiedGrid(this, Integer.parseInt(parser.getAttributeValue("", "dimension")));
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("gml:limits") == 0) {
                        parser.nextTag();
                        if (parser.getName().compareTo("gml:GridEnvelope") != 0) break;
                        boolean gridEnd = false;
                        int gridCurrentTag = parser.next();
                        while (!gridEnd) {
                            switch (gridCurrentTag) {
                                case 2: {
                                    int i;
                                    int[] limits;
                                    String[] ss;
                                    String value;
                                    if (parser.getName().compareTo("gml:low") == 0) {
                                        value = parser.nextText();
                                        ss = StringUtils.split((String)value, (String)" +");
                                        limits = new int[ss.length];
                                        for (i = 0; i < limits.length; ++i) {
                                            limits[i] = Integer.parseInt(ss[i]);
                                        }
                                        this.rg.addLowGridEnvelopLimit(limits);
                                        break;
                                    }
                                    if (parser.getName().compareTo("gml:high") == 0) {
                                        value = parser.nextText();
                                        ss = StringUtils.split((String)value, (String)" +");
                                        limits = new int[ss.length];
                                        for (i = 0; i < limits.length; ++i) {
                                            limits[i] = Integer.parseInt(ss[i]);
                                        }
                                        this.rg.addHighGridEnvelopLimit(limits);
                                        break;
                                    }
                                    System.out.println("Unrecognized " + parser.getName());
                                    break;
                                }
                                case 3: {
                                    if (parser.getName().compareTo("gml:GridEnvelope") != 0) break;
                                    gridEnd = true;
                                    break;
                                }
                                case 4: {
                                    if (parser.getName() == null) break;
                                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                                }
                            }
                            gridCurrentTag = parser.next();
                        }
                        break;
                    }
                    if (parser.getName().compareTo("gml:axisName") == 0) {
                        this.rg.addAxisName(parser.nextText());
                        break;
                    }
                    System.out.println("Unrecognized " + parser.getName());
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("gml:Grid") != 0) break;
                    return;
                }
                case 4: {
                    if (parser.getName() == null) break;
                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                }
            }
            currentTag = parser.next();
        }
    }

    private void parseRectifiedGrid(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean end = false;
        parser.require(2, null, "gml:RectifiedGrid");
        this.rg = new WCSCoverage.RectifiedGrid(this, Integer.parseInt(parser.getAttributeValue("", "dimension")));
        this.rg.addToOffsetVector(new double[]{-1.0, -1.0});
        this.rg.addToOffsetVector(new double[]{-1.0, -1.0});
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    int i;
                    String value;
                    if (parser.getName().compareTo("gml:limits") == 0) {
                        parser.nextTag();
                        if (parser.getName().compareTo("gml:GridEnvelope") != 0) break;
                        boolean gridEnd = false;
                        int gridCurrentTag = parser.next();
                        while (!gridEnd) {
                            switch (gridCurrentTag) {
                                case 2: {
                                    int i2;
                                    int[] limits;
                                    String[] ss;
                                    if (parser.getName().compareTo("gml:low") == 0) {
                                        value = parser.nextText();
                                        ss = StringUtils.split((String)value, (String)" +");
                                        limits = new int[ss.length];
                                        for (i2 = 0; i2 < limits.length; ++i2) {
                                            limits[i2] = Integer.parseInt(ss[i2]);
                                        }
                                        this.rg.addLowGridEnvelopLimit(limits);
                                        break;
                                    }
                                    if (parser.getName().compareTo("gml:high") == 0) {
                                        value = parser.nextText();
                                        ss = StringUtils.split((String)value, (String)" +");
                                        limits = new int[ss.length];
                                        for (i2 = 0; i2 < limits.length; ++i2) {
                                            limits[i2] = Integer.parseInt(ss[i2]);
                                        }
                                        this.rg.addHighGridEnvelopLimit(limits);
                                        break;
                                    }
                                    System.out.println("Unrecognized " + parser.getName());
                                    break;
                                }
                                case 3: {
                                    if (parser.getName().compareTo("gml:GridEnvelope") != 0) break;
                                    gridEnd = true;
                                    break;
                                }
                                case 4: {
                                    if (parser.getName() == null) break;
                                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                                }
                            }
                            gridCurrentTag = parser.next();
                        }
                        break;
                    }
                    if (parser.getName().compareTo("gml:axisName") == 0) {
                        this.rg.addAxisName(parser.nextText());
                        break;
                    }
                    if (parser.getName().compareTo("gml:origin") == 0) {
                        parser.nextTag();
                        if (parser.getName().compareTo("gml:pos") != 0) break;
                        value = parser.nextText();
                        String[] ss = StringUtils.split((String)value, (String)" +");
                        double[] ori = new double[ss.length];
                        for (i = 0; i < ori.length; ++i) {
                            ori[i] = Double.parseDouble(ss[i]);
                        }
                        this.rg.setOrigin(ori);
                        break;
                    }
                    if (parser.getName().compareTo("gml:offsetVector") == 0) {
                        value = parser.nextText();
                        String[] ss = StringUtils.split((String)value, (String)" +");
                        double[] offset = new double[ss.length];
                        for (i = 0; i < offset.length; ++i) {
                            offset[i] = Double.parseDouble(ss[i]);
                        }
                        this.rg.addToOffsetVector(offset);
                        break;
                    }
                    System.out.println("Unrecognized " + parser.getName());
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("gml:RectifiedGrid") != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (parser.getName() == null) break;
                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private BoundaryBox parseLonLatGMLEnvelope(KXmlParser parser) throws XmlPullParserException, IOException {
        BoundaryBox bBox = new BoundaryBox();
        boolean end = false;
        parser.require(2, null, "lonLatEnvelope");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("gml:pos") != 0) break;
                    bBox.setSrs("WGS84(DD)");
                    String value = parser.nextText();
                    String[] coordinates = StringUtils.split((String)value, (String)" +");
                    double minx = Double.parseDouble(coordinates[0]);
                    double miny = Double.parseDouble(coordinates[1]);
                    parser.nextTag();
                    parser.require(2, null, "gml:pos");
                    value = parser.nextText();
                    coordinates = StringUtils.split((String)value, (String)" +");
                    double maxx = Double.parseDouble(coordinates[0]);
                    double maxy = Double.parseDouble(coordinates[1]);
                    bBox.setXmin(minx);
                    bBox.setYmin(miny);
                    bBox.setXmax(maxx);
                    bBox.setYmax(maxy);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("lonLatEnvelope") != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (parser.getName() == null) break;
                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                }
            }
            currentTag = parser.next();
        }
        return bBox;
    }

    private BoundaryBox parseGMLEnvelope(KXmlParser parser) throws XmlPullParserException, IOException {
        BoundaryBox bBox = new BoundaryBox();
        boolean end = false;
        parser.require(2, null, "gml:Envelope");
        bBox.setSrs(parser.getAttributeValue("", "srsName"));
        int currentTag = parser.next();
        boolean skipThisTag = false;
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("gml:pos") == 0) {
                        String value = parser.nextText();
                        String[] coordinates = StringUtils.split((String)value, (String)" +");
                        double minx = Double.parseDouble(coordinates[0]);
                        double miny = Double.parseDouble(coordinates[1]);
                        parser.nextTag();
                        parser.require(2, null, "gml:pos");
                        value = parser.nextText();
                        coordinates = StringUtils.split((String)value, (String)" +");
                        double maxx = Double.parseDouble(coordinates[0]);
                        double maxy = Double.parseDouble(coordinates[1]);
                        bBox.setXmin(minx);
                        bBox.setYmin(miny);
                        bBox.setXmax(maxx);
                        bBox.setYmax(maxy);
                        break;
                    }
                    skipThisTag = true;
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("gml:Envelope") != 0) break;
                    end = true;
                    skipThisTag = true;
                    break;
                }
                case 4: {
                    if (parser.getName() == null) break;
                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                }
            }
            if (skipThisTag) continue;
            currentTag = parser.next();
        }
        return bBox;
    }
}

