/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader.swing.scribejava.keycloak;

import com.github.scribejava.apis.openid.OpenIdJsonTokenExtractor;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;

public class KeycloakApi2
extends DefaultApi20 {
    private static final ConcurrentMap<String, KeycloakApi2> INSTANCES = new ConcurrentHashMap<String, KeycloakApi2>();
    private final String baseUrlWithRealm;

    protected KeycloakApi2(String baseUrlWithRealm) {
        this.baseUrlWithRealm = baseUrlWithRealm;
    }

    public static KeycloakApi2 instance() {
        return KeycloakApi2.instance("http://localhost:8080/", "master");
    }

    public static KeycloakApi2 instance(String baseUrl, String realm) {
        KeycloakApi2 alreadyCreatedApi;
        String defaultBaseUrlWithRealm = KeycloakApi2.composeBaseUrlWithRealm(baseUrl, realm);
        KeycloakApi2 api = (KeycloakApi2)((Object)INSTANCES.get(defaultBaseUrlWithRealm));
        if (api == null && (alreadyCreatedApi = INSTANCES.putIfAbsent(defaultBaseUrlWithRealm, api = new KeycloakApi2(defaultBaseUrlWithRealm))) != null) {
            return alreadyCreatedApi;
        }
        return api;
    }

    protected static String composeBaseUrlWithRealm(String baseUrl, String realm) {
        if (!StringUtils.endsWith((CharSequence)baseUrl, (CharSequence)"/")) {
            baseUrl = baseUrl + "/";
        }
        baseUrl = StringUtils.endsWith((CharSequence)baseUrl, (CharSequence)"/realms/") ? baseUrl + realm : baseUrl + "auth/realms/" + realm;
        return baseUrl;
    }

    public String getAccessTokenEndpoint() {
        return this.baseUrlWithRealm + "/protocol/openid-connect/token";
    }

    protected String getAuthorizationBaseUrl() {
        return this.baseUrlWithRealm + "/protocol/openid-connect/auth";
    }

    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        return OpenIdJsonTokenExtractor.instance();
    }

    public String getRevokeTokenEndpoint() {
        throw new RuntimeException("Not implemented yet");
    }

    public String getUserInfoEndpoint() {
        return this.baseUrlWithRealm + "/protocol/openid-connect/userinfo";
    }

    public String getLogoutEndpoint(String clientid, String redirect_uri) {
        String redirect_uri_name = "post_logout_redirect_uri";
        String logoutUrl = String.format("%s/protocol/openid-connect/logout?%s=%s&client_id=%s", this.baseUrlWithRealm, redirect_uri_name, redirect_uri, clientid);
        return logoutUrl;
    }
}

