/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader.swing.scribejava.keycloak.callbacks;

import com.github.scribejava.core.oauth.OAuth20Service;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.downloader.swing.scribejava.keycloak.DownloaderAuthenticationKeycloakConfig;
import org.gvsig.downloader.swing.scribejava.keycloak.DownloaderAuthenticationKeycloakFactory;
import org.gvsig.downloader.swing.scribejava.keycloak.DownloaderAuthenticationKeycloakRequester;
import org.gvsig.downloader.swing.scribejava.keycloak.callbacks.CallbackAuthorizationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCallback {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CallbackAuthorizationHandler.class);
    protected final OAuth20Service service;
    protected final DownloaderAuthenticationKeycloakRequester identificationRequester;
    protected final String contextPath;
    protected boolean aborted;

    public AbstractCallback(DownloaderAuthenticationKeycloakRequester identificationRequester, OAuth20Service service, String contextPath) {
        this.contextPath = contextPath;
        this.service = service;
        this.identificationRequester = identificationRequester;
        this.aborted = false;
    }

    protected DownloaderAuthenticationKeycloakConfig getConfig() {
        return this.identificationRequester.getConfig();
    }

    protected void response(HttpExchange t, int code, String body) throws IOException {
        t.sendResponseHeaders(code, body.length());
        try (OutputStream os = t.getResponseBody();){
            os.write(body.getBytes());
        }
    }

    protected void responseQuietly(HttpExchange t, int code, String body) {
        try {
            this.response(t, code, body);
        }
        catch (Exception e) {
            LOGGER.warn("Can't generate response.", (Throwable)e);
        }
    }

    public void remove() throws IOException {
        DownloaderAuthenticationKeycloakConfig config = this.identificationRequester.getConfig();
        DownloaderAuthenticationKeycloakFactory factory = config.getFactory();
        factory.removeCallback(config, this.contextPath);
        this.aborted = true;
    }

    public void stopWaitingForResponse() {
        if (this.aborted) {
            return;
        }
        this.identificationRequester.stopWaitingForResponse();
    }

    public String message_and_close(String s) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>\n");
        builder.append("<body  onclick=\"self.opener=this;self.close();\">\n");
        builder.append(StringUtils.replace((String)s, (String)"\n", (String)"<br>\n"));
        builder.append("</body>\n");
        builder.append("</html>\n");
        return builder.toString();
    }

    public String message(String s) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>\n");
        builder.append("<body >\n");
        builder.append(StringUtils.replace((String)s, (String)"\n", (String)"<br>\n"));
        builder.append("</body>\n");
        builder.append("</html>\n");
        return builder.toString();
    }
}

