/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader.swing.scribejava.keycloak.callbacks;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuth2Authorization;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import javax.json.JsonObject;
import org.gvsig.downloader.swing.scribejava.DownloaderSwingScribejavaLibrary;
import org.gvsig.downloader.swing.scribejava.keycloak.DownloaderAuthenticationKeycloakRequester;
import org.gvsig.downloader.swing.scribejava.keycloak.DownloaderKeycloakCredentials;
import org.gvsig.downloader.swing.scribejava.keycloak.callbacks.AbstractCallback;

public class CallbackAuthorizationHandler
extends AbstractCallback
implements HttpHandler {
    public CallbackAuthorizationHandler(DownloaderAuthenticationKeycloakRequester identificationRequester, OAuth20Service service, String contextPath) {
        super(identificationRequester, service, contextPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange t) throws IOException {
        String requestURL = "Unknown";
        try {
            long now = System.currentTimeMillis();
            DownloaderSwingScribejavaLibrary.disableHttpsValidation();
            requestURL = t.getRequestURI().toString();
            OAuth2Authorization auth = this.service.extractAuthorization(t.getRequestURI().toString());
            if (auth.getCode() == null) {
                this.identificationRequester.setCredentials(null);
                this.response(t, 200, this.message("Can't autthenticate user\n"));
                return;
            }
            OAuth2AccessToken accessToken = this.service.getAccessToken(auth.getCode());
            this.identificationRequester.setCredentials(new DownloaderKeycloakCredentials(this.getConfig(), accessToken, null, now));
            String userId = null;
            JsonObject userinfo = this.identificationRequester.userInfo(this.service);
            userId = userinfo != null ? userinfo.getString("preferred_username", null) : "unkown" + accessToken.getAccessToken().hashCode();
            this.identificationRequester.setCredentials(new DownloaderKeycloakCredentials(this.getConfig(), accessToken, userId, now));
            this.response(t, 200, this.message_and_close(userId == null ? "\n\n\n\n\n\n\n\n\n\n<p align=\"center\">User authenticated</p>\n\n<p align=\"center\"><button type=\"button\" onclick=\"self.close()\">Close this window</button></p>\n\n" : "\n\n\n\n\n\n\n\n\n\n<p align=\"center\">User " + userId + " authenticated</p>\n\n<p align=\"center\"><button type=\"button\" onclick=\"self.close();\">Close this window</button></p>\n\n"));
        }
        catch (Exception ex) {
            this.identificationRequester.setCredentials(null);
            LOGGER.warn("Can't process callback authorization (contextPath '" + this.contextPath + "', request URL '" + requestURL + "')", (Throwable)ex);
            this.responseQuietly(t, 500, this.message("Can't authenticate user\n" + ex.getMessage()));
        }
        finally {
            this.stopWaitingForResponse();
        }
    }
}

