/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.smoothline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Spline;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.prov.smoothline.BSpline;
import org.gvsig.vectorediting.lib.prov.smoothline.Bezier;
import org.gvsig.vectorediting.lib.prov.smoothline.ControlCurve;
import org.gvsig.vectorediting.lib.prov.smoothline.NatCubic;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class SmoothLineEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter selection;
    private final EditingServiceParameter steps;
    private final EditingServiceParameter algorithm;
    private final FeatureStore featureStore;
    private Map<EditingServiceParameter, Object> values;
    public static final String NATURAL_CUBIC_SPLINES = "natural_cubic_splines";
    public static final String BEZIER_CURVES = "bezier_curves";
    public static final String BSPLINES = "b_splines";

    public SmoothLineEditingProvider(DynObject parameters, ProviderServices services) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.selection = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.steps = new DefaultEditingServiceParameter("steps", "intermediate_steps_1_9", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        DefaultEditingServiceParameterOptions options = new DefaultEditingServiceParameterOptions().add(i18nManager.getTranslation(NATURAL_CUBIC_SPLINES), (Object)NATURAL_CUBIC_SPLINES, i18nManager.getTranslation("key_natural_cubic_splines")).add(i18nManager.getTranslation(BEZIER_CURVES), (Object)BEZIER_CURVES, i18nManager.getTranslation("key_bezier_curves")).add(i18nManager.getTranslation(BSPLINES), (Object)BSPLINES, i18nManager.getTranslation("key_b_splines"));
        String consoleMsg = editingProviderServices.makeConsoleMessage(null, (EditingServiceParameterOptions)options);
        this.algorithm = new DefaultEditingServiceParameter("algorithm", consoleMsg, (EditingServiceParameterOptions)options, null, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(8);
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selection) == null) {
            return this.selection;
        }
        if (this.values.get(this.steps) == null) {
            return this.steps;
        }
        if (this.values.get(this.algorithm) == null) {
            return this.algorithm;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        return null;
    }

    public void stop() throws StopServiceException {
        if (this.values != null) {
            this.values.clear();
        }
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selection);
        parameters.add(this.steps);
        parameters.add(this.algorithm);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        if (parameter == this.selection) {
            FeatureSelection featureSelection = (FeatureSelection)value;
            if (featureSelection.getSelectedCount() > 0L) {
                try {
                    featureSelection.accept(obj -> {
                        Feature feature = (Feature)obj;
                        Geometry geometry = feature.getDefaultGeometry();
                        GeometryType geometryType = geometry.getGeometryType();
                        if (!geometryType.isTypeOf(2) && !geometryType.isTypeOf(8)) {
                            throw new InvalidEntryException(null);
                        }
                    });
                    this.values.put(this.selection, value);
                    return;
                }
                catch (BaseException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
        } else if (parameter == this.steps) {
            Integer stepsValue;
            if (value instanceof Double && (stepsValue = Integer.valueOf(((Double)value).intValue())) > 0 && stepsValue < 10) {
                this.values.put(this.steps, stepsValue);
                return;
            }
        } else if (parameter == this.algorithm) {
            if (value instanceof String) {
                this.values.put(parameter, (String)parameter.getOptions2().getValue(value, parameter.getDefaultValue()));
                return;
            }
            throw new InvalidEntryException(null);
        }
        throw new InvalidEntryException(null);
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        if (this.values != null) {
            FeatureSelection featureSelection = (FeatureSelection)this.values.get(this.selection);
            ToolsLocator.getDisposableManager().bind((Disposable)featureSelection);
            Integer stepsValue = (Integer)this.values.get(this.steps);
            String algorithmValue = (String)this.values.get(this.algorithm);
            EditingProviderServices editingProviderServices = this.getProviderServices();
            try {
                int subtype = editingProviderServices.getSubType(this.featureStore);
                featureSelection.accept(obj -> {
                    Feature feature = (Feature)obj;
                    Geometry geometry = feature.getDefaultGeometry();
                    GeometryType geoType = geometry.getGeometryType();
                    if (geoType.isTypeOf(6)) {
                        MultiCurve multiCurveToSmooth = (MultiCurve)geometry;
                        MultiCurve multiCurveSmoothed = GeometryLocator.getGeometryManager().createMultiCurve(subtype);
                        for (int i = 0; i < multiCurveToSmooth.getPrimitivesNumber(); ++i) {
                            Curve curveToSmooth = (Curve)multiCurveToSmooth.getPrimitiveAt(i);
                            curveToSmooth = this.smoothLine(curveToSmooth, stepsValue, algorithmValue);
                            multiCurveSmoothed.addCurve(curveToSmooth);
                            geometry = multiCurveSmoothed;
                        }
                    } else {
                        Curve curveToSmooth = (Curve)geometry;
                        curveToSmooth = this.smoothLine(curveToSmooth, stepsValue, algorithmValue);
                        geometry = curveToSmooth;
                    }
                    EditableFeature eFeature = feature.getEditable();
                    eFeature.setDefaultGeometry(geometry);
                    editingProviderServices.updateFeatureInFeatureStore((Feature)eFeature, this.featureStore);
                });
                this.featureStore.getFeatureSelection().deselectAll();
                featureSelection.dispose();
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    private Line smoothLine(Curve curveToSmooth, Integer steps, String algorithm) throws DataException, CreateGeometryException {
        ControlCurve operation;
        Line lineToSmooth;
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        int subtype = editingProviderServices.getSubType(this.featureStore);
        if (curveToSmooth instanceof Arc || curveToSmooth instanceof Spline) {
            lineToSmooth = geometryManager.createLine(curveToSmooth.getGeometryType().getSubType());
            lineToSmooth.setGeneralPath(curveToSmooth.getGeneralPath());
        } else {
            lineToSmooth = (Line)curveToSmooth;
        }
        if (algorithm.equalsIgnoreCase(NATURAL_CUBIC_SPLINES)) {
            operation = new NatCubic(lineToSmooth);
        } else if (algorithm.equalsIgnoreCase(BEZIER_CURVES)) {
            operation = new Bezier(lineToSmooth);
        } else if (algorithm.equalsIgnoreCase(BSPLINES)) {
            operation = new BSpline(lineToSmooth);
        } else {
            return null;
        }
        return ((ControlCurve)operation).getSmoothedLine(steps, subtype);
    }

    private Line simplifyLine(Curve curveToSimplify, Double toleranceValue) throws DataException, CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        int subtype = editingProviderServices.getSubType(this.featureStore);
        Line simplifiedLine = GeometryLocator.getGeometryManager().createLine(subtype);
        simplifiedLine.addVertex(curveToSimplify.getVertex(0));
        for (int i = 0; i < curveToSimplify.getNumVertices() - 2; ++i) {
            Point vertex = curveToSimplify.getVertex(i);
            Point nextVertex = curveToSimplify.getVertex(i + 1);
            Point nextNextVertex = curveToSimplify.getVertex(i + 2);
            Line tmpLine = editingProviderServices.createLine(vertex, nextNextVertex, subtype);
            if (tmpLine.distance((Geometry)nextVertex) > toleranceValue) {
                simplifiedLine.addVertex(nextVertex);
                continue;
            }
            ++i;
        }
        simplifiedLine.addVertex(curveToSimplify.getVertex(curveToSimplify.getNumVertices() - 1));
        return simplifiedLine;
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        FeatureSelection selected = null;
        if (this.featureStore != null) {
            try {
                selected = this.featureStore.getFeatureSelection();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            if (selected.getSelectedCount() > 0L) {
                try {
                    this.setValue(selected);
                }
                catch (InvalidEntryException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
        }
    }

    public String getName() {
        return "modify-smooth-line";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

