/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.reproject.algorithm;

import java.awt.geom.Point2D;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.dataset.BufferParam;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.util.Interpolation;
import org.gvsig.raster.reproject.algorithm.ReprojectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reproject {
    private RasterDataStore store = null;
    private String pathDest = null;
    private int interpolationMethod = 0;
    private Interpolation interpolation = null;
    private DataProcess process = null;
    private static final Logger logger = LoggerFactory.getLogger(Reproject.class);

    public Reproject(RasterDataStore store, String pathDest, int inter, DataProcess process) {
        this.store = store;
        this.pathDest = pathDest;
        this.interpolationMethod = inter;
        this.process = process;
    }

    public int warp(IProjection destinationSrs, IProjection sourceSrs, int w, int h, double cellSize) throws ReprojectException {
        if (this.store == null) {
            throw new ReprojectException("Capa no valida.");
        }
        if (!this.store.isReproyectable()) {
            throw new ReprojectException("Esta capa no se puede reproyectar.");
        }
        if (destinationSrs == null || destinationSrs.getAbrev() == null) {
            throw new ReprojectException("Proyecci\u00f3n de destino no valida.");
        }
        File file = new File(this.pathDest);
        if (!file.getParentFile().canWrite()) {
            throw new ReprojectException("Ruta de destino no valida.");
        }
        ICoordTrans transf = sourceSrs.getCT(destinationSrs);
        Extent bbox = this.store.getExtent();
        Point2D ul = new Point2D.Double(bbox.getULX(), bbox.getULY());
        Point2D lr = new Point2D.Double(bbox.getLRX(), bbox.getLRY());
        ul = transf.convert(ul, ul);
        lr = transf.convert(lr, lr);
        Extent newBbox = RasterLocator.getManager().getDataStructFactory().createExtent(ul, lr);
        if (w <= 0 || h <= 0) {
            double[] size = this.getSize(bbox, newBbox);
            w = (int)size[0];
            h = (int)size[1];
            cellSize = size[2];
        }
        int dataType = this.store.getDataType()[0];
        BufferParam params = RasterLocator.getManager().getBufferFactory().createBufferParams(w, h, this.store.getBandCount(), this.store.getDataType()[0], true);
        Buffer buf = null;
        try {
            buf = RasterLocator.getManager().getBufferFactory().createBuffer(params);
        }
        catch (Exception e1) {
            throw new ReprojectException("Error creating the output buffer", e1);
        }
        NoData nd = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(this.store.getBandCount(), dataType);
        RasterQuery query = RasterLocator.getManager().createQuery();
        query.setAllDrawableBands();
        query.setAreaOfInterest();
        query.setReadOnly(true);
        try {
            boolean exported;
            int row;
            ICoordTrans t = destinationSrs.getCT(sourceSrs);
            Buffer sourceBuffer = this.store.query(query);
            if (this.interpolationMethod < 0) {
                for (row = 0; row < buf.getHeight(); ++row) {
                    for (int col = 0; col < buf.getWidth(); ++col) {
                        Point2D p = this.transformPoint(newBbox, col, row, cellSize, t);
                        this.writePixel(dataType, sourceBuffer, buf, p, col, row, nd);
                    }
                    this.process.updatePercent(row, buf.getHeight());
                }
            } else {
                this.interpolation = new Interpolation(sourceBuffer);
                for (row = 0; row < buf.getHeight(); ++row) {
                    for (int col = 0; col < buf.getWidth(); ++col) {
                        Point2D p = this.transformPoint(newBbox, col, row, cellSize, t);
                        this.writePixelInterpolated(dataType, sourceBuffer, buf, p, col, row, nd, this.interpolationMethod);
                    }
                    this.process.updatePercent(row, buf.getHeight());
                }
            }
            if (exported = this.process.exportRaster(this.pathDest, buf, cellSize, newBbox.getULX(), newBbox.getULY())) {
                this.savePrjFile(file, destinationSrs);
            }
        }
        catch (ProcessInterruptedException t) {
        }
        catch (QueryException e) {
            new ReprojectException("", e);
        }
        return 0;
    }

    private void savePrjFile(File dataFile, IProjection proj) {
        File file = new File(FilenameUtils.removeExtension((String)dataFile.getAbsolutePath()) + ".prj");
        try {
            String export = proj.export("wkt_esri");
            if (export != null) {
                FileUtils.writeStringToFile((File)file, (String)export);
            }
        }
        catch (Exception e) {
            logger.info("Can't write prj file '" + file.getAbsolutePath() + "'.");
        }
    }

    private void writePixel(int type, Buffer sourceBuffer, Buffer buf, Point2D p, int col, int row, NoData nd) {
        block21: {
            block24: {
                block23: {
                    block22: {
                        block20: {
                            if (type != 0) break block20;
                            if (p.getX() > 0.0 && p.getX() < (double)sourceBuffer.getWidth() && p.getY() > 0.0 && p.getY() < (double)sourceBuffer.getHeight()) {
                                for (int iBand = 0; iBand < this.store.getBandCount(); ++iBand) {
                                    buf.setElem(row, col, iBand, sourceBuffer.getElemByte((int)p.getY(), (int)p.getX(), iBand));
                                }
                            } else {
                                for (int iBand = 0; iBand < this.store.getBandCount(); ++iBand) {
                                    buf.setElem(row, col, iBand, nd.getValue().byteValue());
                                }
                            }
                            break block21;
                        }
                        if (type != 5) break block22;
                        if (p.getX() > 0.0 && p.getX() < (double)sourceBuffer.getWidth() && p.getY() > 0.0 && p.getY() < (double)sourceBuffer.getHeight()) {
                            for (int iBand = 0; iBand < this.store.getBandCount(); ++iBand) {
                                buf.setElem(row, col, iBand, sourceBuffer.getElemDouble((int)p.getY(), (int)p.getX(), iBand));
                            }
                        } else {
                            for (int iBand = 0; iBand < this.store.getBandCount(); ++iBand) {
                                buf.setElem(row, col, iBand, nd.getValue().doubleValue());
                            }
                        }
                        break block21;
                    }
                    if (type != 4) break block23;
                    if (p.getX() > 0.0 && p.getX() < (double)sourceBuffer.getWidth() && p.getY() > 0.0 && p.getY() < (double)sourceBuffer.getHeight()) {
                        for (int iBand = 0; iBand < this.store.getBandCount(); ++iBand) {
                            buf.setElem(row, col, iBand, sourceBuffer.getElemFloat((int)p.getY(), (int)p.getX(), iBand));
                        }
                    } else {
                        for (int iBand = 0; iBand < this.store.getBandCount(); ++iBand) {
                            buf.setElem(row, col, iBand, nd.getValue().floatValue());
                        }
                    }
                    break block21;
                }
                if (type != 2) break block24;
                if (p.getX() > 0.0 && p.getX() < (double)sourceBuffer.getWidth() && p.getY() > 0.0 && p.getY() < (double)sourceBuffer.getHeight()) {
                    for (int iBand = 0; iBand < this.store.getBandCount(); ++iBand) {
                        buf.setElem(row, col, iBand, sourceBuffer.getElemShort((int)p.getY(), (int)p.getX(), iBand));
                    }
                } else {
                    for (int iBand = 0; iBand < this.store.getBandCount(); ++iBand) {
                        buf.setElem(row, col, iBand, nd.getValue().shortValue());
                    }
                }
                break block21;
            }
            if (type != 3) break block21;
            if (p.getX() > 0.0 && p.getX() < (double)sourceBuffer.getWidth() && p.getY() > 0.0 && p.getY() < (double)sourceBuffer.getHeight()) {
                for (int iBand = 0; iBand < this.store.getBandCount(); ++iBand) {
                    buf.setElem(row, col, iBand, sourceBuffer.getElemInt((int)p.getY(), (int)p.getX(), iBand));
                }
            } else {
                for (int iBand = 0; iBand < this.store.getBandCount(); ++iBand) {
                    buf.setElem(row, col, iBand, nd.getValue().intValue());
                }
            }
        }
    }

    private void writePixelInterpolated(int type, Buffer sourceBuffer, Buffer buf, Point2D p, int col, int row, NoData nd, int interpMethod) {
        double value = 0.0;
        if (p.getX() > 0.0 && p.getX() < (double)sourceBuffer.getWidth() && p.getY() > 0.0 && p.getY() < (double)sourceBuffer.getHeight()) {
            for (int iBand = 0; iBand < this.store.getBandCount(); ++iBand) {
                if (interpMethod == 0) {
                    value = this.interpolation.getNearestNeighbour(p.getX(), p.getY(), iBand);
                }
                if (interpMethod == 1) {
                    value = this.interpolation.getBilinearValue(p.getX(), p.getY(), iBand);
                }
                if (interpMethod == 2) {
                    value = this.interpolation.getInverseDistance(p.getX(), p.getY(), iBand);
                }
                if (type == 0) {
                    buf.setElem(row, col, iBand, (byte)value);
                    continue;
                }
                if (type == 5) {
                    buf.setElem(row, col, iBand, value);
                    continue;
                }
                if (type == 4) {
                    buf.setElem(row, col, iBand, (float)value);
                    continue;
                }
                if (type == 2) {
                    buf.setElem(row, col, iBand, (short)value);
                    continue;
                }
                if (type != 3) continue;
                buf.setElem(row, col, iBand, (int)value);
            }
        } else {
            for (int iBand = 0; iBand < this.store.getBandCount(); ++iBand) {
                if (type == 0) {
                    buf.setElem(row, col, iBand, nd.getValue().byteValue());
                    continue;
                }
                if (type == 5) {
                    buf.setElem(row, col, iBand, nd.getValue().doubleValue());
                    continue;
                }
                if (type == 4) {
                    buf.setElem(row, col, iBand, nd.getValue().floatValue());
                    continue;
                }
                if (type == 2) {
                    buf.setElem(row, col, iBand, nd.getValue().shortValue());
                    continue;
                }
                if (type != 3) continue;
                buf.setElem(row, col, iBand, nd.getValue().intValue());
            }
        }
    }

    private Point2D transformPoint(Extent newBbox, int col, int row, double cellSize, ICoordTrans t) {
        Point2D p = new Point2D.Double(newBbox.getULX() + (double)col * cellSize, newBbox.getULY() - (double)row * cellSize);
        p = t.convert(p, p);
        p = this.store.worldToRaster(p);
        return p;
    }

    private double[] getSize(Extent bbox, Extent newBbox) {
        double sumSideOldBBox = bbox.width() + bbox.height();
        double sumSideNewBBox = newBbox.width() + newBbox.height();
        double d1x = bbox.width() * 100.0 / sumSideOldBBox;
        double d1y = bbox.height() * 100.0 / sumSideOldBBox;
        double d2x = newBbox.width() * 100.0 / sumSideNewBBox;
        double d2y = newBbox.height() * 100.0 / sumSideNewBBox;
        double p2y = this.store.getHeight() * d2y / d1y;
        double p2x = this.store.getWidth() * d2x / d1x;
        double newCellSize = newBbox.width() / p2x;
        return new double[]{Math.round(p2x), Math.round(p2y), newCellSize};
    }
}

