/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.app.mainplugin;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.OpenDataStoreParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.report.lib.api.ReportDataSets;
import org.gvsig.report.lib.api.ReportLocator;
import org.gvsig.report.lib.api.ReportManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddDatasetFromCatalogAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddDatasetFromCatalogAction.class);
    public static final String NAME = "PublishForReportDesigner";

    public AddDatasetFromCatalogAction() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.putValue("ActionCommandKey", NAME);
        this.putValue("Name", i18n.getTranslation("_Publish_for_report_designer"));
        this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("report-publish-layer"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            ReportManager reportManager = ReportLocator.getReportManager();
            ReportDataSets datasets = reportManager.getDefaultServer().getConfig().getDatasets();
            OpenDataStoreParameters storeParams = (OpenDataStoreParameters)e.getSource();
            DataManager dataManager = DALLocator.getDataManager();
            DataStore store = dataManager.openStore(storeParams.getProviderName(), (DataStoreParameters)storeParams);
            datasets.add(store.getName(), (FeatureStore)store);
        }
        catch (Exception ex) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog(i18n.getTranslation("_The_indicated_data_source_does_not_support_this_operation"), null, i18n.getTranslation("_Warning"), 2, "CantPublishStoreForReportDesigner");
            LOGGER.warn("Can't publish store for report designer.", (Throwable)ex);
        }
    }
}

