/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.app.mainplugin.document.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.gui.IDocumentWindow;
import org.gvsig.app.project.documents.gui.WindowLayout;
import org.gvsig.report.app.mainplugin.document.ReportDocument;
import org.gvsig.report.swing.api.JReport;
import org.gvsig.report.swing.api.ReportSwingLocator;
import org.gvsig.report.swing.api.ReportSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class ReportDocumentPanel
extends JPanel
implements IDocumentWindow {
    private static final int DEFAULT_HEIGHT = 450;
    private static final int DEFAULT_WIDTH = 700;
    private WindowLayout windowLayout;
    private WindowInfo windowInfo;
    private ReportDocument document;

    public ReportDocumentPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public WindowLayout getWindowLayout() {
        if (this.windowLayout == null) {
            this.windowLayout = new WindowLayout();
        }
        this.windowLayout.set("MainWindow.X", Integer.toString(this.getX()));
        this.windowLayout.set("MainWindow.Y", Integer.toString(this.getY()));
        this.windowLayout.set("MainWindow.Width", Integer.toString(this.getWidth()));
        this.windowLayout.set("MainWindow.Height", Integer.toString(this.getHeight()));
        return this.windowLayout;
    }

    public void setWindowLayout(WindowLayout layout) {
        this.windowLayout = layout;
    }

    public void setDocument(Document document) {
        this.document = (ReportDocument)document;
        ReportSwingManager swingManager = ReportSwingLocator.getReportSwingManager();
        JReport reportPanel = swingManager.createJReport(this.document.getReport());
        this.removeAll();
        this.add((Component)reportPanel.asJComponent(), "Center");
        this.revalidate();
    }

    public ReportDocument getDocument() {
        return this.document;
    }

    public WindowInfo getWindowInfo() {
        if (this.windowInfo == null) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.windowInfo = new WindowInfo(7);
            this.windowInfo.setWidth(700);
            this.windowInfo.setHeight(450);
            this.windowInfo.setTitle(i18n.getTranslation("_Report") + ": " + this.getDocument().getName());
        }
        return this.windowInfo;
    }

    public Object getWindowProfile() {
        return WindowInfo.EDITOR_PROFILE;
    }

    public void windowActivated() {
    }

    public void windowClosed() {
    }

    public Object getWindowModel() {
        return this.getDocument();
    }
}

