/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.offset.lib.prov.offset;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Circumference;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Ellipse;
import org.gvsig.fmap.geom.primitive.FilledSpline;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.PeriEllipse;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Spline;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.ISimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class OffsetEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private static final Double PRECISION = 1.0E-5;
    private static final String SIDE = "_side";
    private static final String LEFT = "_left";
    private static final String RIGHT = "_right";
    private static final String SHORT_LEFT = "_short_left";
    private static final String SHORT_RIGHT = "_short_right";
    private static final String JOIN_STYLE = "_join_style";
    private static final String ROUND = "_round";
    private static final String MITRE = "_mitre";
    private static final String BEVEL = "_bevel";
    private static final String SHORT_ROUND = "_short_round";
    private static final String SHORT_MITRE = "_short_mitre";
    private static final String SHORT_BEVEL = "_short_bevel";
    private final EditingServiceParameter selectionParameter;
    private final EditingServiceParameter offsetParameter;
    private final EditingServiceParameter sideParameter;
    private final DefaultEditingServiceParameter joinStyleParameter;
    private final EditingServiceParameter equidistantOffsets;
    private final EditingServiceParameter deleteOriginalGeometriesParameter;
    private Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;
    private List<Feature> selectedFeatures;

    public OffsetEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        this.selectionParameter = new DefaultEditingServiceParameter("selection", i18nManager.getTranslation("selection"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.offsetParameter = new DefaultEditingServiceParameter("offset_distance", i18nManager.getTranslation("offset_distance"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.VALUE, EditingServiceParameter.TYPE.DISTANCE});
        HashMap<String, String> sideOptions = new HashMap<String, String>();
        sideOptions.put(i18nManager.getTranslation(SHORT_LEFT), i18nManager.getTranslation(LEFT));
        sideOptions.put(i18nManager.getTranslation(SHORT_RIGHT), i18nManager.getTranslation(RIGHT));
        String sideConsoleMsg = ((EditingProviderServices)providerServices).makeConsoleMessage(i18nManager.getTranslation(SIDE), sideOptions);
        this.sideParameter = new DefaultEditingServiceParameter("side", sideConsoleMsg, sideOptions, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION, EditingServiceParameter.TYPE.POSITION}).setDataType(8);
        DefaultEditingServiceParameterOptions joinStyleOptions = new DefaultEditingServiceParameterOptions().add(i18nManager.getTranslation(ROUND), (Object)ROUND, i18nManager.getTranslation(SHORT_ROUND)).add(i18nManager.getTranslation(MITRE), (Object)MITRE, i18nManager.getTranslation(SHORT_MITRE)).add(i18nManager.getTranslation(BEVEL), (Object)BEVEL, i18nManager.getTranslation(SHORT_BEVEL));
        String joinStyleConsoleMsg = ((EditingProviderServices)providerServices).makeConsoleMessage(i18nManager.getTranslation(JOIN_STYLE), (EditingServiceParameterOptions)joinStyleOptions);
        this.joinStyleParameter = new DefaultEditingServiceParameter("joinStyle", joinStyleConsoleMsg, (EditingServiceParameterOptions)joinStyleOptions, (Object)i18nManager.getTranslation(SHORT_ROUND), true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION});
        this.joinStyleParameter.setDefaultValue((Object)ROUND);
        this.equidistantOffsets = new DefaultEditingServiceParameter("equidistant_offsets", "equidistant_offsets", true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
        this.equidistantOffsets.setDefaultValue((Object)1);
        DefaultEditingServiceParameterOptions deleteOriginalGeometriesOptions2 = new DefaultEditingServiceParameterOptions().add("delete_original_geometries", (Object)true, i18nManager.getTranslation("_yes")).add("keep_original_geometries", (Object)false, i18nManager.getTranslation("_no"));
        String consoleMsg = editingProviderServices.makeConsoleMessage("delete_original_geometries_question", (EditingServiceParameterOptions)deleteOriginalGeometriesOptions2);
        this.deleteOriginalGeometriesParameter = new DefaultEditingServiceParameter(i18nManager.getTranslation("delete_original_geometries"), consoleMsg, (EditingServiceParameterOptions)deleteOriginalGeometriesOptions2, (Object)false, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(1);
    }

    public EditingServiceParameter next() {
        Double distance;
        Object offsetValue;
        if (this.values.get(this.selectionParameter) == null) {
            return this.selectionParameter;
        }
        if (this.values.get(this.offsetParameter) == null) {
            return this.offsetParameter;
        }
        if (this.values.get(this.sideParameter) == null && !((offsetValue = this.values.get(this.offsetParameter)) instanceof Point) && (distance = (Double)offsetValue) >= 0.0) {
            return this.sideParameter;
        }
        if (this.values.get(this.deleteOriginalGeometriesParameter) == null) {
            return this.deleteOriginalGeometriesParameter;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus drawingStatus;
        block19: {
            int subtype;
            drawingStatus = new DefaultDrawingStatus();
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            EditingProviderServices editingProviderServices = this.getProviderServices();
            try {
                subtype = editingProviderServices.getSubType(this.featureStore);
            }
            catch (DataException e2) {
                throw new DrawServiceException((Throwable)e2);
            }
            ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
            ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
            ISymbol auxiliaryLineSymbolEditingDirection = editingProviderManager.getSymbol("auxiliary-line-symbol-editing-direction");
            ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
            ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
            if (this.values != null) {
                Number equidistantOffsetsNumberValue = (Number)this.values.get(this.equidistantOffsets);
                int equidistantOffsetsValue = equidistantOffsetsNumberValue != null ? equidistantOffsetsNumberValue.intValue() : ((Number)this.equidistantOffsets.getDefaultValue()).intValue();
                try {
                    Point point;
                    if (!CollectionUtils.isNotEmpty(this.selectedFeatures)) break block19;
                    double distance = 0.0;
                    double side = 1.0;
                    Object offsetValue = this.values.get(this.offsetParameter);
                    if (offsetValue != null) {
                        distance = offsetValue instanceof Point ? Math.abs(this.getMinDistance(this.selectedFeatures, (Point)offsetValue)) : (Double)offsetValue;
                        Object sideValue = this.values.get(this.sideParameter);
                        if (sideValue == null) {
                            point = mousePosition;
                            side = Math.signum(this.getMinDistance(this.selectedFeatures, point));
                        } else {
                            Double signum = this.getSideSignum((String)sideValue);
                            if (signum != null) {
                                side = signum;
                            }
                        }
                    } else {
                        point = mousePosition;
                        Geometry closestGeometry = this.getClosestGeometry(this.selectedFeatures, point);
                        Point closestPoint = this.getClosestPoint(closestGeometry, point);
                        distance = this.getMinDistance(this.selectedFeatures, point);
                        ISymbol symbol = lineSymbolEditing;
                        Line auxLine = GeometryUtils.createLine((Point)closestPoint, (Point)point, (int)subtype);
                        drawingStatus.addStatus((Geometry)auxLine, auxiliaryLineSymbolEditing, "");
                        Point pointText = GeometryUtils.createPoint((double)(0.5 * (closestPoint.getX() + point.getX())), (double)(0.5 * (closestPoint.getY() + point.getY())));
                        ISimpleTextSymbol textSymbol = this.getTextSymbol();
                        drawingStatus.addStatus((Geometry)pointText, (ISymbol)textSymbol, new DecimalFormat("#.0#").format(distance));
                    }
                    int joinStyleValue = this.coerceJoinStyle(this.values.get(this.joinStyleParameter));
                    for (Feature feat : this.selectedFeatures) {
                        ISymbol previewSymbol = this.getPreviewSymbol(feat);
                        for (int c = 1; c <= equidistantOffsetsValue; ++c) {
                            Geometry transformedGeometry = feat.getDefaultGeometry().offset(joinStyleValue, (double)c * distance * side);
                            ISymbol symbol = null;
                            if (transformedGeometry instanceof Curve || transformedGeometry instanceof MultiCurve) {
                                symbol = lineSymbolEditing;
                                drawingStatus.addStatus(feat.getDefaultGeometry(), auxiliaryLineSymbolEditingDirection, "Direction");
                            } else if (transformedGeometry instanceof Surface || transformedGeometry instanceof MultiSurface) {
                                symbol = polygonSymbolEditing;
                            } else if (transformedGeometry instanceof Point || transformedGeometry instanceof MultiPoint) {
                                symbol = auxiliaryPointSymbolEditing;
                            }
                            if (transformedGeometry instanceof Aggregate) {
                                int primitivesNumber = ((Aggregate)transformedGeometry).getPrimitivesNumber();
                                for (int i = 0; i < primitivesNumber; ++i) {
                                    Primitive primitive = ((Aggregate)transformedGeometry).getPrimitiveAt(i);
                                    drawingStatus.addStatus((Geometry)primitive, symbol, "");
                                    drawingStatus.addStatus((Geometry)primitive, previewSymbol, "");
                                }
                                continue;
                            }
                            drawingStatus.addStatus(transformedGeometry, symbol, "");
                            drawingStatus.addStatus(transformedGeometry, previewSymbol, "");
                        }
                    }
                }
                catch (Exception e) {
                    throw new DrawServiceException((Throwable)e);
                }
            }
        }
        return drawingStatus;
    }

    private double getMinDistance(List<Feature> selected, Point point) throws DataException, GeometryOperationNotSupportedException, GeometryOperationException, GeometryException {
        double minorDistance = Double.POSITIVE_INFINITY;
        for (Feature feature : selected) {
            Geometry geometry = feature.getDefaultGeometry();
            double distance = this.getDistance(geometry, point);
            if (!(distance < minorDistance)) continue;
            minorDistance = distance;
        }
        return minorDistance;
    }

    private Geometry getClosestGeometry(List<Feature> selected, Point point) throws DataException, GeometryOperationNotSupportedException, GeometryOperationException, GeometryException {
        double minorDistance = Double.POSITIVE_INFINITY;
        Geometry closestGeometry = null;
        for (Feature feature : selected) {
            Geometry geometry = feature.getDefaultGeometry();
            double distance = this.getDistance(geometry, point);
            if (!(distance < minorDistance)) continue;
            closestGeometry = geometry;
            minorDistance = distance;
        }
        return closestGeometry;
    }

    private double getDistance(Geometry geometry, Point point) throws GeometryOperationNotSupportedException, GeometryOperationException, GeometryException {
        double distance;
        Point p;
        Point closestPoint;
        Geometry[] closestPoints;
        double minDistance;
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        if (geometry instanceof Arc) {
            Arc arc = (Arc)geometry;
            Point center = arc.getCenterPoint();
            double radius = center.distance((Geometry)arc.getInitPoint());
            double distance2 = center.distance((Geometry)point) - radius;
            return distance2;
        }
        if (geometry instanceof Circle) {
            Circle circle = (Circle)geometry;
            return circle.getCenter().distance((Geometry)point) - circle.getRadious();
        }
        if (geometry instanceof Circumference) {
            Circumference circumference = (Circumference)geometry;
            return circumference.getCenter().distance((Geometry)point) - circumference.getRadious();
        }
        if (geometry instanceof PeriEllipse) {
            double minDistance2 = Double.POSITIVE_INFINITY;
            PeriEllipse ellipse = (PeriEllipse)geometry;
            Geometry[] closestPoints2 = point.closestPoints((Geometry)ellipse);
            if (closestPoints2 != null) {
                for (Geometry closestPoint2 : closestPoints2) {
                    double distance3;
                    if (point.equals(closestPoint2) || !((distance3 = closestPoint2.distance((Geometry)point)) < minDistance2)) continue;
                    minDistance2 = distance3;
                }
            }
            Ellipse auxEllipse = (Ellipse)geomManager.create(13, geometry.getGeometryType().getSubType());
            auxEllipse.setPoints(ellipse.getAxis1Start(), ellipse.getAxis1End(), ellipse.getAxis2Dist());
            if (auxEllipse.contains((Geometry)point)) {
                return -minDistance2;
            }
            return minDistance2;
        }
        if (geometry instanceof Ellipse) {
            Ellipse ellipse = (Ellipse)geometry;
            PeriEllipse auxPeriEllipse = (PeriEllipse)geomManager.create(24, geometry.getGeometryType().getSubType());
            auxPeriEllipse.setPoints(ellipse.getAxis1Start(), ellipse.getAxis1End(), ellipse.getAxis2Dist());
            double distance4 = this.getDistance((Geometry)auxPeriEllipse, point);
            return distance4;
        }
        if (geometry instanceof Spline || geometry instanceof FilledSpline) {
            return this.getDistance((Geometry)geometry.toLines().getPrimitiveAt(0), point);
        }
        if (geometry instanceof Line) {
            Line line = (Line)geometry;
            minDistance = Double.POSITIVE_INFINITY;
            closestPoints = point.closestPoints((Geometry)line);
            closestPoint = null;
            if (closestPoints != null) {
                Geometry[] geometryArray = closestPoints;
                int n = geometryArray.length;
                for (int i = 0; i < n; ++i) {
                    Geometry closestPoint1 = geometryArray[i];
                    p = (Point)closestPoint1;
                    if (point.equals(p) || !((distance = p.distance((Geometry)point)) < minDistance)) continue;
                    minDistance = distance;
                    closestPoint = p;
                }
            }
            if (closestPoint != null) {
                for (int i = 0; i < line.getNumVertices() - 1; ++i) {
                    Line segment = (Line)geomManager.create(18, geometry.getGeometryType().getSubType());
                    segment.addVertex(line.getVertex(i));
                    segment.addVertex(line.getVertex(i + 1));
                    if (!segment.isWithinDistance((Geometry)closestPoint, PRECISION.doubleValue())) continue;
                    if (line.getVertex(0).equals(line.getVertex(line.getNumVertices() - 1))) {
                        if (line.toPolygons().contains((Geometry)point)) {
                            return -minDistance;
                        }
                        return minDistance;
                    }
                    return this.getDirectedDistance(closestPoint, point, segment);
                }
            }
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            if (!polygon.contains((Geometry)point)) {
                minDistance = Double.POSITIVE_INFINITY;
                closestPoints = point.closestPoints((Geometry)polygon);
                closestPoint = null;
                if (closestPoints != null) {
                    for (Geometry closestPoint1 : closestPoints) {
                        p = (Point)closestPoint1;
                        if (point.equals(p) || !((distance = p.distance((Geometry)point)) < minDistance)) continue;
                        minDistance = distance;
                        closestPoint = p;
                    }
                }
                if (closestPoint != null) {
                    return closestPoint.distance((Geometry)point);
                }
            } else {
                Line auxLine = (Line)polygon.toLines().getPrimitiveAt(0);
                if (auxLine != null) {
                    return this.getDistance((Geometry)auxLine, point);
                }
            }
        }
        if (geometry instanceof Aggregate) {
            double minDistance3 = Double.POSITIVE_INFINITY;
            Aggregate aggregate2 = (Aggregate)geometry;
            for (int i = 0; i < aggregate2.getPrimitivesNumber(); ++i) {
                double distance5 = this.getDistance((Geometry)aggregate2.getPrimitiveAt(i), point);
                if (!(distance5 < minDistance3)) continue;
                minDistance3 = distance5;
            }
            return minDistance3;
        }
        return 0.0;
    }

    private Point getClosestPoint(Geometry geometry, Point point) throws GeometryOperationNotSupportedException, GeometryOperationException, GeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        if (geometry instanceof Line) {
            Line line = (Line)geometry;
            return (Point)line.closestPoints((Geometry)point)[0];
        }
        return (Point)geometry.toLines().getPrimitiveAt(0).closestPoints((Geometry)point)[0];
    }

    public void stop() {
        this.values.clear();
        this.selectedFeatures = Collections.EMPTY_LIST;
    }

    public void restart() throws StartServiceException, InvalidEntryException, StopServiceException {
        this.values.put(this.offsetParameter, null);
        this.values.put(this.sideParameter, null);
        this.values.put(this.deleteOriginalGeometriesParameter, null);
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        try {
            if (param == this.selectionParameter) {
                FeatureSelection featureSelection;
                if (value instanceof FeatureSelection && (featureSelection = (FeatureSelection)value).getSelectedCount() > 0L) {
                    this.values.put(param, value);
                    this.selectedFeatures = this.getSelectedFeaturesCopy(featureSelection);
                }
            } else if (param == this.joinStyleParameter) {
                if (value instanceof String) {
                    this.values.put(param, this.fixJoinStyle(value));
                }
            } else if (param == this.offsetParameter) {
                if (value instanceof Point) {
                    Double distance = this.getMinDistance(this.selectedFeatures, (Point)value);
                    if (distance == 0.0) {
                        throw new IllegalArgumentException("distance can't be 0");
                    }
                    this.values.put(param, Math.abs(distance));
                    this.values.put(this.sideParameter, this.coerceSide(distance));
                    return;
                }
                if (value instanceof Double) {
                    Double distance = (Double)value;
                    if (distance > 0.0) {
                        this.values.put(param, value);
                    } else {
                        if (distance == 0.0) {
                            throw new IllegalArgumentException("distance can't be 0");
                        }
                        this.values.put(param, Math.abs(distance));
                        this.values.put(this.sideParameter, this.coerceSide(distance));
                    }
                }
            } else if (param == this.sideParameter) {
                if (value instanceof Point) {
                    this.values.put(param, this.coerceSide(this.getMinDistance(this.selectedFeatures, (Point)value)));
                    return;
                }
                if (value instanceof String) {
                    this.values.put(param, this.coerceSide(value));
                }
            } else if (param == this.equidistantOffsets) {
                int intValue;
                if (value instanceof Number && (intValue = ((Number)value).intValue()) >= 1) {
                    this.values.put(param, ((Number)value).intValue());
                }
            } else if (param == this.deleteOriginalGeometriesParameter) {
                this.values.put(param, param.getOptions2().getValue(value, param.getDefaultValue()));
            }
        }
        catch (Exception e) {
            throw new InvalidEntryException((Throwable)e);
        }
    }

    private String coerceSide(Object value) throws InvalidEntryException {
        Double signum;
        if (value instanceof Double) {
            return (Double)value >= 0.0 ? LEFT : RIGHT;
        }
        if (value instanceof String && (signum = this.getSideSignum((String)value)) != null) {
            return signum >= 0.0 ? LEFT : RIGHT;
        }
        throw new InvalidEntryException(null);
    }

    private String fixJoinStyle(Object value) throws InvalidEntryException {
        if (value instanceof String) {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            String joinStyleTrim = ((String)value).trim();
            if (StringUtils.equalsIgnoreCase((CharSequence)joinStyleTrim, (CharSequence)ROUND) || StringUtils.startsWithIgnoreCase((CharSequence)i18nManager.getTranslation(ROUND), (CharSequence)joinStyleTrim)) {
                return ROUND;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)joinStyleTrim, (CharSequence)BEVEL) || StringUtils.startsWithIgnoreCase((CharSequence)i18nManager.getTranslation(BEVEL), (CharSequence)joinStyleTrim)) {
                return BEVEL;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)joinStyleTrim, (CharSequence)MITRE) || StringUtils.startsWithIgnoreCase((CharSequence)i18nManager.getTranslation(MITRE), (CharSequence)joinStyleTrim)) {
                return MITRE;
            }
        }
        throw new InvalidEntryException(null);
    }

    private Double getSideSignum(String side) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        String sideTrim = side.trim();
        if (StringUtils.equalsIgnoreCase((CharSequence)sideTrim, (CharSequence)LEFT) || StringUtils.startsWithIgnoreCase((CharSequence)i18nManager.getTranslation(LEFT), (CharSequence)sideTrim)) {
            return 1.0;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)sideTrim, (CharSequence)RIGHT) || StringUtils.startsWithIgnoreCase((CharSequence)i18nManager.getTranslation(RIGHT), (CharSequence)sideTrim)) {
            return -1.0;
        }
        return null;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> list = new ArrayList<EditingServiceParameter>();
        list.add(this.selectionParameter);
        list.add((EditingServiceParameter)this.joinStyleParameter);
        list.add(this.offsetParameter);
        list.add(this.sideParameter);
        list.add(this.equidistantOffsets);
        list.add(this.deleteOriginalGeometriesParameter);
        return list;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    public void finishAndStore() throws FinishServiceException {
        block8: {
            try {
                if (!CollectionUtils.isNotEmpty(this.selectedFeatures)) break block8;
                double side = 1.0;
                Object sideValue = this.values.get(this.sideParameter);
                if (sideValue != null && sideValue instanceof String) {
                    Double signum = this.getSideSignum((String)sideValue);
                    side = signum != null ? signum : null;
                }
                double distance = (Double)this.values.get(this.offsetParameter) * side;
                int joinStyleValue = this.coerceJoinStyle(this.values.get(this.joinStyleParameter));
                Number equidistantOffsetsNumberValue = (Number)this.values.get(this.equidistantOffsets);
                int equidistantOffsetsValue = equidistantOffsetsNumberValue != null ? equidistantOffsetsNumberValue.intValue() : ((Number)this.equidistantOffsets.getDefaultValue()).intValue();
                for (Feature feature : this.selectedFeatures) {
                    for (int c = 1; c <= equidistantOffsetsValue; ++c) {
                        Geometry geom;
                        try {
                            geom = feature.getDefaultGeometry().offset(joinStyleValue, (double)c * distance);
                        }
                        catch (GeometryOperationException | GeometryOperationNotSupportedException e) {
                            throw new FinishServiceException(e);
                        }
                        if (((Boolean)this.values.get(this.deleteOriginalGeometriesParameter)).booleanValue() && c == 1) {
                            EditableFeature editableFeature = feature.getEditable();
                            editableFeature.setDefaultGeometry(geom);
                            this.getProviderServices().updateFeatureInFeatureStore((Feature)editableFeature, this.featureStore);
                            continue;
                        }
                        EditingProviderServices editingProviderServices = this.getProviderServices();
                        EditableFeature editableFeature = editingProviderServices.getFeatureCopyWithoutUniqueIndex(this.featureStore, feature);
                        editableFeature.setDefaultGeometry(geom);
                        editingProviderServices.insertFeatureIntoFeatureStore((Feature)editableFeature, this.featureStore);
                    }
                }
            }
            catch (DataException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    private Double getDirectedDistance(Point pointInLine, Point distancePoint, Line line) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Double distance = distancePoint.distance((Geometry)pointInLine);
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Double angle = editingProviderServices.getAngle(pointInLine, distancePoint);
        double angleLine = editingProviderServices.getAngle(line.getVertex(0), line.getVertex(1));
        Double angleDifference = angle - angleLine;
        if (angleDifference < 0.0) {
            angleDifference = angleDifference + Math.PI * 2;
        }
        if (angleDifference > Math.PI) {
            distance = -distance.doubleValue();
        }
        return distance;
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        this.selectedFeatures = Collections.EMPTY_LIST;
        FeatureSelection selected = null;
        if (this.featureStore != null) {
            try {
                selected = (FeatureSelection)this.featureStore.getFeatureSelection().clone();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (selected != null && selected.getSelectedCount() > 0L) {
                this.values.put(this.selectionParameter, selected);
                this.selectedFeatures = this.getSelectedFeaturesCopy(selected);
            }
        }
    }

    public String getName() {
        return "modify-offset";
    }

    private int coerceJoinStyle(Object joinStyle) {
        if (joinStyle instanceof String) {
            switch ((String)joinStyle) {
                default: {
                    return 1;
                }
                case "_mitre": {
                    return 2;
                }
                case "_bevel": 
            }
            return 3;
        }
        return 1;
    }

    public boolean isEnabled(EditingServiceParameter parameter) {
        if (parameter == this.joinStyleParameter) {
            return true;
        }
        if (parameter == this.equidistantOffsets) {
            return true;
        }
        return true;
    }

    private ISimpleTextSymbol getTextSymbol() {
        SymbologyManager symbologyManager = SymbologyLocator.getSymbologyManager();
        ISimpleTextSymbol textSymbol = symbologyManager.createSimpleTextSymbol();
        textSymbol.setFontSize(10.0);
        return textSymbol;
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

