/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.addToWorkspace;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorPickerController;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.vcsgis.lib.UserCancelledException;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisRuntimeException;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.swing.VCSGisJAddToWorkspace;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.addToWorkspace.VCSGisJAddToWorkspaceView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisJAddToWorkspaceImpl
extends VCSGisJAddToWorkspaceView
implements Component,
VCSGisJAddToWorkspace {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisJAddToWorkspaceImpl.class);
    private static final int TAB_LAYERS_INDEX = 0;
    private static final int TAB_TABLES_INDEX = 1;
    private PickerController<VCSGisWorkspace> workspacePicker;
    private Dialog dialog;
    private AttributeDescriptorPickerController fieldForLabelPicker;
    private boolean processing = false;
    private TaskStatusController taskStatusController;
    private int lasterrnum;
    private String lastAddStoreName;
    private String lastAddTableName;

    public VCSGisJAddToWorkspaceImpl() {
        this.initComponents();
    }

    private void initComponents() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        this.translate();
        this.taskStatusController = taskStatusManager.createTaskStatusController(this.lblStatusTitle, this.lblStatusMessages, this.pbStatus);
        this.taskStatusController.setShowCancelButton(false);
        this.taskStatusController.setShowRemoveTaskButton(false);
        this.taskStatusController.bind(ToolsLocator.getTaskStatusManager());
        SwingUtilities.invokeLater(() -> this.setVisibleStatus(false));
        this.workspacePicker = swingManager.createWorkspacePickerController(this.cboWorkspace, this.btnWorkspace);
        this.workspacePicker.addChangeListener(e -> this.doChangeWorkspace());
        this.tabAddToWorkspace.addChangeListener(e -> {
            this.updateFieldsForSelectedStore();
            this.doUpdateComponents();
        });
        final VCSGisSwingServices services = swingManager.getDefaultServices();
        ComboBoxModel viewDocumentsModel = services.getViewDocumentsComboBoxModel();
        this.cboView.setModel(viewDocumentsModel);
        this.cboView.addActionListener(e -> this.doUpdateComponents());
        this.chkAddLayerToView.addActionListener(e -> this.doUpdateComponents());
        this.treeLayers.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.treeLayers.getSelectionModel().setSelectionMode(4);
        this.treeLayers.getSelectionModel().addTreeSelectionListener(e -> {
            this.updateFieldsForSelectedStore();
            this.doUpdateComponents();
        });
        this.treeLayers.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                if (event.getPath().getPathCount() == 1) {
                    VCSGisJAddToWorkspaceImpl.this.treeLayers.setModel(services.getFeatureStoresTreeModel());
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.treeLayers.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public java.awt.Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof FeatureStore) {
                    FeatureStore store;
                    VCSGisWorkspace ws = VCSGisJAddToWorkspaceImpl.this.getWorkspace();
                    if (ws.isInMyDatabase(store = (FeatureStore)value)) {
                        String theName = VCSGisSwingCommons.getHTMLColorTag(VCSGisJAddToWorkspaceImpl.this.getWorkspace(), store.getName());
                        label.setText(theName);
                    } else {
                        label.setText(store.getName());
                    }
                }
                Icon icon = services.getFeatureStoresTreeModelIcon(tree.getModel(), value);
                this.setIcon(icon);
                return label;
            }
        });
        this.treeLayers.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                TreePath path = VCSGisJAddToWorkspaceImpl.this.treeLayers.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    VCSGisJAddToWorkspaceImpl.this.treeLayers.setToolTipText("");
                    return;
                }
                Object value = path.getLastPathComponent();
                if (value instanceof FeatureStore) {
                    String theName = ((FeatureStore)value).getName();
                    String description = VCSGisSwingCommons.getStateDescription(VCSGisJAddToWorkspaceImpl.this.getWorkspace(), theName);
                    if (description != null) {
                        VCSGisJAddToWorkspaceImpl.this.treeLayers.setToolTipText("<html>" + theName + "<br>" + description + "</html>");
                    }
                } else {
                    VCSGisJAddToWorkspaceImpl.this.treeLayers.setToolTipText("");
                }
            }
        });
        this.lstTables.setModel(services.getFeatureStoresListModel());
        this.lstTables.getSelectionModel().setSelectionMode(2);
        this.lstTables.getSelectionModel().addListSelectionListener(e -> {
            this.updateFieldsForSelectedStore();
            this.doUpdateComponents();
        });
        this.lstTables.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public java.awt.Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof FeatureStore) {
                    label.setText(((FeatureStore)value).getName());
                }
                return label;
            }
        });
        this.txtName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                VCSGisJAddToWorkspaceImpl.this.doUpdateComponents();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                VCSGisJAddToWorkspaceImpl.this.doUpdateComponents();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                VCSGisJAddToWorkspaceImpl.this.doUpdateComponents();
            }
        });
        this.fieldForLabelPicker = DALSwingLocator.getDataSwingManager().createAttributeDescriptorPickerController(this.cboFieldForLabel, t -> {
            if (t.getType() == 66) {
                return false;
            }
            return !t.isComputed();
        });
        this.fieldForLabelPicker.addChangeListener(e -> this.doUpdateComponents());
        if (this.cboView.getModel().getSize() > 0) {
            this.cboView.setEnabled(true);
            if (this.cboView.getModel().getSize() == 2) {
                this.cboView.setSelectedIndex(1);
            } else {
                this.cboView.setSelectedIndex(0);
            }
            this.chkAddLayerToView.setSelected(true);
        } else {
            this.cboView.setEnabled(false);
            this.chkAddLayerToView.setSelected(false);
        }
        this.chkAddTableToProject.setSelected(true);
        ToolsSwingUtils.ensureRowsCols((JComponent)this.tabAddToWorkspace, (int)-1, (int)-1, (int)10, (int)-1);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)18, (int)60, (int)22, (int)100);
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.doUpdateComponents();
    }

    private void updateFieldsForSelectedStore() {
        List<FeatureStore> stores = this.getFeatureStores();
        if (stores.size() == 1) {
            FeatureStore store = stores.get(0);
            FeatureType featureType = store.getDefaultFeatureTypeQuietly();
            this.fieldForLabelPicker.setFeatureType(featureType);
            Tags tags = featureType.getTags();
            this.txtName.setText(store.getName());
            if (tags.has("vcsgis.label")) {
                this.txtLabel.setText(tags.getString("vcsgis.label", ""));
            } else {
                this.txtLabel.setText("");
            }
            if (tags.has("vcsgis.datamodel")) {
                ListElement.setSelected((JComboBox)this.cboModel, (Object)tags.getString("vcsgis.datamodel", ""));
            } else {
                this.cboModel.setSelectedIndex(-1);
            }
            if (tags.has("vcsgis.category")) {
                ListElement.setSelected((JComboBox)this.cboCategory, (Object)tags.getString("vcsgis.category", ""));
            }
            if (tags.has("vcsgis.resources")) {
                ListElement.setSelected((JComboBox)this.cboResources, (Object)tags.getString("vcsgis.resources", ""));
            } else {
                this.cboResources.setSelectedIndex(-1);
            }
            if (tags.has("vcsgis.fieldforlabel")) {
                this.fieldForLabelPicker.set(tags.getString("vcsgis.fieldforlabel", ""));
            } else {
                this.cboFieldForLabel.setSelectedIndex(-1);
            }
        } else {
            this.txtName.setText("");
            this.txtLabel.setText("");
            this.cboModel.setSelectedIndex(-1);
            this.cboCategory.setSelectedIndex(-1);
            this.cboResources.setSelectedIndex(-1);
            this.cboFieldForLabel.setSelectedIndex(-1);
        }
    }

    private void doUpdateComponents() {
        try {
            VCSGisWorkspace workspace = this.getWorkspace();
            if (this.processing || workspace == null) {
                this.workspacePicker.setEnabled(!this.processing);
                this.tabAddToWorkspace.setEnabled(false);
                this.treeLayers.setEnabled(false);
                this.txtName.setEnabled(false);
                this.cboFieldForLabel.setEnabled(false);
                this.txtLabel.setEnabled(false);
                this.cboCategory.setEnabled(false);
                this.cboModel.setEnabled(false);
                this.cboResources.setEnabled(false);
                this.cboView.setEnabled(false);
                this.chkAddLayerToView.setEnabled(false);
                this.chkAddTableToProject.setEnabled(false);
                if (this.dialog != null) {
                    this.dialog.setButtonEnabled(1, false);
                }
                return;
            }
            List<FeatureStore> stores = this.getFeatureStores();
            this.workspacePicker.setEnabled(true);
            this.tabAddToWorkspace.setEnabled(true);
            this.treeLayers.setEnabled(true);
            this.chkAddLayerToView.setEnabled(true);
            this.chkAddTableToProject.setEnabled(true);
            this.cboView.setEnabled(this.chkAddLayerToView.isSelected());
            if (stores.size() == 1) {
                this.txtName.setEnabled(true);
                this.cboFieldForLabel.setEnabled(true);
                this.txtLabel.setEnabled(true);
                this.cboCategory.setEnabled(true);
                this.cboModel.setEnabled(true);
                this.cboResources.setEnabled(true);
                LabeledValue selectedView = (LabeledValue)this.cboView.getSelectedItem();
                String theName = StringUtils.trimToNull((String)this.txtName.getText());
                VCSGisEntity theEntity = workspace.getEntity(theName);
                if (this.dialog != null) {
                    if (theName == null) {
                        this.dialog.setButtonEnabled(1, false);
                        this.message("Name is mandatory");
                    } else if (theEntity != null) {
                        this.dialog.setButtonEnabled(1, false);
                        this.message("Entity '" + theEntity.getEntityName() + "' already exists in working copy or repsitory");
                    } else if (this.chkAddLayerToView.isSelected() && selectedView.getValue() == null) {
                        this.dialog.setButtonEnabled(1, false);
                        this.message("Need to select a View");
                    } else {
                        this.message("");
                        this.dialog.setButtonEnabled(1, true);
                    }
                }
            } else {
                this.txtName.setEnabled(false);
                this.cboFieldForLabel.setEnabled(false);
                this.txtLabel.setEnabled(false);
                if (stores.isEmpty()) {
                    this.cboCategory.setEnabled(false);
                    this.cboModel.setEnabled(false);
                    this.cboResources.setEnabled(false);
                    this.dialog.setButtonEnabled(1, false);
                } else {
                    this.cboCategory.setEnabled(true);
                    this.cboModel.setEnabled(true);
                    this.cboResources.setEnabled(true);
                    this.dialog.setButtonEnabled(1, true);
                    if (this.dialog != null) {
                        this.message("");
                        for (FeatureStore store : stores) {
                            String theName = store.getName();
                            VCSGisEntity theEntity = workspace.getEntity(theName);
                            if (theEntity == null) continue;
                            this.message("Entity '" + theEntity.getEntityName() + "' already exists in working copy");
                            this.dialog.setButtonEnabled(1, false);
                        }
                    }
                }
            }
            this.pbStatus.setVisible(this.processing);
            this.lblStatusTitle.setVisible(this.processing);
        }
        catch (VCSGisRuntimeException e1) {
            LOGGER.warn("Can't updating components.", (Throwable)e1);
            if (VCSGisSwingCommons.showAuthenticationErrors("_VCS_Add_to_workingcopy", e1)) {
                this.workspacePicker.set(null);
                this.doChangeWorkspace();
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Can't updating components.", (Throwable)e2);
        }
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblWorkspace);
        toolsSwingManager.translate(this.lblName);
        toolsSwingManager.translate(this.tabAddToWorkspace);
        toolsSwingManager.translate(this.lblFieldForLabel);
        toolsSwingManager.translate((AbstractButton)this.chkAddLayerToView);
        toolsSwingManager.translate((AbstractButton)this.chkAddTableToProject);
        toolsSwingManager.translate(this.lblCategory);
        toolsSwingManager.translate(this.lblLabel);
        toolsSwingManager.translate(this.lblModel);
        toolsSwingManager.translate(this.lblResources);
        toolsSwingManager.translate(this.lblImportData);
    }

    public VCSGisWorkspace getWorkspace() {
        VCSGisWorkspace workspace = (VCSGisWorkspace)this.workspacePicker.get();
        return workspace;
    }

    public FeatureStore getFeatureStore() {
        switch (this.tabAddToWorkspace.getSelectedIndex()) {
            case 0: {
                TreePath selection = this.treeLayers.getSelectionModel().getSelectionPath();
                if (selection == null) break;
                Object[] path = selection.getPath();
                boolean isLeaf = this.treeLayers.getModel().isLeaf(path[path.length - 1]);
                Object obj = path[path.length - 1];
                if (!isLeaf || !(obj instanceof FeatureStore)) break;
                return (FeatureStore)obj;
            }
            case 1: {
                Object selected = this.lstTables.getSelectedValue();
                if (!(selected instanceof FeatureStore)) break;
                return (FeatureStore)selected;
            }
        }
        return null;
    }

    public List<FeatureStore> getFeatureStores() {
        ArrayList<FeatureStore> stores = new ArrayList<FeatureStore>();
        switch (this.tabAddToWorkspace.getSelectedIndex()) {
            case 0: {
                TreePath[] selection = this.treeLayers.getSelectionModel().getSelectionPaths();
                if (selection == null) break;
                for (TreePath treePath : selection) {
                    Object[] path = treePath.getPath();
                    boolean isLeaf = this.treeLayers.getModel().isLeaf(path[path.length - 1]);
                    Object obj = path[path.length - 1];
                    if (!isLeaf || !(obj instanceof FeatureStore)) continue;
                    stores.add((FeatureStore)obj);
                }
                break;
            }
            case 1: {
                List selected = this.lstTables.getSelectedValuesList();
                for (Object obj : selected) {
                    if (!(obj instanceof FeatureStore)) continue;
                    stores.add((FeatureStore)obj);
                }
                break;
            }
        }
        return stores;
    }

    private boolean hasFeatureStore() {
        switch (this.tabAddToWorkspace.getSelectedIndex()) {
            case 0: {
                TreePath[] selection = this.treeLayers.getSelectionModel().getSelectionPaths();
                if (selection == null) break;
                for (TreePath treePath : selection) {
                    Object[] path = treePath.getPath();
                    boolean isLeaf = this.treeLayers.getModel().isLeaf(path[path.length - 1]);
                    Object obj = path[path.length - 1];
                    if (!isLeaf || !(obj instanceof FeatureStore)) continue;
                    return true;
                }
                break;
            }
            case 1: {
                Object selected = this.lstTables.getSelectedValue();
                if (!(selected instanceof FeatureStore)) break;
                return true;
            }
        }
        return false;
    }

    public String getTabletName() {
        return this.txtName.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add() {
        VCSGisWorkspace workspace = this.getWorkspace();
        if (workspace == null) {
            return 270;
        }
        List<FeatureStore> featureStores = this.getFeatureStores();
        if (featureStores.size() < 1) {
            return 270;
        }
        ArrayList<String> tableNames = new ArrayList<String>();
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Add tables");
        try {
            String attrNameForLabel;
            String resources;
            String datamodel;
            String category;
            String label;
            status.setAutoremove(true);
            status.add();
            this.taskStatusController.bind((TaskStatus)status);
            this.processing = true;
            this.doUpdateComponents();
            String theName = (String)StringUtils.defaultIfBlank((CharSequence)this.txtName.getText(), null);
            if (featureStores.size() > 1) {
                label = "@AUTODETECT";
                category = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.cboCategory.getSelectedItem()), (CharSequence)"@AUTODETECT");
                datamodel = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.cboModel.getSelectedItem()), (CharSequence)"@AUTODETECT");
                resources = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.cboResources.getSelectedItem()), (CharSequence)"@AUTODETECT");
                attrNameForLabel = "@AUTODETECT";
            } else {
                label = (String)StringUtils.defaultIfBlank((CharSequence)this.txtLabel.getText(), null);
                category = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.cboCategory.getSelectedItem()), null);
                datamodel = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.cboModel.getSelectedItem()), null);
                resources = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.cboResources.getSelectedItem()), null);
                FeatureAttributeDescriptor descriptor = (FeatureAttributeDescriptor)this.fieldForLabelPicker.get();
                attrNameForLabel = descriptor == null ? "VCSGISCODE" : descriptor.getName();
            }
            boolean importData = this.chkImportData.isSelected();
            int result = 0;
            status.setRangeOfValues(0L, (long)featureStores.size());
            status.setCurValue(0L);
            for (FeatureStore featureStore : featureStores) {
                if (featureStores.size() > 1) {
                    theName = featureStore.getName();
                }
                this.lastAddStoreName = featureStore.getName();
                this.lastAddTableName = theName;
                status.message(theName);
                this.lasterrnum = result = workspace.add(theName, featureStore, attrNameForLabel, category, label, datamodel, resources, null, importData, status);
                if (result != 0) break;
                tableNames.add(theName);
                status.incrementCurrentValue();
            }
            this.postAdd(result, workspace, tableNames);
            int n = result;
            return n;
        }
        catch (UserCancelledException ex) {
            LOGGER.warn("User cancelled.");
            int n = 17;
            return n;
        }
        finally {
            this.processing = false;
            this.doUpdateComponents();
        }
    }

    private void postAdd(int addStatus, VCSGisWorkspace workspace, List<String> tableNames) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.postAdd(addStatus, workspace, tableNames))) {
            return;
        }
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        this.treeLayers.setSelectionRow(-1);
        this.lstTables.setSelectedIndex(-1);
        if (addStatus == 0) {
            FeatureStore store;
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            switch (this.tabAddToWorkspace.getSelectedIndex()) {
                case 0: {
                    if (!this.chkAddLayerToView.isSelected()) break;
                    for (String tableName : tableNames) {
                        VCSGisWorkspaceEntity entity = workspace.getWorkspaceEntityByName(tableName);
                        String layerName = entity.getLabel();
                        String groupName = entity.getFirstCategory();
                        try {
                            FeatureStore store2 = workspace.openFeatureStore(tableName, false);
                            services.addLayerToView(store2, (LabeledValue)this.cboView.getSelectedItem(), groupName, layerName, true);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Can't add layer to view.", (Throwable)ex);
                            dialogs.messageDialog("_Cant_add_layer_XLayerNameX_to_the_selected_view", new String[]{layerName}, i18n.getTranslation("_VCS_Add_to_workingcopy"), 2, "_Cant_add_layer_to_the_working_copy");
                        }
                    }
                    break;
                }
                case 1: {
                    if (!this.chkAddTableToProject.isSelected()) break;
                    for (String tableName : tableNames) {
                        try {
                            store = workspace.openFeatureStore(tableName, false);
                            services.addTableToProject(workspace, store);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Can't add table to project.", (Throwable)ex);
                            dialogs.messageDialog("_Cant_add_table_XtableNameX_to_project", new String[]{tableName}, i18n.getTranslation("_VCS_Add_to_workingcopy"), 2, "_Cant_add_table_to_project");
                        }
                    }
                    break;
                }
            }
            for (String tableName : tableNames) {
                store = workspace.getFeatureStore(tableName);
                VCSGisSwingCommons.refreshDocument(store);
            }
        }
        this.updateResourcesCombo();
        this.updateCategoryCombo();
        this.updateModelCombo();
    }

    public void setVisibleStatus(boolean visible) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.setVisibleStatus(visible))) {
            return;
        }
        this.lblStatusTitle.setVisible(visible);
        this.pbStatus.setVisible(visible);
        this.lblStatusMessages.setVisible(true);
    }

    public boolean isProcessing() {
        return this.processing;
    }

    private void message(String message) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.message(message))) {
            return;
        }
        this.lblStatusMessages.setText(message);
    }

    private void doChangeWorkspace() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        this.treeLayers.setModel(services.getFeatureStoresTreeModel());
        this.updateCategoryCombo();
        this.updateModelCombo();
        this.updateResourcesCombo();
        this.doUpdateComponents();
    }

    private void updateCategoryCombo() {
        VCSGisWorkspace ws = (VCSGisWorkspace)this.workspacePicker.get();
        DefaultComboBoxModel<String> modelCategories = new DefaultComboBoxModel<String>();
        if (ws != null) {
            for (String category : ws.getEntityCategories()) {
                modelCategories.addElement(category);
            }
        }
        Object item = this.cboCategory.getSelectedItem();
        this.cboCategory.setModel(modelCategories);
        ListElement.setSelected((JComboBox)this.cboCategory, (Object)item);
    }

    private void updateModelCombo() {
        VCSGisWorkspace ws = (VCSGisWorkspace)this.workspacePicker.get();
        DefaultComboBoxModel<String> modelDataModels = new DefaultComboBoxModel<String>();
        if (ws != null) {
            for (String modelName : ws.getDataModels()) {
                modelDataModels.addElement(modelName);
            }
        }
        Object item = this.cboModel.getSelectedItem();
        this.cboModel.setModel(modelDataModels);
        ListElement.setSelected((JComboBox)this.cboModel, (Object)item);
    }

    private void updateResourcesCombo() {
        VCSGisWorkspace ws = (VCSGisWorkspace)this.workspacePicker.get();
        DefaultComboBoxModel<String> modelResources = new DefaultComboBoxModel<String>();
        if (ws != null) {
            HashSet<String> entityNames_s = new HashSet<String>();
            for (VCSGisEntity entity : ws.getRepositoryEntities()) {
                entityNames_s.add(entity.getEntityName());
            }
            for (VCSGisEntity entity : ws.getWorkspaceEntities()) {
                entityNames_s.add(entity.getEntityName());
            }
            ArrayList entitiNames = new ArrayList(entityNames_s);
            entitiNames.sort((o1, o2) -> StringUtils.compare((String)o1, (String)o2));
            for (String entitiName : entitiNames) {
                modelResources.addElement(entitiName);
            }
        }
        this.cboResources.setModel(modelResources);
        this.cboResources.setSelectedIndex(-1);
    }

    public String getLastErrorMessage() {
        VCSGisWorkspace workspace = this.getWorkspace();
        if (workspace == null) {
            return "";
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        String msg = i18n.getTranslation("_Cant_add_{0}_as_{1}_in_{2}", new String[]{this.lastAddStoreName, this.lastAddTableName, workspace.getLabel()}) + "\n" + workspace.getErrorMessage(this.lasterrnum);
        return msg;
    }
}

