/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.changes;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.json.JsonObject;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.featureform.swing.CreateJFeatureFormException;
import org.gvsig.featureform.swing.JFeatureForm;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.searchpanel.FeatureStoreSearchPanel;
import org.gvsig.fmap.dal.swing.searchpanel.SearchParameters;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.DatePickerController;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.vcsgis.lib.UserCancelledException;
import org.gvsig.vcsgis.lib.VCSGisChange;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.VCSGisRuntimeException;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlan;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlanStatus;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceChange;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceChanges;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.swing.VCSGisEntitySelectorController;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.changes.LocalChangesTableModel;
import org.gvsig.vcsgis.swing.impl.changes.TopologyPlansExecutor;
import org.gvsig.vcsgis.swing.impl.changes.VCSGisJChangesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalChangesController
extends AbstractDisposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalChangesController.class);
    private final JButton btnLocalCheckRecomendedEntities;
    private final JButton btnLocalCheckAllEntities;
    private final JButton btnLocalUnCheckAllEntities;
    private final JButton btnLocalExpandAllEntities;
    private final JButton btnLocalCollapseAllEntities;
    private final JTable tblLocalChanges;
    private final JButton btnLocalCheckAll;
    private final JButton btnLocalUnCheckAll;
    private final JButton btnLocalShowForm;
    private final JButton btnLocalRefresh;
    private final JButton btnLocalCommit;
    private final JButton btnLocalRevert;
    private final JLabel lblLocalEffectiveDate;
    private final JTextField txtLocalEffectiveDate;
    private final JTextField txtLocalComment;
    private final JButton btnLocalEffectiveDate;
    private final JLabel lblLocalComment;
    private final PickerController<VCSGisWorkspace> workspacePicker;
    private final VCSGisJChangesImpl context;
    private final JButton btnLocalZoom;
    private final JButton btnLocalCenter;
    private final JButton btnLocalHighlight;
    private final JLabel lblLocalChangesCount;
    private final JButton btnExecuteTopologyPlan;
    private VCSGisWorkspaceChanges<VCSGisWorkspaceChange> changes;
    private LocalChangesTableModel localChangesTableModel;
    private List<VCSGisWorkspaceEntity> entitiesWithSelectedChanges = null;
    private DatePickerController effectiveDatePicker;
    private final Set<String> entitiesToUnCheckAll;
    private TableModelListener tableModelListener;
    private boolean dissabledUncheckAllByEntities = false;
    private final JButton btnLocalCleanHighlighted;
    private final JTextField txtLocalTablesFilter;
    private final JButton btnLocalTable;
    private final JTree treeLocalTables;
    private VCSGisEntitySelectorController entitySelector;
    private boolean isSelectionFromEntitiesEmpty;
    private final JButton btnFilterAdd;
    private final JButton btnFilterRemove;

    public LocalChangesController(VCSGisJChangesImpl context, PickerController<VCSGisWorkspace> workspacePicker, JButton btnLocalCheckRecomendedEntities, JButton btnLocalCheckAllEntities, JButton btnLocalUnCheckAllEntities, JButton btnLocalExpandAllEntities, JButton btnLocalCollapseAllEntities, JTable tblLocalChanges, JButton btnLocalCheckAll, JButton btnLocalUnCheckAll, JButton btnLocalShowForm, JButton btnLocalRefresh, JButton btnLocalCommit, JButton btnLocalRevert, JLabel lblLocalEffectiveDate, JTextField txtLocalEffectiveDate, JTextField txtLocalComment, JButton btnLocalEffectiveDate, JLabel lblLocalComment, JButton btnLocalZoom, JButton btnLocalCenter, JButton btnLocalHighlight, JButton btnLocalCleanHighlighted, JLabel lblLocalChangesCount, JTextField txtLocalTablesFilter, JButton btnLocalTable, JTree treeLocalTables, JButton btnExecuteTopologyPlan, JButton btnFilterAdd, JButton btnFilterRemove) {
        this.context = context;
        this.workspacePicker = workspacePicker;
        this.tblLocalChanges = tblLocalChanges;
        this.btnLocalCheckRecomendedEntities = btnLocalCheckRecomendedEntities;
        this.btnLocalCheckAll = btnLocalCheckAll;
        this.btnLocalCheckAllEntities = btnLocalCheckAllEntities;
        this.btnLocalExpandAllEntities = btnLocalExpandAllEntities;
        this.btnLocalCollapseAllEntities = btnLocalCollapseAllEntities;
        this.btnLocalCommit = btnLocalCommit;
        this.btnLocalEffectiveDate = btnLocalEffectiveDate;
        this.btnLocalRefresh = btnLocalRefresh;
        this.btnLocalRevert = btnLocalRevert;
        this.btnLocalShowForm = btnLocalShowForm;
        this.btnLocalUnCheckAll = btnLocalUnCheckAll;
        this.btnLocalUnCheckAllEntities = btnLocalUnCheckAllEntities;
        this.lblLocalComment = lblLocalComment;
        this.lblLocalEffectiveDate = lblLocalEffectiveDate;
        this.txtLocalComment = txtLocalComment;
        this.txtLocalEffectiveDate = txtLocalEffectiveDate;
        this.btnLocalZoom = btnLocalZoom;
        this.btnLocalCenter = btnLocalCenter;
        this.btnLocalHighlight = btnLocalHighlight;
        this.btnLocalCleanHighlighted = btnLocalCleanHighlighted;
        this.lblLocalChangesCount = lblLocalChangesCount;
        this.btnFilterAdd = btnFilterAdd;
        this.btnFilterRemove = btnFilterRemove;
        this.txtLocalTablesFilter = txtLocalTablesFilter;
        this.btnLocalTable = btnLocalTable;
        this.treeLocalTables = treeLocalTables;
        this.btnExecuteTopologyPlan = btnExecuteTopologyPlan;
        this.entitiesToUnCheckAll = new HashSet<String>();
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        VCSGisSwingManager vcsgisSwingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        this.translate();
        this.btnLocalCheckAllEntities.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalUnCheckAllEntities.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalCheckAll.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalCommit.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalEffectiveDate.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalRefresh.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalRevert.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalShowForm.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalUnCheckAll.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalZoom.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalCenter.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalHighlight.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLocalCleanHighlighted.setCursor(Cursor.getPredefinedCursor(12));
        this.btnExecuteTopologyPlan.setCursor(Cursor.getPredefinedCursor(12));
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnFilterAdd, (String)"_Filter_commit_contents", (String)"common-filter-add", e -> this.doFilterAdd(), null);
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnFilterAdd, (String)"_Remove_filter_of_commit_contents", (String)"common-filter-remove", e -> this.doFilterRemove(), null);
        this.btnLocalCheckAllEntities.addActionListener(e -> this.entitySelector.checkAll());
        this.btnLocalUnCheckAllEntities.addActionListener(e -> this.entitySelector.clearChecks());
        this.btnLocalCollapseAllEntities.addActionListener(e -> this.entitySelector.collapseAll());
        this.btnLocalExpandAllEntities.addActionListener(e -> this.entitySelector.expandAll());
        this.entitySelector = VCSGisSwingLocator.getVCSGisSwingManager().createEntitySelectorController(this.treeLocalTables, (JTextComponent)this.txtLocalTablesFilter, this.btnLocalTable);
        this.entitySelector.setViewFilter(VCSGisEntitySelectorController.LOCAL_ENTITIES);
        this.entitySelector.setFilter(VCSGisEntitySelectorController.LOCAL_ENTITIES);
        this.entitySelector.setChecksEnabled(true);
        this.entitySelector.addChangeListener(e -> this.doUpdateTableLocalChanges());
        this.entitySelector.addActionListener(e -> {
            switch (e.getID()) {
                case 0: {
                    this.doUpdateComponents();
                    break;
                }
                case 1: {
                    this.doUpdateTableLocalChanges();
                    this.doUpdateComponents();
                    break;
                }
                case 2: {
                    this.doUpdateTableLocalChanges();
                    this.doUpdateComponents();
                }
            }
        });
        this.tblLocalChanges.getSelectionModel().setSelectionMode(2);
        this.tblLocalChanges.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    LocalChangesController.this.doToggleSelection();
                }
            }
        });
        this.tblLocalChanges.getSelectionModel().addListSelectionListener(e -> {
            this.doUpdateEntitiesWithSelectedChanges();
            this.doUpdateIsSelectionFromEntitiesEmpty();
            this.context.doUpdateComponents();
        });
        this.btnLocalCheckAll.addActionListener(e -> {
            if (this.changes != null) {
                this.doCheckAll();
                this.doUpdateTableLocalChanges();
            }
        });
        this.btnLocalUnCheckAll.addActionListener(e -> {
            if (this.changes != null) {
                this.doUnCheckAll();
                this.doUpdateTableLocalChanges();
            }
        });
        this.btnLocalShowForm.addActionListener(e -> this.doShowForm());
        this.btnLocalCommit.addActionListener(e -> this.doCommit());
        this.btnLocalRevert.addActionListener(e -> this.doRevert(e.getModifiers()));
        this.effectiveDatePicker = toolsSwingManager.createDatePickerController((JTextComponent)this.txtLocalEffectiveDate, this.btnLocalEffectiveDate);
        if (vcsgisSwingManager.useCurrentDateAsEffectiveDateByDefault()) {
            this.effectiveDatePicker.set((Object)new Date());
        } else {
            this.effectiveDatePicker.set(null);
        }
        this.effectiveDatePicker.addChangeListener(e -> this.doUpdateComponents());
        this.btnLocalRefresh.addActionListener(e -> this.doUpdateTableLocalChanges());
        this.btnLocalZoom.addActionListener(e -> this.doZoomToSelectedChange());
        this.btnLocalCenter.addActionListener(e -> this.doCenterToSelectedChange());
        this.btnLocalHighlight.addActionListener(e -> this.doHighLightSelectedChange());
        this.btnLocalCleanHighlighted.addActionListener(e -> VCSGisSwingCommons.cleanHighligthed());
        this.btnExecuteTopologyPlan.addActionListener(e -> this.doExecuteTopologyPlan());
        this.btnLocalCheckRecomendedEntities.addActionListener(e -> this.doCheckRecomendedEntities());
        toolsSwingManager.addClearButton((JTextComponent)this.txtLocalComment);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtLocalComment);
        this.context.doUpdateComponents();
    }

    public void doChangeWorkspace() {
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        this.entitySelector.setWorkspace(ws);
        if (ws != null) {
            for (String tableName : this.context.getDefaultTablesSelection()) {
                VCSGisWorkspaceEntity entity = ws.getWorkspaceEntity(tableName);
                if (entity == null) continue;
                this.entitySelector.check((VCSGisEntity)entity);
            }
        }
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((AbstractButton)this.btnLocalCheckRecomendedEntities);
        swingManager.translate((AbstractButton)this.btnLocalCheckAllEntities);
        swingManager.translate((AbstractButton)this.btnLocalUnCheckAllEntities);
        swingManager.translate((AbstractButton)this.btnLocalCheckAll);
        swingManager.translate((AbstractButton)this.btnLocalCommit);
        swingManager.translate((AbstractButton)this.btnLocalRefresh);
        swingManager.translate((AbstractButton)this.btnLocalRevert);
        swingManager.translate((AbstractButton)this.btnLocalShowForm);
        swingManager.translate((AbstractButton)this.btnLocalUnCheckAll);
        swingManager.translate(this.lblLocalEffectiveDate);
        swingManager.translate(this.lblLocalComment);
        swingManager.translate((AbstractButton)this.btnLocalCenter);
        swingManager.translate((AbstractButton)this.btnLocalHighlight);
        swingManager.translate((AbstractButton)this.btnLocalZoom);
        swingManager.translate((AbstractButton)this.btnLocalCleanHighlighted);
        swingManager.translate((AbstractButton)this.btnLocalCollapseAllEntities);
        swingManager.translate((AbstractButton)this.btnLocalExpandAllEntities);
    }

    private Iterator<Long> getSelectionIterator() {
        final ListSelectionModel selection = this.tblLocalChanges.getSelectionModel();
        return new Iterator<Long>(){
            long n;
            {
                this.n = selection.getMinSelectionIndex();
            }

            @Override
            public boolean hasNext() {
                while (this.n <= (long)selection.getMaxSelectionIndex()) {
                    if (selection.isSelectedIndex((int)this.n)) {
                        return true;
                    }
                    ++this.n;
                }
                return false;
            }

            @Override
            public Long next() {
                if (this.n > (long)selection.getMaxSelectionIndex()) {
                    throw new IllegalStateException();
                }
                return this.n++;
            }
        };
    }

    private void doToggleSelection() {
        Thread task = new Thread(() -> {
            try {
                this.context.processing = true;
                this.context.doUpdateComponents();
                Iterator<Long> rows = this.getSelectionIterator();
                this.changes.process(rows, change -> {
                    if (change.getOperation() == 3 && change.isSelected()) {
                        this.entitiesToUnCheckAll.add(change.getEntityCode());
                    }
                    change.setSelected(!change.isSelected());
                    return true;
                });
                if (!this.entitiesToUnCheckAll.isEmpty()) {
                    this.doUnCheckAllByEntities();
                }
            }
            finally {
                this.doUpdateEntitiesWithSelectedChanges();
                this.doUpdateIsSelectionFromEntitiesEmpty();
                this.context.processing = false;
                this.context.doUpdateComponents();
            }
        }, "VCSGisToggleSelectionLocalChanges");
        task.start();
    }

    private Iterator<Long> getRowsByEntitiesToUnCheckIterator() {
        final long size = this.changes.size64();
        TableModel model = this.tblLocalChanges.getModel();
        return new Iterator<Long>(){
            long n = 0L;

            @Override
            public boolean hasNext() {
                while (this.n < size) {
                    VCSGisWorkspaceChange row = (VCSGisWorkspaceChange)LocalChangesController.this.changes.get64(this.n);
                    if (LocalChangesController.this.entitiesToUnCheckAll.contains(row.getEntityCode())) {
                        return true;
                    }
                    ++this.n;
                }
                return false;
            }

            @Override
            public Long next() {
                return this.n++;
            }
        };
    }

    private void doUnCheckAllByEntities() {
        if (this.dissabledUncheckAllByEntities) {
            return;
        }
        Thread task = new Thread(() -> {
            try {
                this.context.processing = true;
                this.context.doUpdateComponents();
                if (!this.entitiesToUnCheckAll.isEmpty()) {
                    Iterator<Long> rows = this.getRowsByEntitiesToUnCheckIterator();
                    this.changes.process(rows, change -> {
                        if (change.getOperation() != 3) {
                            change.setSelected(false);
                        }
                        return true;
                    });
                    this.entitiesToUnCheckAll.clear();
                }
            }
            finally {
                this.doUpdateEntitiesWithSelectedChanges();
                this.context.processing = false;
                this.context.doUpdateComponents();
            }
        }, "VCSGisUnCheckAllByEntitiesLocalChanges");
        task.start();
    }

    private Iterator<Long> getRowsIterator() {
        final long size = this.changes.size64();
        return new Iterator<Long>(){
            long n = 0L;

            @Override
            public boolean hasNext() {
                return this.n < size;
            }

            @Override
            public Long next() {
                return this.n++;
            }
        };
    }

    private void doCheckAll() {
        Thread task = new Thread(() -> {
            try {
                this.context.processing = true;
                this.dissabledUncheckAllByEntities = true;
                this.context.doUpdateComponents();
                this.changes.setSelectionAll();
            }
            finally {
                this.context.processing = false;
                this.dissabledUncheckAllByEntities = false;
                this.context.doUpdateComponents();
            }
        }, "VCSGisCheckAllLocalChanges");
        task.start();
    }

    private void doUnCheckAll() {
        Thread task = new Thread(() -> {
            try {
                this.context.processing = true;
                this.dissabledUncheckAllByEntities = true;
                this.context.doUpdateComponents();
                this.changes.clearSelection();
            }
            finally {
                this.context.processing = false;
                this.dissabledUncheckAllByEntities = false;
                this.context.doUpdateComponents();
            }
        }, "VCSGisUncheckAllLocalChanges");
        task.start();
    }

    private VCSGisWorkspace getUndisposableWorkspace() {
        VCSGisWorkspace ws = this.getWorkspace();
        DisposeUtils.disposeQuietly((Disposable)ws);
        return ws;
    }

    private VCSGisWorkspace getWorkspace() {
        VCSGisWorkspace ws = this.context.getWorkspace();
        return ws;
    }

    void doUpdateComponents() {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.doUpdateComponents())) {
            return;
        }
        VCSGisSwingManager vcsgisSwingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        try {
            VCSGisWorkspaceChange change;
            this.context.message("");
            boolean changesIsEmpty = this.changes == null || this.changes.isEmpty();
            this.context.setVisibleStatus(this.context.processing);
            VCSGisWorkspace ws = this.getUndisposableWorkspace();
            this.context.updateEntitiesFromRepository(false);
            this.context.btnClose.setEnabled(!this.context.processing);
            this.entitySelector.setEnabled(!this.context.processing);
            this.effectiveDatePicker.setEnabled(!this.context.processing);
            this.workspacePicker.setEnabled(!this.context.processing);
            this.btnLocalCheckAll.setEnabled(!this.context.processing && !changesIsEmpty);
            this.btnLocalUnCheckAll.setEnabled(!this.context.processing && !changesIsEmpty);
            List checkedEntities = this.entitySelector.getCheckedEntities();
            this.btnLocalRefresh.setEnabled(!this.context.processing && this.changes != null && CollectionUtils.isNotEmpty((Collection)checkedEntities));
            this.btnLocalRevert.setEnabled(ws != null && !this.context.processing && !changesIsEmpty && CollectionUtils.isNotEmpty((Collection)checkedEntities) && this.entitiesWithSelectedChanges != null && !this.entitiesWithSelectedChanges.isEmpty() && !this.isSelectionFromEntitiesEmpty);
            this.btnLocalRevert.setVisible(true);
            if (ws != null && !this.context.processing && this.changes != null && !this.changes.isSelectionEmpty() && CollectionUtils.isNotEmpty((Collection)checkedEntities) && this.entitiesWithSelectedChanges != null && !this.entitiesWithSelectedChanges.isEmpty() && !this.isSelectionFromEntitiesEmpty && this.effectiveDatePicker.isValid()) {
                MutableObject msg = new MutableObject();
                if (this.areCorruptOrDisconnectedEntities(checkedEntities)) {
                    this.context.alert("_There_are_selected_corrupted_or_disconnected_entities");
                    this.btnLocalCommit.setEnabled(false);
                    LOGGER.info("Can't enable commit (1.2). There are selected corrupted or disconnected entities.");
                } else if (!ws.canCommit(msg, this.getEntityCodes(checkedEntities))) {
                    this.context.alert((String)msg.getValue());
                    this.btnLocalCommit.setEnabled(false);
                    LOGGER.info("Can't enable commit (1). " + (String)msg.getValue());
                } else if (!vcsgisSwingManager.isEmptyEffectiveDateAllowed() && this.effectiveDatePicker.isEmpty()) {
                    this.context.alert("_Effective_date_is_required");
                    this.btnLocalCommit.setEnabled(false);
                    LOGGER.info("Can't enable commit (1.1). Efective date is required");
                } else {
                    this.btnLocalCommit.setEnabled(true);
                }
            } else {
                try {
                    if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
                        this.context.message("_Select_tables_to_view_changes");
                        LOGGER.info("Can't enable commit (2).");
                    } else if (this.changes == null || this.changes.isSelectionEmpty()) {
                        this.context.message("_Select_the_changes_to_commit");
                        LOGGER.info("Can't enable commit (3).");
                    } else if (this.entitiesWithSelectedChanges == null || this.entitiesWithSelectedChanges.isEmpty()) {
                        this.context.message("_Cant_locate_the_tables_related_to_changes");
                        LOGGER.info("Can't enable commit (4).");
                    } else if (this.isSelectionFromEntitiesEmpty) {
                        this.context.message("_Cant_locate_changes_in_selected_tables");
                        LOGGER.info("Can't enable commit (5).");
                    } else {
                        LOGGER.info("Can't enable commit (6).");
                    }
                }
                catch (Exception ex) {
                    LOGGER.info("Can't enable commit (7).");
                }
                this.btnLocalCommit.setEnabled(false);
            }
            boolean enableShowForm = false;
            int row = this.tblLocalChanges.getSelectedRow();
            if (!this.context.processing && row >= 0 && (change = (VCSGisWorkspaceChange)this.changes.get64((long)row)).getOperation() != 3) {
                enableShowForm = true;
            }
            this.btnLocalShowForm.setEnabled(!this.context.processing && enableShowForm);
            this.tblLocalChanges.setEnabled(!this.context.processing);
            this.txtLocalComment.setEnabled(!this.context.processing);
            this.effectiveDatePicker.setEnabled(!this.context.processing);
            this.workspacePicker.setEnabled(!this.context.processing);
            Geometry geom = this.getGeometryOfSelectedChange();
            Geometry originalGeom = this.getOriginalGeometryOfSelectedChange();
            this.btnLocalCenter.setEnabled(!this.context.processing && (geom != null || originalGeom != null));
            this.btnLocalHighlight.setEnabled(!this.context.processing && (geom != null || originalGeom != null));
            this.btnLocalZoom.setEnabled(!this.context.processing && (geom != null || originalGeom != null));
            this.btnLocalCleanHighlighted.setEnabled(!this.context.processing);
            VCSGisEntity selectedEntity = this.entitySelector.getSelectedEntity();
            this.btnExecuteTopologyPlan.setEnabled(!this.context.processing && selectedEntity != null && StringUtils.isNotBlank((CharSequence)selectedEntity.getTopologyPlanCode()));
        }
        catch (VCSGisRuntimeException e1) {
            LOGGER.warn("Can't updating components.", (Throwable)e1);
            if (VCSGisSwingCommons.showAuthenticationErrors("_VCS_Changes", e1)) {
                this.workspacePicker.set(null);
                this.doChangeWorkspace();
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Can't updating components.", (Throwable)e2);
        }
    }

    public void doReloadTables() {
        this.entitySelector.reloadEntities();
    }

    public void doUpdateEntitiesWithSelectedChanges() {
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws != null) {
            this.entitiesWithSelectedChanges = ws.getEntitiesWithSelectedChanges();
        }
    }

    private void doUpdateIsSelectionFromEntitiesEmpty() {
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws != null) {
            List checkedEntities = this.entitySelector.getCheckedEntities();
            this.isSelectionFromEntitiesEmpty = this.changes.isSelectionFromEntitiesEmpty(checkedEntities);
        }
    }

    public void doUpdateTableLocalChanges() {
        if (this.context.processing) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws != null) {
            this.doUpdateEntitiesWithSelectedChanges();
            List checkedEntities = this.entitySelector.getCheckedEntities();
            if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
                this.localChangesTableModel = new LocalChangesTableModel(ws);
                this.tblLocalChanges.setModel(this.localChangesTableModel);
                return;
            }
            this.changes = ws.getLocalChanges(checkedEntities);
            this.localChangesTableModel = new LocalChangesTableModel(this.changes, ws);
            this.tblLocalChanges.setModel(this.localChangesTableModel);
            int columns = this.tblLocalChanges.getColumnModel().getColumnCount();
            for (int i = 1; i < columns; ++i) {
                this.tblLocalChanges.getColumnModel().getColumn(i).setCellRenderer(new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        VCSGisChange changeRow = (VCSGisChange)LocalChangesController.this.changes.get64((long)row);
                        VCSGisSwingCommons.setColorCompoment(c, changeRow.getStatus());
                        return c;
                    }
                });
            }
            this.tableModelListener = null;
            this.localChangesTableModel.addTableModelListener(this.getTableModelListener());
            this.context.message(i18n.getTranslation("_Workingcopy_changes_list_updated", new String[]{String.valueOf(this.changes.size64())}));
            this.lblLocalChangesCount.setText(String.valueOf(this.changes.size64()));
        }
        this.doUpdateIsSelectionFromEntitiesEmpty();
        this.context.doUpdateComponents();
    }

    private TableModelListener getTableModelListener() {
        if (this.tableModelListener == null) {
            this.tableModelListener = e -> {
                if (e.getType() == 0) {
                    TableModel model = (TableModel)e.getSource();
                    VCSGisWorkspaceChange change = (VCSGisWorkspaceChange)this.changes.get64((long)e.getFirstRow());
                    if (change.getOperation() == 3 && !change.isSelected() && this.entitiesToUnCheckAll.add(change.getEntityCode())) {
                        this.doUnCheckAllByEntities();
                    }
                }
            };
        }
        return this.tableModelListener;
    }

    private void doShowForm() {
        int row = this.tblLocalChanges.getSelectedRow();
        VCSGisWorkspaceChange change = (VCSGisWorkspaceChange)this.changes.get64((long)row);
        if (change.getOperation() == 0 || change.getOperation() == 3) {
            return;
        }
        Feature feature = change.getRelatedFeature();
        if (feature == null) {
            return;
        }
        try {
            DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
            JFeatureForm form = dataSwingManager.createJFeatureForm(feature);
            WindowManager winManager = ToolsSwingLocator.getWindowManager();
            form.asJComponent().setPreferredSize(new Dimension(400, 200));
            winManager.showWindow(form.asJComponent(), "Local change: " + change.getLabel(), WindowManager.MODE.WINDOW);
        }
        catch (CreateJFeatureFormException ex) {
            LOGGER.warn("Can't show form", (Throwable)ex);
        }
    }

    private void doCommit() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return;
        }
        List entities = this.entitySelector.getCheckedEntities();
        List<String> entityCodes = this.getEntityCodes(entities);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return;
        }
        this.context.updateEntitiesFromRepository(false);
        MutableObject message = new MutableObject();
        if (!ws.canCommit(message, entityCodes)) {
            dialogs.messageDialog(i18n.getTranslation("_Cant_commit") + "\n" + (String)message.getValue(), i18n.getTranslation("_Commit"), 2);
            return;
        }
        Timestamp effectiveDate = this.effectiveDatePicker.getTimestamp();
        this.tblLocalChanges.setModel(new LocalChangesTableModel(ws));
        ArrayList topologicPlanStatusList = new ArrayList();
        Thread task = new Thread(() -> {
            try {
                int r;
                this.context.processing = true;
                this.context.doUpdateComponents();
                if (!this.existsAllTopologyPlansLocally(ws, entities)) {
                    ws.updateTopologyPlansFromRepository(null);
                }
                if (!this.executeTopologyPlans(ws, entities, topologicPlanStatusList)) {
                    dialogs.messageDialog(i18n.getTranslation("_Cant_pass_topology_plans"), i18n.getTranslation("_Commit"), 2);
                    return;
                }
                Timestamp theEffectiveDate = effectiveDate;
                if (theEffectiveDate == null) {
                    theEffectiveDate = Timestamp.valueOf(LocalDateTime.now());
                }
                if ((r = ws.commit(entityCodes, null, theEffectiveDate, this.txtLocalComment.getText(), this.context.getTaskStatusController().getSimpleTaskStatus(), topologicPlanStatusList)) == 33) {
                    ws.updateTopologyPlansFromRepository(null);
                }
                this.doPostCommit(r);
            }
            catch (UserCancelledException ex) {
                LOGGER.warn("User cancelled");
            }
            finally {
                this.context.processing = false;
                this.context.doUpdateComponents();
            }
        }, "VCSGisCommit");
        this.context.processing = true;
        this.context.doUpdateComponents();
        task.start();
    }

    private boolean executeTopologyPlans(VCSGisWorkspace ws, List<VCSGisEntity> entities, List<VCSGisTopologyPlanStatus> topologicPlanStatus) {
        boolean hasTopologyPlans = false;
        for (VCSGisEntity entity : entities) {
            VCSGisTopologyPlan topologyPlan = ws.getTopologyPlan(entity.getTopologyPlanCode());
            if (topologyPlan == null || !StringUtils.isNotBlank((CharSequence)topologyPlan.getData())) continue;
            hasTopologyPlans = true;
            break;
        }
        if (!hasTopologyPlans) {
            return true;
        }
        try {
            TopologyPlansExecutor executor = new TopologyPlansExecutor();
            return executor.execute(ws, entities, topologicPlanStatus, true);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void doPostCommit(int commitStatus) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.doPostCommit(commitStatus))) {
            return;
        }
        switch (commitStatus) {
            case 0: {
                this.context.setVisibleStatus(false);
                break;
            }
            case 33: {
                I18nManager i18n = ToolsLocator.getI18nManager();
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                dialogs.messageDialog(i18n.getTranslation("_TopologyPlan_has_been_updated_please_retry_commit"), i18n.getTranslation("_VCS_Commit"), 2);
                break;
            }
            default: {
                VCSGisSwingCommons.showAuthenticationErrors("_VCS_Commit", commitStatus);
            }
        }
        this.entitySelector.reloadEntities();
        this.context.updateLocalChangesTable();
        VCSGisSwingCommons.cleanHighligthed();
    }

    private void doRevert(int modifiers) {
        boolean continueOnError;
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return;
        }
        this.context.updateEntitiesFromRepository(false);
        List entities = ws.getEntitiesWithSelectedChanges();
        List<String> selectedEntityCodes = this.getEntityCodes(this.entitySelector.getCheckedEntities());
        if (selectedEntityCodes.isEmpty()) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        if ((modifiers & 1) == 1) {
            if (selectedEntityCodes.size() > 1) {
                dialogs.messageDialog(i18n.getTranslation("_There_should_only_be_one_entity_selected"), i18n.getTranslation("_VCSGis_Revert"), 2);
                return;
            }
            int selectedsCount = ws.getLocalChangesSelectedCount(selectedEntityCodes.get(0));
            if (selectedsCount != 1) {
                dialogs.messageDialog(i18n.getTranslation("_Only_one_record_should_be_selected_in_a_forced_revert"), i18n.getTranslation("_VCSGis_Revert"), 2);
                return;
            }
            int n = dialogs.confirmDialog(i18n.getTranslation("_If_the_operation_fails_it_will_be_forced_if_data_recovery_is_possible") + "\n" + i18n.getTranslation("_This_operation_is_risky_perform_it_only_if_you_are_sure") + "\n" + i18n.getTranslation("_The_entry_will_be_deleted_from_the_local_change_log") + "\n" + i18n.getTranslation("_Once_the_process_is_complete_verify_that_your_data_has_been_recovered_successfully") + "\n" + i18n.getTranslation("De no ser asi tendra que hacer un checkout o descargar una copia preparada para recuperar sus datos") + "\n\n" + i18n.getTranslation("_Do_you_want_to_continue"), i18n.getTranslation("_VCSGis_Revert"), 0, 2);
            if (n != 0) {
                return;
            }
            continueOnError = true;
        } else {
            int n = dialogs.confirmDialog(i18n.getTranslation("_This_operation_reverts_the_selected_changes") + "\n\n" + i18n.getTranslation("_Do_you_want_to_continue"), i18n.getTranslation("_VCSGis_Revert"), 0, 2);
            if (n != 0) {
                return;
            }
            continueOnError = false;
        }
        Thread task = new Thread(() -> {
            try {
                this.context.processing = true;
                this.context.doUpdateComponents();
                int r = 0;
                if (!entities.isEmpty() && CollectionUtils.isNotEmpty((Collection)selectedEntityCodes)) {
                    for (VCSGisWorkspaceEntity entity : entities) {
                        if (selectedEntityCodes.contains(entity.getEntityCode())) {
                            r = ws.revert(entity.getEntityCode(), continueOnError, this.context.getTaskStatusController().getSimpleTaskStatus());
                        }
                        if (r == 0) continue;
                        break;
                    }
                }
                this.doPostRevert(r, entities);
            }
            catch (UserCancelledException ex) {
                LOGGER.warn("User cancelled");
            }
            finally {
                this.context.processing = false;
                this.context.doUpdateComponents();
            }
        }, "VCSGisRevert");
        this.context.processing = true;
        this.context.doUpdateComponents();
        task.start();
    }

    private void doPostRevert(int revertStatus, List<VCSGisWorkspaceEntity> entities) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.doPostRevert(revertStatus, entities))) {
            return;
        }
        if (revertStatus == 0) {
            this.context.setVisibleStatus(false);
        }
        for (VCSGisWorkspaceEntity entity : entities) {
            FeatureStore store = this.getUndisposableWorkspace().getFeatureStore(entity.getEntityName());
            VCSGisSwingCommons.refreshDocument(store);
        }
        this.context.updateLocalChangesTable();
        VCSGisSwingCommons.cleanHighligthed();
    }

    private Geometry getBBoxOfSelectedChanges() {
        int[] selecteds = this.tblLocalChanges.getSelectedRows();
        if (selecteds != null && selecteds.length >= 0) {
            Envelope env = GeometryUtils.createEnvelope((int)0);
            for (int i = 0; i < selecteds.length; ++i) {
                int selected = selecteds[i];
                VCSGisWorkspaceChange change = (VCSGisWorkspaceChange)this.changes.get64((long)selected);
                try {
                    Feature feature = change.getRelatedFeature();
                    Geometry geom = feature.getDefaultGeometry();
                    env.add(geom);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!env.isEmpty()) {
                return env.getBox2D();
            }
        }
        return null;
    }

    private Geometry getOriginalBBoxOfSelectedChanges() {
        int[] selecteds = this.tblLocalChanges.getSelectedRows();
        if (selecteds != null && selecteds.length >= 0) {
            Envelope env = GeometryUtils.createEnvelope((int)0);
            for (int i = 0; i < selecteds.length; ++i) {
                int selected = selecteds[i];
                VCSGisWorkspaceChange change = (VCSGisWorkspaceChange)this.changes.get64((long)selected);
                try {
                    VCSGisWorkspace ws = this.getUndisposableWorkspace();
                    if (ws == null) continue;
                    JsonObject json = change.getDataAsJson();
                    String entityCode = change.getEntityCode();
                    VCSGisEntity entity = ws.getEntity(entityCode);
                    FeatureStore store = ws.openFeatureStore(entity.getEntityName(), false);
                    EditableFeature feature = store.createNewFeature(json);
                    Geometry geom = feature.getDefaultGeometry();
                    env.add(geom);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!env.isEmpty()) {
                return env.getBox2D();
            }
        }
        return null;
    }

    private Geometry getGeometryOfSelectedChange() {
        Geometry geom = null;
        try {
            if (this.tblLocalChanges.getSelectedRowCount() > 1 && this.tblLocalChanges.getSelectedRowCount() < 200) {
                for (int selectedRow : this.tblLocalChanges.getSelectedRows()) {
                    VCSGisWorkspaceChange change = (VCSGisWorkspaceChange)this.changes.get64((long)selectedRow);
                    Feature feature = change.getRelatedFeature();
                    Geometry currentGeom = feature.getDefaultGeometry();
                    if (currentGeom == null) continue;
                    if (geom == null) {
                        int type = currentGeom.getType();
                        if (GeometryUtils.isSubtype((int)1, (int)type) || GeometryUtils.isSubtype((int)7, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiPoint(currentGeom.getGeometryType().getSubType());
                        } else if (GeometryUtils.isSubtype((int)18, (int)type) || GeometryUtils.isSubtype((int)21, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiCurve(currentGeom.getGeometryType().getSubType());
                        } else if (GeometryUtils.isSubtype((int)3, (int)type) || GeometryUtils.isSubtype((int)9, (int)type)) {
                            geom = GeometryLocator.getGeometryManager().createMultiSurface(currentGeom.getGeometryType().getSubType());
                        } else {
                            return geom;
                        }
                    }
                    ((MultiPrimitive)geom).addPrimitives(currentGeom);
                }
            } else {
                int selected = this.tblLocalChanges.getSelectedRow();
                if (selected >= 0) {
                    VCSGisWorkspaceChange change = (VCSGisWorkspaceChange)this.changes.get64((long)selected);
                    try {
                        Feature feature = change.getRelatedFeature();
                        geom = feature.getDefaultGeometry();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return geom;
        }
        catch (Exception ex) {
            return geom;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Geometry getOriginalGeometryOfSelectedChange() {
        Geometry geom = null;
        try {
            if (this.tblLocalChanges.getSelectedRowCount() > 1 && this.tblLocalChanges.getSelectedRowCount() < 200) {
                int[] nArray = this.tblLocalChanges.getSelectedRows();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int selectedRow = nArray[n2];
                    VCSGisWorkspaceChange change = (VCSGisWorkspaceChange)this.changes.get64((long)selectedRow);
                    try {
                        VCSGisWorkspace ws = this.getUndisposableWorkspace();
                        if (ws != null) {
                            JsonObject json = change.getDataAsJson();
                            String entityCode = change.getEntityCode();
                            VCSGisEntity entity = ws.getEntity(entityCode);
                            FeatureStore store = ws.openFeatureStore(entity.getEntityName(), false);
                            EditableFeature feature = store.createNewFeature(json);
                            Geometry currentGeom = feature.getDefaultGeometry();
                            if (currentGeom != null) {
                                if (geom == null) {
                                    int type = currentGeom.getType();
                                    if (GeometryUtils.isSubtype((int)1, (int)type) || GeometryUtils.isSubtype((int)7, (int)type)) {
                                        geom = GeometryLocator.getGeometryManager().createMultiPoint(currentGeom.getGeometryType().getSubType());
                                    } else if (GeometryUtils.isSubtype((int)18, (int)type) || GeometryUtils.isSubtype((int)21, (int)type)) {
                                        geom = GeometryLocator.getGeometryManager().createMultiCurve(currentGeom.getGeometryType().getSubType());
                                    } else {
                                        if (!GeometryUtils.isSubtype((int)3, (int)type)) {
                                            if (!GeometryUtils.isSubtype((int)9, (int)type)) return geom;
                                        }
                                        geom = GeometryLocator.getGeometryManager().createMultiSurface(currentGeom.getGeometryType().getSubType());
                                    }
                                }
                                ((MultiPrimitive)geom).addPrimitives(currentGeom);
                            }
                        }
                    }
                    catch (Exception ws) {
                        // empty catch block
                    }
                    ++n2;
                }
                return geom;
            }
            int selected = this.tblLocalChanges.getSelectedRow();
            if (selected < 0) return geom;
            VCSGisWorkspaceChange change = (VCSGisWorkspaceChange)this.changes.get64((long)selected);
            try {
                VCSGisWorkspace ws = this.getUndisposableWorkspace();
                if (ws == null) return geom;
                JsonObject json = change.getDataAsJson();
                String entityCode = change.getEntityCode();
                VCSGisEntity entity = ws.getEntity(entityCode);
                FeatureStore store = ws.openFeatureStore(entity.getEntityName(), false);
                EditableFeature feature = store.createNewFeature(json);
                return feature.getDefaultGeometry();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return geom;
        }
        catch (Exception ex) {
            return geom;
        }
    }

    private FeatureStore getStoreOfSelectedChange() {
        FeatureStore store = null;
        int selected = this.tblLocalChanges.getSelectedRow();
        if (selected >= 0) {
            VCSGisWorkspaceChange change = (VCSGisWorkspaceChange)this.changes.get64((long)selected);
            try {
                VCSGisWorkspace ws = this.getUndisposableWorkspace();
                if (ws != null) {
                    String entityCode = change.getEntityCode();
                    VCSGisEntity entity = ws.getEntity(entityCode);
                    store = ws.openFeatureStore(entity.getEntityName(), false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return store;
    }

    private void doZoomToSelectedChange() {
        VCSGisSwingCommons.cleanHighligthed();
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        FeatureStore store = this.getStoreOfSelectedChange();
        if (this.tblLocalChanges.getSelectedRowCount() > 200) {
            Geometry geom = this.getBBoxOfSelectedChanges();
            Geometry originalGeom = this.getOriginalBBoxOfSelectedChanges();
            services.zoomViewsHavingAStoreToGeometry(store, VCSGisSwingCommons.createBBox(geom, originalGeom));
            this.context.message("_Too_many_items_selected");
        } else {
            Geometry geom = this.getGeometryOfSelectedChange();
            Geometry originalGeom = this.getOriginalGeometryOfSelectedChange();
            services.zoomViewsHavingAStoreToGeometry(store, VCSGisSwingCommons.createBBox(geom, originalGeom));
            if (geom != null) {
                services.highlight(2, geom, store);
            }
            if (originalGeom != null) {
                services.highlight(3, originalGeom, store);
            }
        }
    }

    private void doCenterToSelectedChange() {
        VCSGisSwingCommons.cleanHighligthed();
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        FeatureStore store = this.getStoreOfSelectedChange();
        if (this.tblLocalChanges.getSelectedRowCount() > 200) {
            Geometry geom = this.getBBoxOfSelectedChanges();
            Geometry originalGeom = this.getOriginalBBoxOfSelectedChanges();
            services.centerViewsHavingAStoreToGeometry(store, VCSGisSwingCommons.createBBox(geom, originalGeom));
            this.context.message("_Too_many_items_selected");
        } else {
            Geometry geom = this.getGeometryOfSelectedChange();
            Geometry originalGeom = this.getOriginalGeometryOfSelectedChange();
            services.centerViewsHavingAStoreToGeometry(store, VCSGisSwingCommons.createBBox(geom, originalGeom));
            if (geom != null) {
                services.highlight(2, geom, store);
            }
            if (originalGeom != null) {
                services.highlight(3, originalGeom, store);
            }
        }
    }

    private void doHighLightSelectedChange() {
        VCSGisSwingCommons.cleanHighligthed();
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        FeatureStore store = this.getStoreOfSelectedChange();
        if (this.tblLocalChanges.getSelectedRowCount() > 200) {
            this.context.message("_Too_many_items_selected");
        } else {
            Geometry geom = this.getGeometryOfSelectedChange();
            Geometry originalGeom = this.getOriginalGeometryOfSelectedChange();
            if (geom != null) {
                services.highlight(2, geom, store);
            }
            if (originalGeom != null) {
                services.highlight(3, originalGeom, store);
            }
        }
    }

    private void doExecuteTopologyPlan() {
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws == null) {
            return;
        }
        ArrayList topologicPlanStatusList = new ArrayList();
        VCSGisEntity entity = this.entitySelector.getSelectedEntity();
        ArrayList<VCSGisEntity> entities = new ArrayList<VCSGisEntity>();
        entities.add(entity);
        Thread task = new Thread(() -> {
            try {
                this.context.processing = true;
                this.context.doUpdateComponents();
                if (entity != null) {
                    entities.add(entity);
                    try {
                        TopologyPlansExecutor executor = new TopologyPlansExecutor();
                        executor.execute(ws, entities, topologicPlanStatusList, false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.context.processing = false;
                this.context.doUpdateComponents();
            }
        }, "VCSGisTopologyplan");
        this.context.processing = true;
        this.context.doUpdateComponents();
        task.start();
    }

    private List<String> getEntityCodes(List<VCSGisEntity> entities) {
        ArrayList<String> res = new ArrayList<String>();
        for (VCSGisEntity entity : entities) {
            res.add(entity.getEntityCode());
        }
        return res;
    }

    public void selectOnlyAEntity(VCSGisEntity entity) {
        this.entitySelector.clearChecks();
        this.entitySelector.check(entity);
    }

    public void selectOnlyAEntity(List<VCSGisEntity> entities) {
        this.entitySelector.clearChecks();
        for (VCSGisEntity entity : entities) {
            this.entitySelector.check(entity);
        }
    }

    private boolean existsAllTopologyPlansLocally(VCSGisWorkspace ws, List<VCSGisEntity> entities) {
        for (VCSGisEntity entity : entities) {
            VCSGisTopologyPlan topologyPlan;
            String topologyPlanCode = entity.getTopologyPlanCode();
            if (StringUtils.isBlank((CharSequence)topologyPlanCode) || (topologyPlan = ws.getTopologyPlan(topologyPlanCode)) != null && !StringUtils.isBlank((CharSequence)topologyPlan.getData())) continue;
            return false;
        }
        return true;
    }

    protected void doDispose() throws BaseException {
        DisposeUtils.disposeQuietly((Object)this.entitySelector);
    }

    private void doCheckRecomendedEntities() {
        VCSGisWorkspace workspace = this.getUndisposableWorkspace();
        if (workspace == null) {
            return;
        }
        HashSet<String> commitEntities = new HashSet<String>();
        Collection entities = this.entitySelector.getEntities();
        for (VCSGisEntity entity : entities) {
            if (!workspace.existsInWorkspace(entity)) continue;
            VCSGisWorkspaceEntity lentity = workspace.getWorkspaceEntityByCode(entity.getEntityCode());
            switch (lentity.getState()) {
                default: {
                    commitEntities.add(entity.getEntityCode());
                }
                case 1: 
                case 6: 
                case 8: 
                case 16: 
                case 32: 
                case 128: 
                case 256: 
                case 384: 
            }
        }
        this.entitySelector.setCheck(commitEntities, true);
    }

    private boolean areCorruptOrDisconnectedEntities(List<VCSGisEntity> entities) {
        for (VCSGisEntity entity : entities) {
            VCSGisWorkspaceEntity lentity;
            int maskState;
            if (!(entity instanceof VCSGisWorkspaceEntity) || ((maskState = (lentity = (VCSGisWorkspaceEntity)entity).getState()) & 0x10) != 16 && (maskState & 0x100) != 256) continue;
            return true;
        }
        return false;
    }

    void setEfectiveDate(Timestamp efectivedate) {
        this.effectiveDatePicker.set((Object)efectivedate);
    }

    void setComment(String comment) {
        if (comment == null) {
            comment = "";
        }
        this.txtLocalComment.setText(comment);
    }

    private void doFilterRemove() {
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws != null) {
            List checkedEntities = this.entitySelector.getCheckedEntities();
            this.changes = ws.getLocalChanges(checkedEntities);
            this.localChangesTableModel = new LocalChangesTableModel(this.changes, ws);
            this.tblLocalChanges.setModel(this.localChangesTableModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilterAdd() {
        VCSGisWorkspace ws = this.getUndisposableWorkspace();
        if (ws != null) {
            List checkedEntities = this.entitySelector.getCheckedEntities();
            if (CollectionUtils.isEmpty((Collection)checkedEntities)) {
                return;
            }
            DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
            WindowManager_v2 windowmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            FeatureStore fs = null;
            try {
                fs = ws.getFeatureStore("VCSGIS_WSCHANGES");
                FeatureStoreSearchPanel searchPanel = dataSwingManager.createFeatureStoreSearchPanel(fs);
                searchPanel.setFilterOnlyMode(true);
                Dialog dialog = windowmanager.createDialog(searchPanel.asJComponent(), i18n.getTranslation("_Filter_local_changes"), null, 3);
                dialog.addActionListener(e -> {
                    if (dialog.getAction() == 1) {
                        SearchParameters searchParams = searchPanel.fetch(null);
                        FeatureQuery query = searchParams.getQueryToApply();
                        String filter = query.getFilter().getSQL();
                        this.changes = StringUtils.isBlank((CharSequence)filter) ? ws.getLocalChanges(checkedEntities) : ws.getLocalChanges(checkedEntities, filter);
                        this.localChangesTableModel = new LocalChangesTableModel(this.changes, ws);
                        this.tblLocalChanges.setModel(this.localChangesTableModel);
                    }
                });
                dialog.show(WindowManager.MODE.DIALOG);
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)fs);
            }
        }
    }
}

