/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.changes;

import java.util.Objects;
import javax.swing.table.AbstractTableModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.vcsgis.lib.VCSGisChange;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryChange;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceChanges;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;

public class RemoteChangesTableModel
extends AbstractTableModel {
    private static final int COLUMN_SELECT = 0;
    private static final int COLUMN_TABLE = 1;
    private static final int COLUMN_OPERATION = 2;
    private static final int COLUMN_LABEL = 3;
    private static final int COLUMN_REVNUM = 4;
    private static final int COLUMN_DATE = 5;
    private static final int COLUMN_CODE = 6;
    private static final ColumnDescriptor[] COLUMNS = new ColumnDescriptor[]{new ColumnDescriptor(Boolean.class, "select", true), new ColumnDescriptor(String.class, "table", false), new ColumnDescriptor(String.class, "operation", false), new ColumnDescriptor(String.class, "label", false), new ColumnDescriptor(Long.class, "Rev.num.", false), new ColumnDescriptor(String.class, "Fecha", false), new ColumnDescriptor(String.class, "code", false)};
    private VCSGisWorkspaceChanges<VCSGisRepositoryChange> changes;
    private final VCSGisWorkspace ws;

    public RemoteChangesTableModel(VCSGisWorkspace ws) {
        this(null, ws);
    }

    public RemoteChangesTableModel(VCSGisWorkspaceChanges<VCSGisRepositoryChange> changes, VCSGisWorkspace ws) {
        this.ws = ws;
        this.changes = changes;
        if (changes != null) {
            this.changes.addChangeListener(e -> this.fireTableDataChanged());
        }
    }

    @Override
    public int getRowCount() {
        if (this.changes == null) {
            return 0;
        }
        try {
            return (int)this.changes.size64();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMNS[columnIndex].columnClass();
    }

    @Override
    public String getColumnName(int column) {
        return COLUMNS[column].label();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return COLUMNS[columnIndex].isEditable();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.changes == null) {
            return null;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        VCSGisRepositoryChange row = (VCSGisRepositoryChange)this.changes.get64((long)rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.isSelected();
            }
            case 1: {
                VCSGisEntity entity = this.ws.getEntity(row.getEntityCode());
                if (entity == null) {
                    return "unknown (" + row.getEntityCode() + ")";
                }
                return this.ws.getEntity(row.getEntityCode()).getEntityName();
            }
            case 2: {
                int op = row.getOperation();
                return i18n.getTranslation(VCSGisSwingCommons.getOperationLabel(op));
            }
            case 3: {
                return row.getLabel();
            }
            case 6: {
                return row.getRelatedFeatureCode();
            }
            case 4: {
                return row.getRevisionNumber();
            }
            case 5: {
                return Objects.toString(row.getEfectiveDate(), "");
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.changes == null) {
            return;
        }
        VCSGisChange row = (VCSGisChange)this.changes.get64((long)rowIndex);
        switch (columnIndex) {
            case 0: {
                Boolean selected = (Boolean)aValue;
                if (selected.booleanValue()) {
                    this.changes.addSelectionInterval((long)rowIndex, (long)rowIndex);
                    break;
                }
                this.changes.removeSelectionInterval((long)rowIndex, (long)rowIndex);
            }
        }
    }

    private static class ColumnDescriptor {
        private final Class<?> columnClass;
        private final String name;
        private final boolean editable;

        public ColumnDescriptor(Class<?> columnClass, String name, boolean editable) {
            this.name = name;
            this.columnClass = columnClass;
            this.editable = editable;
        }

        public Class<?> columnClass() {
            return this.columnClass;
        }

        public String name() {
            return this.name;
        }

        public String label() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            return i18n.getTranslation(this.name);
        }

        public boolean isEditable() {
            return this.editable;
        }
    }
}

