/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.checkout;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.fmap.mapcontrol.MapControlManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.DatePickerController;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.vcsgis.lib.UserCancelledException;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisRevision;
import org.gvsig.vcsgis.lib.VCSGisRuntimeException;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.swing.VCSGisEntitySelectorController;
import org.gvsig.vcsgis.swing.VCSGisJCheckout;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingManagerImpl;
import org.gvsig.vcsgis.swing.impl.checkout.VCSGisJCheckoutView;
import org.gvsig.vcsgis.swing.impl.revisions.VCSGisRevisionPickerControllerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisJCheckoutImpl
extends VCSGisJCheckoutView
implements Component,
VCSGisJCheckout {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisJCheckoutImpl.class);
    private static final int NUM_TABLAS_TO_SHOW_WARN = 20;
    private Dialog dialog;
    private boolean processing = false;
    private PickerController<VCSGisWorkspace> workspacePicker;
    private TaskStatusController taskStatusController;
    private VCSGisRevisionPickerControllerImpl revisionPicker;
    private VCSGisEntitySelectorController entitySelector;
    private DatePickerController efectivePicker;
    private PickerController<Envelope> extentPicker;
    private List<String> defaultTablesSelection;
    private boolean inDoUpdateComponents = false;

    public VCSGisJCheckoutImpl() {
        this(null, null, null);
    }

    public VCSGisJCheckoutImpl(VCSGisWorkspace workspace, List<String> tableNames, Boolean overwrite) {
        this.translate();
        this.defaultTablesSelection = tableNames == null ? Collections.EMPTY_LIST : tableNames;
        this.initComponents();
        SwingUtilities.invokeLater(() -> {
            this.workspacePicker.set((Object)workspace);
            if (overwrite != null) {
                this.chkOverwriteTable.setSelected(overwrite);
            }
        });
    }

    private void initComponents() {
        MapControlManager mapControlManager = MapControlLocator.getMapControlManager();
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        this.chkUseLabelInsteadName.setSelected(true);
        this.entitySelector = VCSGisSwingLocator.getVCSGisSwingManager().createEntitySelectorController(this.treeTables, (JTextComponent)this.txtFilter, this.btnTable);
        this.entitySelector.setFilter(VCSGisEntitySelectorController.REMOTE_ENTITIES);
        this.entitySelector.setViewFilter(VCSGisEntitySelectorController.REMOTE_ENTITIES);
        this.entitySelector.setChecksEnabled(true);
        this.entitySelector.addActionListener(e -> {
            switch (e.getID()) {
                case 2: {
                    this.doUpdateComponents();
                    break;
                }
                case 1: {
                    this.doChangeSelectedEntities();
                }
            }
        });
        this.entitySelector.addChangeListener(e -> this.doUpdateComponents());
        this.taskStatusController = taskStatusManager.createTaskStatusController(null, this.lblStatusTitle, this.lblStatusMessages, this.pbStatus, this.btnStatusCancel, null);
        this.taskStatusController.setShowCancelButton(false);
        this.taskStatusController.setShowRemoveTaskButton(false);
        SwingUtilities.invokeLater(() -> this.setVisibleStatus(false));
        this.workspacePicker = swingManager.createWorkspacePickerController(this.cboWorkspaces, this.btnInitWorkspace);
        this.workspacePicker.addChangeListener(e -> {
            this.clearMessage();
            this.doChangeWorkspace();
            this.doUpdateComponents();
        });
        this.rdblastRevision.addActionListener(e -> {
            this.clearMessage();
            this.doUpdateComponents();
        });
        this.rdbEffectiveDate.addActionListener(e -> {
            this.clearMessage();
            this.doUpdateComponents();
        });
        this.efectivePicker = toolsSwingManager.createDatePickerController((JTextComponent)this.txtEffectiveDate, this.btnEffectiveDate);
        this.efectivePicker.addChangeListener(e -> {
            this.clearMessage();
            this.doUpdateComponents();
        });
        this.chkCheckoutOnlyOneArea.addChangeListener(e -> {
            this.clearMessage();
            this.doUpdateComponents();
        });
        this.rdbRevision.addActionListener(e -> {
            this.clearMessage();
            this.doUpdateComponents();
        });
        this.revisionPicker = new VCSGisRevisionPickerControllerImpl(this.txtRevision, this.btnRevision);
        this.revisionPicker.addChangeListener(e -> {
            this.clearMessage();
            this.doUpdateComponents();
        });
        ComboBoxModel viewDocumentsModel = services.getViewDocumentsComboBoxModel();
        this.cboView.setModel(viewDocumentsModel);
        this.cboView.addActionListener(e -> {
            this.clearMessage();
            this.doUpdateComponents();
        });
        this.rdbDontAddToProject.addActionListener(e -> {
            this.clearMessage();
            this.doUpdateComponents();
        });
        this.rdbAddLayerToView.addActionListener(e -> {
            this.clearMessage();
            this.doUpdateComponents();
        });
        this.rdbAddTableToProject.addActionListener(e -> {
            this.clearMessage();
            this.doUpdateComponents();
        });
        this.chkOverwriteTable.addActionListener(e -> {
            this.clearMessage();
            this.doUpdateComponents();
        });
        this.btnCheckAll.addActionListener(e -> this.entitySelector.checkAll());
        this.btnUnCheckAll.addActionListener(e -> this.entitySelector.clearChecks());
        this.btnTablesCollapseAll.addActionListener(e -> this.entitySelector.collapseAll());
        this.btnTablesExpandAll.addActionListener(e -> this.entitySelector.expandAll());
        this.btnTablesSelectStoresInUse.addActionListener(e -> this.doSelectEntitiesInUse());
        this.rdbDontAddToProject.setSelected(true);
        this.chkReplaceLayerIfExists.setSelected(true);
        this.chkCheckoutOnlyOneArea.addActionListener(e -> this.extentPicker.setEnabled(this.chkCheckoutOnlyOneArea.isSelected()));
        LabeledValue mapControl = services.getActiveMapControl();
        this.txtViewName.setText(mapControl.getLabel());
        this.extentPicker = mapControlManager.createEnvelopePickerController((MapControl)mapControl.getValue(), (JTextComponent)this.txtExtent, this.btnExtentFromView, this.btnExtentCapture);
        this.extentPicker.addChangeListener(e -> {
            this.clearMessage();
            this.doUpdateComponents();
        });
        this.showMessage(" ", null);
        this.doUpdateComponents();
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)16, (int)60, (int)22, (int)100);
    }

    private void clearMessage() {
        this.showMessage(" ", null);
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setVisibleStatus(boolean visible) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.setVisibleStatus(visible))) {
            return;
        }
        this.lblStatusTitle.setVisible(visible);
        this.pbStatus.setVisible(visible);
        this.lblStatusMessages.setVisible(true);
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.doUpdateComponents();
    }

    private void doChangeWorkspace() {
        try {
            VCSGisWorkspace ws = this.getWorkspace();
            if (ws == null) {
                this.entitySelector.setWorkspace(ws);
                this.revisionPicker.setWorkspace(ws);
                return;
            }
            if (ws.isOffline() || ws.authenticate(null)) {
                this.entitySelector.setWorkspace(ws);
                this.revisionPicker.setWorkspace(ws);
                for (String tableName : this.defaultTablesSelection) {
                    VCSGisWorkspaceEntity entity = ws.getWorkspaceEntity(tableName);
                    if (entity == null) continue;
                    this.entitySelector.check((VCSGisEntity)entity);
                }
                return;
            }
            VCSGisSwingCommons.showAuthenticationRequiredMessage("_VCS_Checkout");
            this.workspacePicker.set(null);
            this.doChangeWorkspace();
        }
        catch (VCSGisRuntimeException e1) {
            LOGGER.warn("Can't set workspace.", (Throwable)e1);
            if (VCSGisSwingCommons.showAuthenticationErrors("_VCS_Checkout", e1)) {
                this.workspacePicker.set(null);
                this.doChangeWorkspace();
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Can't set workspace.", (Throwable)e2);
        }
    }

    public VCSGisWorkspace getWorkspace() {
        return (VCSGisWorkspace)this.workspacePicker.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateComponents() {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(this::doUpdateComponents)) {
            return;
        }
        if (this.inDoUpdateComponents) {
            return;
        }
        try {
            boolean canCheckout;
            this.inDoUpdateComponents = true;
            boolean isProcessing = this.processing || this.entitySelector.isProcessing();
            this.showMessage("");
            I18nManager i18n = ToolsLocator.getI18nManager();
            VCSGisWorkspace workspace = this.getWorkspace();
            List selectedTables = this.entitySelector.getCheckedEntities();
            boolean bl = canCheckout = !VCSGisLocator.getVCSGisManager().IsThereConflictingStoresInEdition();
            if (!canCheckout) {
                this.showMessage(i18n.getTranslation("_There_is_some_table_that_can_be_conflicting_in_editing_mode"));
            }
            boolean bl2 = canCheckout = canCheckout && !isProcessing && workspace != null;
            if (selectedTables.isEmpty()) {
                this.workspacePicker.setEnabled(!isProcessing);
                this.entitySelector.setEnabled(!isProcessing && workspace != null);
                this.btnCheckAll.setEnabled(this.entitySelector.isEnabled());
                this.btnUnCheckAll.setEnabled(this.entitySelector.isEnabled());
                this.rdbDontAddToProject.setEnabled(false);
                this.rdbAddTableToProject.setEnabled(false);
                this.rdbAddLayerToView.setEnabled(false);
                this.cboView.setEnabled(false);
                this.chkReplaceLayerIfExists.setEnabled(false);
                this.chkUseLabelInsteadName.setEnabled(false);
                this.rdbRevision.setEnabled(false);
                this.rdbEffectiveDate.setEnabled(false);
                this.rdblastRevision.setEnabled(false);
                this.revisionPicker.setEnabled(false);
                this.efectivePicker.setEnabled(false);
            } else if (selectedTables.size() == 1) {
                boolean exists = false;
                VCSGisEntity selectedTable = (VCSGisEntity)selectedTables.get(0);
                if (workspace != null) {
                    if (workspace.existsInWorkspace(selectedTable)) {
                        exists = true;
                    } else {
                        JDBCStoreParameters parameters;
                        JDBCServerExplorer explorer = workspace.getExplorer();
                        if (explorer.exists((DataStoreParameters)(parameters = explorer.get(selectedTable.getEntityName())))) {
                            exists = true;
                        }
                    }
                }
                this.chkOverwriteTable.setEnabled(!isProcessing && exists);
                boolean bl3 = canCheckout = selectedTable != null && (!exists || this.chkOverwriteTable.isSelected());
                if (selectedTable == null || canCheckout) {
                    this.showMessage("", null);
                } else {
                    this.showMessage(i18n.getTranslation("_The_selected_table_is_already_in_the_working_copy"), i18n.getTranslation("_To_download_updated_data_use_show_changes_tool"));
                }
                this.rdbRevision.setEnabled(canCheckout);
                this.rdbEffectiveDate.setEnabled(canCheckout);
                this.rdblastRevision.setEnabled(canCheckout);
                this.revisionPicker.setEnabled(canCheckout && this.rdbRevision.isSelected());
                this.efectivePicker.setEnabled(canCheckout && this.rdbEffectiveDate.isSelected());
                this.chkCheckoutOnlyOneArea.setEnabled(canCheckout && this.rdbEffectiveDate.isSelected());
                this.extentPicker.setEnabled(canCheckout && this.rdbEffectiveDate.isSelected());
                if (!this.rdbEffectiveDate.isSelected()) {
                    this.chkCheckoutOnlyOneArea.setSelected(false);
                    this.extentPicker.set(null);
                }
                this.rdbDontAddToProject.setEnabled(canCheckout);
                this.rdbAddTableToProject.setEnabled(canCheckout);
                if (canCheckout) {
                    if (this.isLayer(selectedTable)) {
                        this.rdbAddLayerToView.setEnabled(canCheckout);
                        this.cboView.setEnabled(canCheckout && this.rdbAddLayerToView.isSelected());
                        this.chkReplaceLayerIfExists.setEnabled(canCheckout && this.rdbAddLayerToView.isSelected());
                        this.chkUseLabelInsteadName.setEnabled(canCheckout && this.rdbAddLayerToView.isSelected());
                    } else {
                        this.rdbAddLayerToView.setEnabled(false);
                        this.cboView.setEnabled(false);
                        this.chkReplaceLayerIfExists.setEnabled(false);
                        this.chkUseLabelInsteadName.setEnabled(false);
                    }
                } else {
                    this.rdbAddLayerToView.setEnabled(false);
                    this.cboView.setEnabled(false);
                    this.chkReplaceLayerIfExists.setEnabled(false);
                    this.chkUseLabelInsteadName.setEnabled(false);
                }
                this.workspacePicker.setEnabled(!isProcessing);
                this.entitySelector.setEnabled(!isProcessing && workspace != null);
                this.btnCheckAll.setEnabled(this.entitySelector.isEnabled());
                this.btnUnCheckAll.setEnabled(this.entitySelector.isEnabled());
                this.chkCheckoutOnlyOneArea.setEnabled(this.rdbEffectiveDate.isSelected());
                this.extentPicker.setEnabled(this.chkCheckoutOnlyOneArea.isSelected());
                if (canCheckout && this.rdbEffectiveDate.isEnabled() && this.rdbEffectiveDate.isSelected() && this.chkCheckoutOnlyOneArea.isSelected() && this.extentPicker.isEmpty()) {
                    canCheckout = false;
                    this.showMessage(i18n.getTranslation("_Clipping_area_is_empty"), i18n.getTranslation("_Clipping_area_is_empty"));
                }
                if (canCheckout && this.rdbRevision.isSelected() && this.revisionPicker.get() == null) {
                    canCheckout = false;
                    this.showMessage(i18n.getTranslation("_Revision_not_selected"), i18n.getTranslation("_Revision_not_selected"));
                }
                if (this.dialog != null) {
                    LabeledValue selectedView = (LabeledValue)this.cboView.getSelectedItem();
                    boolean dontAddNothing = this.rdbDontAddToProject.isSelected();
                    boolean addLayerToView = this.rdbAddLayerToView.isSelected() && selectedView != null && selectedView.getValue() != null;
                    boolean addTableToProject = this.rdbAddTableToProject.isSelected();
                    boolean enableCheckout = canCheckout && (dontAddNothing || addLayerToView || addTableToProject);
                    this.dialog.setButtonEnabled(1, enableCheckout);
                }
            } else {
                this.rdbRevision.setEnabled(false);
                this.rdbEffectiveDate.setEnabled(canCheckout);
                this.rdblastRevision.setEnabled(canCheckout);
                this.revisionPicker.setEnabled(canCheckout && this.rdbRevision.isSelected());
                this.efectivePicker.setEnabled(canCheckout && this.rdbEffectiveDate.isSelected());
                this.chkCheckoutOnlyOneArea.setEnabled(canCheckout && this.rdbEffectiveDate.isSelected());
                this.extentPicker.setEnabled(canCheckout && this.rdbEffectiveDate.isSelected());
                if (!this.rdbEffectiveDate.isSelected()) {
                    this.chkCheckoutOnlyOneArea.setSelected(false);
                    this.extentPicker.set(null);
                }
                this.chkOverwriteTable.setEnabled(false);
                this.rdbDontAddToProject.setEnabled(canCheckout);
                this.rdbAddTableToProject.setEnabled(canCheckout);
                if (canCheckout) {
                    if (this.areAllCheckedLayers()) {
                        this.rdbAddLayerToView.setEnabled(canCheckout);
                        this.cboView.setEnabled(canCheckout && this.rdbAddLayerToView.isSelected());
                        this.chkReplaceLayerIfExists.setEnabled(canCheckout && this.rdbAddLayerToView.isSelected());
                        this.chkUseLabelInsteadName.setEnabled(canCheckout && this.rdbAddLayerToView.isSelected());
                    } else {
                        this.rdbAddLayerToView.setEnabled(false);
                        this.cboView.setEnabled(false);
                        this.chkReplaceLayerIfExists.setEnabled(false);
                        this.chkUseLabelInsteadName.setEnabled(false);
                    }
                } else {
                    this.rdbAddLayerToView.setEnabled(false);
                    this.cboView.setEnabled(false);
                    this.chkReplaceLayerIfExists.setEnabled(false);
                    this.chkUseLabelInsteadName.setEnabled(false);
                }
                this.workspacePicker.setEnabled(!isProcessing);
                this.entitySelector.setEnabled(!isProcessing && workspace != null);
                this.btnCheckAll.setEnabled(this.entitySelector.isEnabled());
                this.btnUnCheckAll.setEnabled(this.entitySelector.isEnabled());
                this.chkCheckoutOnlyOneArea.setEnabled(this.rdbEffectiveDate.isSelected());
                this.extentPicker.setEnabled(this.chkCheckoutOnlyOneArea.isSelected());
                if (canCheckout && this.rdbEffectiveDate.isEnabled() && this.rdbEffectiveDate.isSelected() && this.chkCheckoutOnlyOneArea.isSelected() && this.extentPicker.isEmpty()) {
                    canCheckout = false;
                    this.showMessage(i18n.getTranslation("_Clipping_area_is_empty"), i18n.getTranslation("_Clipping_area_is_empty"));
                }
                if (this.dialog != null) {
                    this.dialog.setButtonEnabled(1, canCheckout && selectedTables.size() > 1);
                }
            }
        }
        catch (VCSGisRuntimeException e1) {
            LOGGER.warn("Can't updating components.", (Throwable)e1);
            if (VCSGisSwingCommons.showAuthenticationErrors("_VCS_Checkout", e1)) {
                this.workspacePicker.set(null);
                this.doChangeWorkspace();
                this.doUpdateComponents();
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Can't updating components.", (Throwable)e2);
        }
        finally {
            this.inDoUpdateComponents = false;
        }
    }

    private boolean isLayer(VCSGisEntity entity) {
        return entity != null && !StringUtils.isBlank((CharSequence)entity.getGeometryFieldName());
    }

    private boolean areAllCheckedLayers() {
        List entities = this.entitySelector.getCheckedEntities();
        for (VCSGisEntity entity : entities) {
            if (entity == null || !StringUtils.isBlank((CharSequence)entity.getGeometryFieldName())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkout() {
        int n;
        int n2;
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        if (this.rdbEffectiveDate.isSelected() && !this.chkCheckoutOnlyOneArea.isSelected() && (n2 = dialogs.confirmDialog(i18n.getTranslation("_You_have_selected_to_get_the_data_to_an_effective_date_but_you_have_not_indicated_a_clipping_area_Do_you_want_to_continue_anyway"), i18n.getTranslation("_VCS_Checkout"), 0, 3)) == 1) {
            this.setVisibleStatus(false);
            return 17;
        }
        List entities = this.entitySelector.getCheckedEntities();
        if (entities.size() > 20 && (n = dialogs.confirmDialog(i18n.getTranslation("_Are_selected_XTablesX_Are_you_sure_to_continue", new String[]{String.valueOf(entities.size())}), i18n.getTranslation("_VCS_Checkout"), 0, 3)) == 1) {
            this.setVisibleStatus(false);
            return 17;
        }
        VCSGisWorkspace workspace = this.getWorkspace();
        boolean replaceLayerIfExists = this.chkReplaceLayerIfExists.isSelected();
        boolean useLabelInsteadName = this.chkUseLabelInsteadName.isSelected();
        Envelope bbox = null;
        if (this.chkCheckoutOnlyOneArea.isSelected()) {
            bbox = (Envelope)this.extentPicker.get();
        }
        VCSGisRevision revision = null;
        Timestamp efectiveDate = null;
        if (this.rdbRevision.isSelected()) {
            revision = this.revisionPicker.get();
            efectiveDate = null;
        }
        if (this.rdblastRevision.isSelected()) {
            revision = null;
            efectiveDate = null;
        }
        if (this.rdbEffectiveDate.isSelected()) {
            revision = null;
            Date d = (Date)this.efectivePicker.get();
            if (d != null) {
                int n3;
                Object now;
                efectiveDate = new Timestamp(d.getTime());
                LocalDateTime efectiveLocalDateTime = DataTypeUtils.toLocalDateTime((Date)d);
                if ((efectiveLocalDateTime.isAfter(((LocalDateTime)(now = LocalDateTime.now())).minusMonths(6L)) || efectiveLocalDateTime.isBefore(((LocalDateTime)now).plusDays(1L))) && (n3 = dialogs.confirmDialog(i18n.getTranslation("_You_have_indicated_{1}_as_the_effective_date", new String[]{efectiveLocalDateTime.toString()}) + "\n" + i18n.getTranslation("_Do_you_wish_to_continue_with_the_operation"), i18n.getTranslation("_VCS_Checkout"), 0, 3)) == 1) {
                    this.setVisibleStatus(false);
                    return 17;
                }
            }
        }
        if (workspace != null && !entities.isEmpty()) {
            SimpleTaskStatus taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Download changes");
            try {
                JDBCServerExplorerParameters explorerParams;
                taskStatus.setAutoremove(true);
                taskStatus.add();
                taskStatus.setRangeOfValues(0L, (long)entities.size());
                taskStatus.setCurValue(0L);
                this.taskStatusController.bind((TaskStatus)taskStatus);
                this.processing = true;
                this.doUpdateComponents();
                final ArrayList<String> resourcesEntityNames = new ArrayList<String>();
                for (VCSGisEntity entity : entities) {
                    String resourcesTable = entity.getResources();
                    if (!StringUtils.isNotBlank((CharSequence)resourcesTable)) continue;
                    resourcesEntityNames.add(resourcesTable);
                }
                if (CollectionUtils.isNotEmpty(resourcesEntityNames)) {
                    Collections.sort(entities, new Comparator<VCSGisEntity>(){

                        @Override
                        public int compare(VCSGisEntity o1, VCSGisEntity o2) {
                            if (o1 != null && resourcesEntityNames.contains(o1.getResources())) {
                                return -1;
                            }
                            if (o2 != null && resourcesEntityNames.contains(o2.getResources())) {
                                return 1;
                            }
                            return 0;
                        }
                    });
                }
                if ((explorerParams = workspace.getExplorerParameters()) != null && !StringUtils.equalsIgnoreCase((CharSequence)explorerParams.getProviderName(), (CharSequence)"H2Spatial")) {
                    for (VCSGisEntity entity : entities) {
                        taskStatus.setTitle("Checkout - " + entity.getLabel() + taskStatus.getProgressLabel());
                        this.showMessage(i18n.getTranslation("_Processing"), null);
                        if (!this.chkOverwriteTable.isSelected()) continue;
                        try {
                            FeatureStore store = workspace.openFeatureStore(entity.getEntityName(), true);
                            if (store == null) continue;
                            int n4 = dialogs.confirmDialog("Tables will be removed from the database.\nAny special settings that may have been configured (permissions, extra indexes, etc.) will be lost.\nDo you want to continue?", i18n.getTranslation("_VCS_Checkout"), 0, 3);
                            if (n4 == 1) {
                                this.setVisibleStatus(false);
                                int n5 = 17;
                                return n5;
                            }
                            break;
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Can't check if table '" + entity.getEntityName() + "' already exist.", (Throwable)ex);
                        }
                    }
                }
                int res = 0;
                for (VCSGisEntity entity : entities) {
                    taskStatus.setTitle("Checkout - " + entity.getLabel() + taskStatus.getProgressLabel());
                    this.showMessage(i18n.getTranslation("_Processing"), null);
                    if (this.chkOverwriteTable.isSelected()) {
                        res = workspace.removeEntity(entity);
                    }
                    if (res != 0 && res != 240) break;
                    try {
                        FeatureStore store = workspace.openFeatureStore(entity.getEntityName(), true);
                        if (store != null) {
                            workspace.getExplorer().remove(store.getParameters());
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't remove table '" + entity.getEntityName() + "'", (Throwable)ex);
                    }
                    res = workspace.checkout(entity.getEntityName(), revision == null ? null : revision.getRevisionCode(), efectiveDate, bbox, taskStatus);
                    taskStatus.incrementCurrentValue();
                    if (!taskStatus.isCancellationRequested()) continue;
                    break;
                }
                if (res == 0) {
                    this.postCheckout(workspace, res, entities, replaceLayerIfExists, useLabelInsteadName);
                }
                this.showMessage(i18n.getTranslation("_Ended_process"), null);
                if (taskStatus.isCancellationRequested()) {
                    taskStatus.cancel();
                } else {
                    taskStatus.terminate();
                }
                int n6 = res;
                return n6;
            }
            catch (UserCancelledException ex) {
                LOGGER.warn("User cancelled");
                taskStatus.cancel();
            }
            catch (Exception ex) {
                LOGGER.warn("Can't checkout", (Throwable)ex);
                taskStatus.abort();
            }
            finally {
                this.processing = false;
                this.doUpdateComponents();
            }
        }
        return 600;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postCheckout(VCSGisWorkspace workspace, int checkoutStatus, List<VCSGisEntity> entities, boolean replaceLayerIfExists, boolean useLabelInsteadName) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.postCheckout(workspace, checkoutStatus, entities, replaceLayerIfExists, useLabelInsteadName))) {
            return;
        }
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        TaskStatus taskStatus = this.taskStatusController.getTaskStatus();
        if (!taskStatus.isCancellationRequested() && checkoutStatus == 0) {
            FeatureStore store = null;
            for (VCSGisEntity entity : entities) {
                block10: {
                    try {
                        store = workspace.openFeatureStore(entity.getEntityName(), false);
                        if (!this.rdbDontAddToProject.isSelected()) {
                            if (this.rdbAddLayerToView.isSelected() && this.isLayer(entity)) {
                                String layerName = store.getName();
                                if (useLabelInsteadName) {
                                    layerName = entity.getLabelOrName();
                                }
                                String groupName = entity.getFirstCategory();
                                services.addLayerToView(store, (LabeledValue)this.cboView.getSelectedItem(), groupName, layerName, replaceLayerIfExists);
                            }
                            if (this.rdbAddTableToProject.isSelected()) {
                                services.addTableToProject(workspace, store);
                            }
                        }
                        if (!this.chkOverwriteTable.isSelected()) break block10;
                        VCSGisSwingCommons.refreshDocument(store);
                    }
                    catch (Throwable throwable) {
                        DisposeUtils.disposeQuietly(store);
                        throw throwable;
                    }
                }
                DisposeUtils.disposeQuietly((Disposable)store);
            }
            this.entitySelector.clearChecks();
            this.setVisibleStatus(false);
        } else {
            this.setVisibleStatus(true);
        }
        this.entitySelector.reloadEntities();
        this.doUpdateComponents();
    }

    private void showMessage(String message) {
        this.showMessage(message, null);
    }

    private void showMessage(String message, String toolTipText) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.showMessage(message, toolTipText))) {
            return;
        }
        this.lblStatusMessages.setText(message);
        this.lblStatusMessages.setToolTipText(toolTipText);
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.lblWorkspace);
        swingManager.translate(this.tabCheckout);
        swingManager.translate((AbstractButton)this.rdblastRevision);
        swingManager.translate((AbstractButton)this.rdbEffectiveDate);
        swingManager.translate((AbstractButton)this.rdbRevision);
        swingManager.translate((AbstractButton)this.chkCheckoutOnlyOneArea);
        swingManager.translate((AbstractButton)this.rdbDontAddToProject);
        swingManager.translate((AbstractButton)this.rdbAddLayerToView);
        swingManager.translate((AbstractButton)this.rdbAddTableToProject);
        swingManager.translate((AbstractButton)this.chkOverwriteTable);
        swingManager.translate((AbstractButton)this.btnCheckAll);
        swingManager.translate((AbstractButton)this.btnUnCheckAll);
        swingManager.translate((AbstractButton)this.chkReplaceLayerIfExists);
        swingManager.translate((AbstractButton)this.chkUseLabelInsteadName);
        swingManager.translate((AbstractButton)this.btnTablesCollapseAll);
        swingManager.translate((AbstractButton)this.btnTablesExpandAll);
        swingManager.translate((AbstractButton)this.btnTablesSelectStoresInUse);
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public static void selfRegister() {
        String[][] iconsInfo = new String[][]{{"VCSGis", "vcsgis", "vcsgis-common-checkout"}};
        VCSGisSwingManagerImpl.registerIcons(iconsInfo);
    }

    private void doChangeSelectedEntities() {
        VCSGisWorkspace workspace = this.getWorkspace();
        List selectedTables = this.entitySelector.getCheckedEntities();
        if (selectedTables.size() == 1) {
            VCSGisEntity selectedTable = (VCSGisEntity)selectedTables.get(0);
            boolean isLayer = this.isLayer(selectedTable);
            this.rdbAddLayerToView.setSelected(isLayer && !this.rdbDontAddToProject.isSelected());
            this.rdbAddTableToProject.setSelected(!isLayer && !this.rdbDontAddToProject.isSelected());
            if (isLayer) {
                if (this.cboView.getModel().getSize() > 0) {
                    this.cboView.setEnabled(true);
                    if (this.cboView.getModel().getSize() == 2) {
                        this.cboView.setSelectedIndex(1);
                    } else {
                        this.cboView.setSelectedIndex(0);
                    }
                } else {
                    this.cboView.setEnabled(false);
                }
            }
            this.revisionPicker.setEntity(selectedTable);
            this.chkOverwriteTable.setSelected(workspace != null && workspace.existsInWorkspace(selectedTable));
        } else if (selectedTables.size() > 1) {
            this.revisionPicker.set(null);
            this.chkOverwriteTable.setSelected(true);
        }
        this.doUpdateComponents();
    }

    public VCSGisEntity getTable() {
        return this.entitySelector.getSelectedEntity();
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return VCSGisSwingManagerImpl.loadImage(imageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSelectEntitiesInUse() {
        VCSGisSwingManager vcsgisManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices appServices = vcsgisManager.getDefaultServices();
        List stores = null;
        try {
            stores = appServices.getFeatureStores();
            this.entitySelector.clearChecks();
            VCSGisWorkspace ws = this.getWorkspace();
            for (FeatureStore store : stores) {
                String storeName = "unknown";
                try {
                    VCSGisEntity entity;
                    storeName = store.getName();
                    if (!StringUtils.isNotBlank((CharSequence)storeName) || (entity = ws.getEntity(storeName)) == null) continue;
                    this.entitySelector.check(entity);
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't select entity '" + storeName + "'.", (Throwable)ex);
                }
            }
        }
        finally {
            DisposeUtils.disposeQuietly((Object)stores);
        }
    }
}

