/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.managehistory;

import java.io.File;
import java.util.concurrent.Callable;
import javax.json.JsonObject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.json.Json;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreHistory
implements Callable<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreHistory.class);
    private static final String DATA_OPERATION = "DAT_OPERATION";
    private static final String DATA_FEATURERELATEDCODE = "DAT_FEATURERELATEDCODE";
    private static final String DATA_GEOM = "DAT_GEOM";
    private static final String DATA_DATA = "DAT_DATA";
    private final JDBCServerExplorerParameters repository;
    private final File sourceEntityFile;
    private SimpleTaskStatus status;
    private boolean checkOnly;
    private final GeometryManager geometryManager;

    public RestoreHistory(JDBCServerExplorerParameters repository, File sourceEntityFile, SimpleTaskStatus status) {
        this.repository = repository;
        this.sourceEntityFile = sourceEntityFile;
        this.status = status;
        this.geometryManager = GeometryLocator.getGeometryManager();
    }

    public RestoreHistory(File sourceEntityFile, SimpleTaskStatus status) {
        this(null, sourceEntityFile, status);
    }

    public void setCheckOnly(boolean onlycheck) {
        this.checkOnly = onlycheck;
    }

    public boolean isCheckOnly() {
        return this.checkOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Integer call() {
        Integer n;
        DataTransaction trans;
        long t1;
        block29: {
            Integer n2;
            if (this.status == null) {
                this.status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Restore");
                this.status.setAutoremove(true);
                this.status.add();
            } else {
                this.status.push();
            }
            DataManager dataManager = DALLocator.getDataManager();
            t1 = System.currentTimeMillis();
            trans = null;
            int line = -1;
            String featureReletadCode = "(unknown)";
            try {
                FeatureStore targetDataStore;
                FeatureStore sourceDataStore;
                String defaultGeometryAttributeName;
                long firstRevisionNumber;
                block30: {
                    block28: {
                        LOGGER.info("Restore history started (" + FilenameUtils.getBaseName((String)this.sourceEntityFile.getName()) + ").");
                        trans = dataManager.createTransaction();
                        trans.begin();
                        this.status.message("Opening repository");
                        JDBCServerExplorer targetExplorer = null;
                        if (!this.checkOnly) {
                            targetExplorer = (JDBCServerExplorer)dataManager.openServerExplorer(this.repository.getExplorerName(), (DataServerExplorerParameters)this.repository);
                            trans.add((DataServerExplorer)targetExplorer);
                        }
                        this.status.message("Calculating first revision number");
                        firstRevisionNumber = 0L;
                        JDBCStoreParameters targetOpenParameters = null;
                        if (!this.checkOnly) {
                            firstRevisionNumber = this.calculateRevisionNumber(trans, targetExplorer);
                            targetOpenParameters = targetExplorer.getOpenParameters();
                        }
                        File parentFolder = this.sourceEntityFile.getParentFile();
                        this.status.message("Opening " + this.sourceEntityFile.getName());
                        FeatureStore sourceEntitiesStore = (FeatureStore)dataManager.openStore("CSV", new Object[]{"file=", this.sourceEntityFile, "automaticTypesDetection=", false, "locale=", "en"});
                        trans.add((DataStore)sourceEntitiesStore);
                        Feature firstFeature = sourceEntitiesStore.first();
                        String entityName = firstFeature.getString("ENT_NAME");
                        JsonObject featureTypeJson = this.checkJson(firstFeature.getString("ENT_FEATURETYPE"), 1, sourceEntitiesStore.getFullName());
                        this.checkJson(firstFeature.getString("ENT_AUTORIZATIONS"), 1, sourceEntitiesStore.getFullName());
                        defaultGeometryAttributeName = null;
                        if (featureTypeJson != null) {
                            defaultGeometryAttributeName = featureTypeJson.getString("defaultGeometryAttributeName", null);
                        }
                        File sourceRevisionsFile = new File(FilenameUtils.concat((String)parentFolder.getAbsolutePath(), (String)("REVISIONS_" + entityName + ".csv")));
                        this.status.message("Opening " + sourceRevisionsFile.getName());
                        FeatureStore sourceRevisionsStore = (FeatureStore)dataManager.openStore("CSV", new Object[]{"file=", sourceRevisionsFile, "automaticTypesDetection=", false, "locale=", "en"});
                        trans.add((DataStore)sourceRevisionsStore);
                        File sourceDataFile = new File(FilenameUtils.concat((String)parentFolder.getAbsolutePath(), (String)("DATA_" + entityName + ".csv")));
                        this.status.message("Opening " + sourceDataFile.getName());
                        sourceDataStore = (FeatureStore)dataManager.openStore("CSV", new Object[]{"file=", sourceDataFile, "automaticTypesDetection=", false, "locale=", "en"});
                        trans.add((DataStore)sourceDataStore);
                        this.status.message("Updating repository entities table");
                        if (!this.checkOnly) {
                            targetOpenParameters.setTable("VCSGISREPO_ENTITIES");
                            FeatureStore targetEntitiesStore = (FeatureStore)targetExplorer.open((DataStoreParameters)targetOpenParameters);
                            trans.add((DataStore)targetEntitiesStore);
                            targetEntitiesStore.edit(2);
                            EditableFeature f = targetEntitiesStore.createNewFeature();
                            f.copyFrom(firstFeature);
                            targetEntitiesStore.insert(f);
                        }
                        FeatureSet revisionFeatures = sourceRevisionsStore.getFeatureSet();
                        trans.add((Disposable)revisionFeatures);
                        this.status.message("Updating repository revisions table");
                        this.status.setRangeOfValues(0L, revisionFeatures.size64());
                        FeatureStore targetRevisionsStore = null;
                        if (!this.checkOnly) {
                            targetOpenParameters.setTable("VCSGISREPO_REVISIONS");
                            targetRevisionsStore = (FeatureStore)targetExplorer.open((DataStoreParameters)targetOpenParameters);
                            trans.add((DataStore)targetRevisionsStore);
                            targetRevisionsStore.edit(2);
                        }
                        this.status.setCurValue(0L);
                        for (Feature feature : revisionFeatures) {
                            if (!this.status.isCancellationRequested()) {
                                if (!this.checkOnly) {
                                    EditableFeature f = targetRevisionsStore.createNewFeature();
                                    f.copyFrom(feature);
                                    f.set("REV_NUMBER", (Object)(f.getLong("REV_NUMBER") + firstRevisionNumber));
                                    targetRevisionsStore.insert(f);
                                }
                                this.status.incrementCurrentValue();
                                continue;
                            }
                            break block28;
                        }
                        FeatureSet dataFeatures = sourceDataStore.getFeatureSet();
                        trans.add((Disposable)dataFeatures);
                        this.status.message("Updating repository data table");
                        this.status.setRangeOfValues(0L, dataFeatures.size64());
                        targetDataStore = null;
                        if (!this.checkOnly) {
                            targetOpenParameters.setTable("VCSGISREPO_DATA");
                            targetDataStore = (FeatureStore)targetExplorer.open((DataStoreParameters)targetOpenParameters);
                            trans.add((DataStore)targetDataStore);
                            targetDataStore.edit(2);
                        }
                        this.status.setCurValue(0L);
                        line = 1;
                        n2 = dataFeatures.iterator();
                        break block30;
                    }
                    this.status.cancel();
                    DataTransaction.rollbackQuietly((DataTransaction)trans);
                    n2 = 17;
                    DisposeUtils.disposeQuietly((Disposable)trans);
                    LOGGER.info("Restore history finished (" + FilenameUtils.getBaseName((String)this.sourceEntityFile.getName()) + ", " + (System.currentTimeMillis() - t1) + " ms).");
                    this.status.pop();
                    return n2;
                }
                while (n2.hasNext()) {
                    Feature feature = (Feature)n2.next();
                    if (this.status.isCancellationRequested()) {
                        this.status.cancel();
                        DataTransaction.rollbackQuietly((DataTransaction)trans);
                        n = 17;
                        break block29;
                    }
                    featureReletadCode = feature.getString(DATA_FEATURERELATEDCODE);
                    Geometry box2d_from_geometry = null;
                    String data = feature.getString(DATA_DATA);
                    JsonObject json = this.checkJson(data, line, sourceDataStore.getFullName());
                    if (json == null) {
                        int operation = feature.getInt(DATA_OPERATION);
                        if (operation != 0) {
                            if (StringUtils.isBlank((CharSequence)data)) {
                                throw new RuntimeException("The json data is blank.");
                            }
                            throw new RuntimeException("The json data is wrong (" + StringUtils.replace((String)data, (String)"\n", (String)" ") + ").");
                        }
                    } else if (defaultGeometryAttributeName != null) {
                        box2d_from_geometry = this.getBox2DAndCheckGeometry(json.getString(defaultGeometryAttributeName, null), line, sourceDataStore.getFullName());
                    }
                    if (!this.checkOnly) {
                        EditableFeature f = targetDataStore.createNewFeature();
                        f.copyFrom(feature);
                        f.set("DAT_REVNUMBER", (Object)(f.getLong("DAT_REVNUMBER") + firstRevisionNumber));
                        Geometry csv_box2d = f.getDefaultGeometry();
                        if (csv_box2d == null && box2d_from_geometry != null) {
                            f.setDefaultGeometry(box2d_from_geometry);
                        }
                        targetDataStore.insert(f);
                    }
                    this.status.incrementCurrentValue();
                    ++line;
                }
                trans.commit();
                this.status.terminate();
                LOGGER.info("Restore history finishing (" + FilenameUtils.getBaseName((String)this.sourceEntityFile.getName()) + ", " + (System.currentTimeMillis() - t1) + " ms).");
                n2 = 0;
            }
            catch (Exception ex) {
                Integer n3;
                try {
                    if (line > -1) {
                        LOGGER.warn("Can't restore backup " + FilenameUtils.getBaseName((String)this.sourceEntityFile.getName()) + ". Problems in line " + line + ", " + DATA_FEATURERELATEDCODE + "=" + featureReletadCode + ".", (Throwable)ex);
                    } else {
                        LOGGER.warn("Can't restore backup " + FilenameUtils.getBaseName((String)this.sourceEntityFile.getName()) + ".", (Throwable)ex);
                    }
                    DataTransaction.rollbackQuietly((DataTransaction)trans);
                    this.status.abort();
                    n3 = 25;
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(trans);
                    LOGGER.info("Restore history finished (" + FilenameUtils.getBaseName((String)this.sourceEntityFile.getName()) + ", " + (System.currentTimeMillis() - t1) + " ms).");
                    this.status.pop();
                    throw throwable;
                }
                DisposeUtils.disposeQuietly((Disposable)trans);
                LOGGER.info("Restore history finished (" + FilenameUtils.getBaseName((String)this.sourceEntityFile.getName()) + ", " + (System.currentTimeMillis() - t1) + " ms).");
                this.status.pop();
                return n3;
            }
            DisposeUtils.disposeQuietly((Disposable)trans);
            LOGGER.info("Restore history finished (" + FilenameUtils.getBaseName((String)this.sourceEntityFile.getName()) + ", " + (System.currentTimeMillis() - t1) + " ms).");
            this.status.pop();
            return n2;
        }
        DisposeUtils.disposeQuietly((Disposable)trans);
        LOGGER.info("Restore history finished (" + FilenameUtils.getBaseName((String)this.sourceEntityFile.getName()) + ", " + (System.currentTimeMillis() - t1) + " ms).");
        this.status.pop();
        return n;
    }

    private long calculateRevisionNumber(DataTransaction trans, JDBCServerExplorer targetExplorer) throws DataException {
        if (this.checkOnly) {
            return 0L;
        }
        String TABLE_NAME = "VCSGISREPO_REVISIONS";
        String REVISION_NUMBER = "REV_NUMBER";
        JDBCStoreParameters targetOpenParameters = targetExplorer.getOpenParameters();
        targetOpenParameters.setTable("VCSGISREPO_REVISIONS");
        FeatureStore store = (FeatureStore)targetExplorer.open((DataStoreParameters)targetOpenParameters);
        trans.add((DataStore)store);
        FeatureSet fset = store.getFeatureSet();
        trans.add((Disposable)fset);
        if (fset.isEmpty()) {
            return 0L;
        }
        FeatureQuery query = store.createFeatureQuery();
        query.addAggregate("MAX", "REV_NUMBER");
        Feature f = store.findFirst(query);
        if (f == null) {
            return 0L;
        }
        return f.getInt("REV_NUMBER") + 1;
    }

    private JsonObject checkJson(String data, int line, String source) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return null;
        }
        JsonObject x = null;
        try {
            x = Json.createObject((String)data);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't parse json at line " + line + ", file " + source + ", data:\n" + data, (Throwable)ex);
            throw new RuntimeException("DAT_DATA incorrect value at line " + line + " file " + source, ex);
        }
        if (x == null) {
            x = Json.createObject((String)data);
            LOGGER.warn("Can't parse json at line " + line + ", file " + source + ", data:\n" + data);
            throw new RuntimeException("DAT_DATA incorrect value at line " + line + " file " + source);
        }
        return x;
    }

    private Geometry getBox2DAndCheckGeometry(String hexwkb, int line, String source) {
        if (StringUtils.isBlank((CharSequence)hexwkb)) {
            LOGGER.warn("Geometry is blank at line " + line + ", file " + source + ". ");
            return null;
        }
        Geometry geom = null;
        try {
            geom = this.geometryManager.createFrom(hexwkb);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't parse geometry from hexwkb at line " + line + ", file " + source + ". ", (Throwable)ex);
            return null;
        }
        if (geom == null) {
            LOGGER.warn("Can't parse geometry from hexwkb at line " + line + ", file " + source + ".");
            return null;
        }
        try {
            Geometry.ValidationStatus st = geom.getValidationStatus();
            if (!st.isValid()) {
                LOGGER.warn("Invalid geometry at line " + line + ", file " + source + ". " + st.getMessage() + " (code=" + st.getStatusCode() + ")");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't validate geometry from hexwkb at line " + line + ", file " + source + ". ", (Throwable)ex);
            return null;
        }
        try {
            Geometry box2d = geom.getEnvelope().getBox2D();
            return box2d;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get BOX2D of geometry from hexwkb at line " + line + ", file " + source + ". ", (Throwable)ex);
            return null;
        }
    }
}

