/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.revisions;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisRevision;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.impl.revisions.VCSGisJRevisionsDialog;

public class VCSGisRevisionPickerControllerImpl
extends AbstractPickerController<VCSGisRevision> {
    private final JTextField text;
    private final JButton button;
    private VCSGisRevision revision = null;
    private VCSGisWorkspace workspace;
    private VCSGisEntity entity;

    public VCSGisRevisionPickerControllerImpl(JTextField text, JButton button) {
        this.text = text;
        this.button = button;
        this.initText(this.text, e -> this.set(null));
        this.initButton(this.button, "vcsgis-revisions", e -> this.doSelectRevision());
    }

    private void doSelectRevision() {
        if (this.workspace == null || this.entity == null) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        VCSGisJRevisionsDialog panel = new VCSGisJRevisionsDialog(this.workspace, this.entity);
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = winManager.createDialog((JComponent)panel, i18n.getTranslation("_Select_revision"), null, 3);
        dialog.addActionListener(e -> {
            if (e.getID() == 1) {
                this.set(panel.getSelectedRevision());
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    public VCSGisRevision get() {
        return this.revision;
    }

    public void set(VCSGisRevision value) {
        this.revision = value;
        if (this.revision == null) {
            this.text.setText("");
        } else {
            this.text.setText(this.revision.getLabel());
        }
        this.fireChangeEvent();
    }

    public void coerceAndSet(Object value) {
        this.set((VCSGisRevision)value);
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.button.isEnabled();
    }

    public void setEntity(VCSGisEntity entity) {
        this.entity = entity;
        this.set(null);
    }

    public void setWorkspace(VCSGisWorkspace workspace) {
        this.workspace = workspace;
        this.setEntity(null);
    }
}

