# encoding: utf-8

import gvsig
import validate_layer

from gvsig import getResource, currentLayer

from java.io import File
from org.gvsig.andami import PluginsLocator
from org.gvsig.app import ApplicationLocator
from org.gvsig.scripting.app.extension import ScriptingExtension
from org.gvsig.tools import ToolsLocator
from org.gvsig.tools.swing.api import ToolsSwingLocator

class ValidateLayerExtension(ScriptingExtension):
  def __init__(self):
    pass

  def canQueryByAction(self):
    return True

  def isEnabled(self,action):
    return True

  def isVisible(self,action):
    layer = currentLayer()
    return layer != None
    
  def execute(self,actionCommand, *args):
    actionCommand = actionCommand.lower()
    if actionCommand == "layer-validate":
      validate_layer.main()
      
def selfRegister():
  application = ApplicationLocator.getManager()

  #
  # Registramos las traducciones
  i18n = ToolsLocator.getI18nManager()
  i18n.addResourceFamily("text",File(getResource(__file__,"i18n")))

  #
  # Registramos los iconos en el tema de iconos
  icon = File(getResource(__file__,"images","layer-validate.png")).toURI().toURL()
  iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent()
  #iconTheme.registerDefault("scripting.ValidateLayerExtension", "action", "layer-validate", None, icon)

  #
  # Creamos la accion 
  extension = ValidateLayerExtension()
  actionManager = PluginsLocator.getActionInfoManager()
  action = actionManager.createAction(
    extension, 
    "layer-validate", # Action name
    u"_Validate_geometries", # Text
    "layer-validate", # Action command
    "layer-validate", # Icon name
    None, # Accelerator
    650700601, # Position 
    u"_Validate_geometries" # Tooltip
  )
  action = actionManager.registerAction(action)
  #application.addMenu(action, u"Layer/_Validate_geometries")
      
def main(*args):
   selfRegister()