#!/bin/sh
#
# gvSIG. Desktop Geographic Information System.
#
# Copyright (C) 2007-2013 gvSIG Association.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA  02110-1301, USA.
#
# For any additional information, do not hesitate to contact us
# at info AT gvsig.com, or visit our website www.gvsig.com.
#


#
# Plugin autorun
#

PLUGIN_NAME=$(basename "$PLUGIN_FOLDER")

# https://redmine.gvsig.net/redmine/issues/3975
jythonjar=$(echo "$PLUGIN_FOLDER/lib/"*jython*.jar)
add_property python.home "$jythonjar"

add_property python.cachedir "$GVSIG_HOME_FOLDER/plugins/$PLUGIN_NAME/python.cachedir"

xmkdir -p "$GVSIG_HOME_FOLDER/plugins/$PLUGIN_NAME/scripts"
cd "$GVSIG_HOME_FOLDER/plugins/$PLUGIN_NAME/scripts"

#
# El find casca en win10 64 bits. Parece que hay algun problema con los
# pipes y el find y el ls.
if [ "${OS}" != "win" ] ; then
  sc_autoruns=$(find . -name autorun.sh)
  cd "$GVSIG_INSTALL_FOLDER"
  for sc_autorun in $sc_autoruns
  do
    sc_autorun="$GVSIG_HOME_FOLDER/plugins/$PLUGIN_NAME/scripts/$sc_autorun"
    if [ -r "$sc_autorun" ] ; then
      logger_info "Running scripting autorun from $sc_autorun"
      . "$sc_autorun"
      cd "$GVSIG_INSTALL_FOLDER"
    fi
  done
fi