 
package scripting.dal;


import org.gvsig.fmap.geom.Geometry;


public interface Feature extends org.gvsig.fmap.dal.feature.Feature { 

  /**
   * Gets the value of the default attribute to store the geometry. 
   *
   */
  public Geometry geometry() ;


  /**
   * Create and return a dict and fill it with the name/values of the attributes.
   *
   */
  public dict getValues() ;
  
  /**
   * Enable the edit mode in this feature.
   *
   * @deprecated can't use this method, is not jet implemented. Use getEditable instead.
   */
  public void edit() ;
  
  /**
   * Gets the value of the attribute name of the feature. 
   *
   * This method allow to treat a Feature as a dict.
   *
   * @param name of the atttribute to get
   *
   */
  public void __getitem__(String name) ;

  /**
   * Returns the java object associated to this python object. 
   * With the current implementation this is not necessary, don't
   * use now python wrappers for java objects.
   *
   * @deprecated this method now return self alwais.
   *
   */
  public void __call__() ;


  /**
   * Gets the number of attributes of the feature. 
   *
   * This method allow to use "len(feature)"
   *
   */
  public void __len__() ;

  /**
   * Allow to iterate ower the name/values of the attributes of the feature. 
   *
   */
  public Generator iteritems() ;

  /**
   * Allow to iterate ower the values of the attributes of the feature. 
   *
   */
  public Generator itervalues() ;

  /**
   * Allow to iterate ower the names of the attributes of the feature. 
   *
   */
  public Generator iterkeys() ;
  
}