# encoding: utf-8

from gvsig.commonsdialog import msgbox

from org.gvsig.app import ApplicationLocator
from org.gvsig.andami import PluginsLocator
from org.gvsig.app.project.documents.view import ViewManager
from org.gvsig.scripting.app.extension import ScriptingExtension

def main():
  application = ApplicationLocator.getManager()

  # Creamos la accion si no existe ya
  actionManager = PluginsLocator.getActionInfoManager()
  action = actionManager.createAction(ScriptingExtension, "tools-hello", "Hello", "hello", "tools-scripting-launcher", None, 1009000000, "Hello world")
  action = actionManager.registerAction(action)  

  # Y con ella damos de alta una accion en el TOC
  projectManager = ApplicationLocator.getProjectManager()  
  viewManager = projectManager.getDocumentManager(ViewManager.TYPENAME)
  viewManager.addTOCContextAction("tools-hello")

  msgbox("Insertada la entrada 'Hello' al TOC de la vista.")
    
