# encoding: utf-8

from gvsig import *

from org.gvsig.fmap import IconThemeHelper
from org.gvsig.fmap.mapcontrol.tools.Listeners import PointListener
from org.gvsig.fmap.mapcontrol.tools.Behavior import PointBehavior
from org.gvsig.app.project.documents.view import ViewManager

from gvsig.libs.formpanel import FormPanel

class Coordenadas(FormPanel, PointListener):
  def __init__(self, viewdoc):
    FormPanel.__init__(self, script.getResource("coordenadas.xml"))
    self.viewdoc = viewdoc
    self.mapControl = self.viewdoc.getWindowOfView().getMapControl()
    self.mapControl.addBehavior("TestGetXYPointTool", PointBehavior(self))
    self.mapControl.setTool("TestGetXYPointTool")

  def getWindowOfView(self, viewdoc):
    application = ApplicationLocator.getManager()
    projectManager = application.getProjectManager()
    viewManager = projectManager.getDocumentManager(ViewManager.TYPENAME)
    return viewManager.getMainWindow(self.viewdoc,None)
  
  def btnCerrar_click(self,*args):
    self.hide()
    
  def point(self, event):
    """Evento de PointListener"""
    p = event.getMapPoint()
    self.txtX.setText(str(p.getX()))
    self.txtY.setText(str(p.getY()))

  def pointDoubleClick(self, event):
    """Evento de PointListener"""
    p = event.getMapPoint()
    self.txtX.setText(str(p.getX()))
    self.txtY.setText(str(p.getY()))

  def getImageCursor(self):
    """Evento de PointListener"""
    return IconThemeHelper.getImage("cursor-select-by-point")

  def cancelDrawing(self):
    """Evento de PointListener"""
    return False

def main(*args):
  coordenadas = Coordenadas(currentView())
  coordenadas.showTool("Coordenda")
