from gvsig import commonsdialog

def main():
    '''Asks if you want to see a message and shows a message with selected 
    option using commonsdialog functions
        - msgbox
        - confirmDialog
    '''
    message = 'Do you want see a message?'
    title = 'Select Option'
    optionType = commonsdialog.YES_NO
    messageType = commonsdialog.IDEA
    
    option = commonsdialog.confirmDialog(
        message, 
        title, 
        optionType, 
        messageType
    )
    
    if option == 0:
        message = 'You have chosen "Yes" Option (%s)'%option           
    elif option == 1:
        message = 'No matter. You have chosen "No" Option (%s)'%option   
        messageType = commonsdialog.WARNING
    else:
        message = 'You just closed the window. Option (%s)'%option   
        messageType = commonsdialog.FORBIDEN
    
    commonsdialog.msgbox(message,
        'YOUR OPTION',
        messageType
    )