
@begin create_rtree_table
@param table_name
@param geom_name
CREATE VIRTUAL TABLE "rtree_%table_name$s_%geom_name$s" USING rtree(id, minx, maxx, miny, maxy)
@end create_rtree_table

@begin create_trigger_rtree_delete
@param table_name
@param geom_name
@param id_name
CREATE TRIGGER "rtree_%table_name$s_%geom_name$s_delete" AFTER DELETE ON "%table_name$s"
  WHEN old."%geom_name$s" NOT NULL
BEGIN
  DELETE FROM "rtree_%table_name$s_%geom_name$s" WHERE ID = OLD."%id_name$s";
END
@end create_trigger_rtree_delete

@begin create_trigger_rtree_insert
@param table_name
@param geom_name
@param id_name
CREATE TRIGGER "rtree_%table_name$s_%geom_name$s_insert" AFTER INSERT ON "%table_name$s"
  WHEN (new."%geom_name$s" NOT NULL AND NOT ST_IsEmpty(NEW."%geom_name$s"))
BEGIN
  INSERT OR REPLACE INTO "rtree_%table_name$s_%geom_name$s" VALUES (
    NEW."%id_name$s",
    ST_MinX(NEW."%geom_name$s"), ST_MaxX(NEW."%geom_name$s"),
    ST_MinY(NEW."%geom_name$s"), ST_MaxY(NEW."%geom_name$s")
  );
END
@end create_trigger_rtree_insert

@begin create_trigger_rtree_update1
@param table_name
@param geom_name
@param id_name
CREATE TRIGGER "rtree_%table_name$s_%geom_name$s_update1" AFTER UPDATE OF "%geom_name$s" ON "%table_name$s"
  WHEN OLD."%id_name$s" = NEW."%id_name$s" AND
       (NEW."%geom_name$s" NOTNULL AND NOT ST_IsEmpty(NEW."%geom_name$s"))
BEGIN
  INSERT OR REPLACE INTO "rtree_%table_name$s_%geom_name$s" VALUES (
    NEW."%id_name$s",
    ST_MinX(NEW."%geom_name$s"), ST_MaxX(NEW."%geom_name$s"),
    ST_MinY(NEW."%geom_name$s"), ST_MaxY(NEW."%geom_name$s")
  );
END
@end create_trigger_rtree_update1


@begin create_trigger_rtree_update2
@param table_name
@param geom_name
@param id_name
CREATE TRIGGER "rtree_%table_name$s_%geom_name$s_update2" AFTER UPDATE OF "%geom_name$s" ON "%table_name$s"
  WHEN OLD."%id_name$s" = NEW."%id_name$s" AND
       (NEW."%geom_name$s" ISNULL OR ST_IsEmpty(NEW."%geom_name$s"))
BEGIN
  DELETE FROM "rtree_%table_name$s_%geom_name$s" WHERE ID = OLD."%id_name$s";
END
@end create_trigger_rtree_update2

@begin create_trigger_rtree_update3
@param table_name
@param geom_name
@param id_name
CREATE TRIGGER "rtree_%table_name$s_%geom_name$s_update3" AFTER UPDATE ON "%table_name$s"
  WHEN OLD."%id_name$s" != NEW."%id_name$s" AND
       (NEW."%geom_name$s" NOTNULL AND NOT ST_IsEmpty(NEW."%geom_name$s"))
BEGIN
  DELETE FROM "rtree_%table_name$s_%geom_name$s" WHERE ID = OLD."%id_name$s";
  INSERT OR REPLACE INTO "rtree_%table_name$s_%geom_name$s" VALUES (
    NEW."%id_name$s",
    ST_MinX(NEW."%geom_name$s"), ST_MaxX(NEW."%geom_name$s"),
    ST_MinY(NEW."%geom_name$s"), ST_MaxY(NEW."%geom_name$s")
  );
END
@end create_trigger_rtree_update3

@begin create_trigger_rtree_update4
@param table_name
@param geom_name
@param id_name
CREATE TRIGGER "rtree_%table_name$s_%geom_name$s_update4" AFTER UPDATE ON "%table_name$s"
  WHEN OLD."%id_name$s" != NEW."%id_name$s" AND
       (NEW."%geom_name$s" ISNULL OR ST_IsEmpty(NEW."%geom_name$s"))
BEGIN
  DELETE FROM "rtree_%table_name$s_%geom_name$s" WHERE ID IN (OLD."%id_name$s", NEW."%id_name$s");
END
@end create_trigger_rtree_update4


@begin create_table_gpkg_extensions
CREATE TABLE IF NOT EXISTS gpkg_extensions ( table_name TEXT, column_name TEXT, extension_name TEXT NOT NULL, definition TEXT NOT NULL, scope TEXT NOT NULL, CONSTRAINT ge_tce UNIQUE (table_name, column_name, extension_name) )
@end create_table_gpkg_extensions

@begin insert_into_table_gpkg_extensions
@param table_name
@param geom_name
INSERT INTO "gpkg_extensions" (
    "table_name", 
    "column_name", 
    "extension_name", 
    "definition", 
    "scope"
) VALUES (
    '%table_name$s', 
    '%geom_name$s', 
    'gpkg_rtree_index', 
    'http://www.geopackage.org/spec/#extension_rtree', 
    'read-write'
)
@end insert_into_table_gpkg_extensions


@begin bboxintersects
@param table_name
@param id_name
@param geom_name
@param minX
@param minY
@param maxX
@param maxY
("%id_name$s" IN (SELECT "rtree_%table_name$s_%geom_name$s"."id" FROM "rtree_%table_name$s_%geom_name$s" WHERE "rtree_%table_name$s_%geom_name$s"."minx" <= (%maxX$s) AND "rtree_%table_name$s_%geom_name$s"."miny" <= (%maxY$s) AND "rtree_%table_name$s_%geom_name$s"."maxx" >= (%minX$s) AND "rtree_%table_name$s_%geom_name$s"."maxy" >= (%minY$s)))
@end bboxintersects

@begin bbox_of_index
@param table_name
@param geom_name
select min(minx) as minx, min(miny) as miny, max(maxx) as maxx, max(maxy) as maxy, count(*) as rows from "rtree_%table_name$s_%geom_name$s"
@end bbox_of_index

@begin has_index
@param table_name
@param geom_name
select count(1) from gpkg_extensions where table_name = '%table_name$s' and column_name = '%geom_name$s' and extension_name = 'gpkg_rtree_index'
@end has_index



