
@begin createRepositoryIndex1
create index if not exists idx_data_1 on VCSGISREPO_DATA (COD_ENTITY ASC, DAT_REVNUMBER ASC)
@end createRepositoryIndex1

@begin createRepositoryIndex2
create index if not exists idx_data_2 on VCSGISREPO_DATA (DAT_FEATURERELATEDCODE ASC, DAT_REVNUMBER ASC, DAT_OPERATION ASC)
@end createRepositoryIndex2

@begin getDataOfEntityFromRevisionNumber
@param revision_number
@param entity_code
@param data_table_name
select * from "%data_table_name$s" where
        "%data_table_name$s"."COD_ENTITY" = '%entity_code$s' AND
        "%data_table_name$s"."COD_DATA" in (
	select 
	  MIN("VCSGISREPO_DATA1"."COD_DATA")
	from "%data_table_name$s" AS "VCSGISREPO_DATA1"
	  left join "%data_table_name$s" AS "VCSGISREPO_DATA2" on
	    "VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE" = "VCSGISREPO_DATA2"."DAT_FEATURERELATEDCODE"
	    and "VCSGISREPO_DATA2"."DAT_REVNUMBER" > %revision_number$d 
	where 
	  "VCSGISREPO_DATA1"."COD_ENTITY" = '%entity_code$s'
	  and "VCSGISREPO_DATA1"."DAT_REVNUMBER" > %revision_number$d   
	group by "VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE", "VCSGISREPO_DATA1"."DAT_REVNUMBER", "VCSGISREPO_DATA1"."DAT_OPERATION"
	having not (
	  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 0 and MAX("VCSGISREPO_DATA2"."DAT_OPERATION") = 2 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and (MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0  or max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 ))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 0 and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") <> 0  and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and (max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1) and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and max("VCSGISREPO_DATA2"."DAT_OPERATION") = 2 and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))  )
)
order by "VCSGISREPO_DATA"."DAT_OPERATION" desc
@end getDataOfEntityFromRevisionNumber

@begin getDataOfEntityToRevisionNumber
@param revision_number
@param entity_code
@param data_table_name
select * from "%data_table_name$s" where 
        "%data_table_name$s"."COD_ENTITY" = '%entity_code$s' AND
        "%data_table_name$s"."COD_DATA" in (
	select 
	  MIN("VCSGISREPO_DATA1"."COD_DATA")
	from "%data_table_name$s" AS "VCSGISREPO_DATA1"
	  left join "%data_table_name$s" AS "VCSGISREPO_DATA2" on
	    "VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE" = "VCSGISREPO_DATA2"."DAT_FEATURERELATEDCODE"
	    and "VCSGISREPO_DATA2"."DAT_REVNUMBER" <= %revision_number$d 
	where 
	  "VCSGISREPO_DATA1"."COD_ENTITY" = '%entity_code$s'
	  and "VCSGISREPO_DATA1"."DAT_REVNUMBER" <= %revision_number$d   
	group by "VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE", "VCSGISREPO_DATA1"."DAT_REVNUMBER", "VCSGISREPO_DATA1"."DAT_OPERATION"
	having not (
	  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 0 and MAX("VCSGISREPO_DATA2"."DAT_OPERATION") = 2 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and (MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0  or max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 ))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 0 and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") <> 0  and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and (max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1) and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and max("VCSGISREPO_DATA2"."DAT_OPERATION") = 2 and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))  )
)
order by "VCSGISREPO_DATA"."DAT_OPERATION" desc
@end getDataOfEntityToRevisionNumber

@begin getDataOfEntityToRevisionNumberAndRoi
@param revision_number
@param entity_code
@param roi
@param data_table_name
select * from "%data_table_name$s" where 
        "%data_table_name$s"."COD_ENTITY" = '%entity_code$s' AND
        "%data_table_name$s"."COD_DATA" in (
	select 
	  MIN("VCSGISREPO_DATA1"."COD_DATA")
	from "%data_table_name$s" AS "VCSGISREPO_DATA1"
	  left join "%data_table_name$s" AS "VCSGISREPO_DATA2" on
	    "VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE" = "VCSGISREPO_DATA2"."DAT_FEATURERELATEDCODE"
	    and "VCSGISREPO_DATA2"."DAT_REVNUMBER" <= %revision_number$d 
	where 
	  "VCSGISREPO_DATA1"."COD_ENTITY" = '%entity_code$s'
	  and "VCSGISREPO_DATA1"."DAT_REVNUMBER" <= %revision_number$d   
          and ("VCSGISREPO_DATA1"."DAT_GEOM" is null or (ST_Intersects("VCSGISREPO_DATA1"."DAT_GEOM",%roi$s)) )
	group by "VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE", "VCSGISREPO_DATA1"."DAT_REVNUMBER", "VCSGISREPO_DATA1"."DAT_OPERATION"
	having not (
	  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 0 and MAX("VCSGISREPO_DATA2"."DAT_OPERATION") = 2 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and (MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0  or max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 ))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 0 and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") <> 0  and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and (max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1) and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and max("VCSGISREPO_DATA2"."DAT_OPERATION") = 2 and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))  )
)
order by "VCSGISREPO_DATA"."DAT_OPERATION" desc
@end getDataOfEntityToRevisionNumberAndRoi

@begin getDataOfEntityFromEfectiveDate
@param entity_code
@param efective_date
@param data_table_name
select * from "%data_table_name$s" where 
        "%data_table_name$s"."COD_ENTITY" = '%entity_code$s' AND
        "%data_table_name$s"."COD_DATA" in (
	select 
	  MIN("VCSGISREPO_DATA1"."COD_DATA")
	from "%data_table_name$s" AS "VCSGISREPO_DATA1"
	  left join "%data_table_name$s" AS "VCSGISREPO_DATA2" on
	    "VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE" = "VCSGISREPO_DATA2"."DAT_FEATURERELATEDCODE"
	    and "VCSGISREPO_DATA2"."DAT_EFECTIVEDATE" <= to_date('%efective_date$s', 'YYYY-MM-DD HH24:MI:SS') 
	where 
	  "VCSGISREPO_DATA1"."COD_ENTITY" = '%entity_code$s'
	  and "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE" <= to_date('%efective_date$s', 'YYYY-MM-DD HH24:MI:SS')   
	group by "VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE", "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE", "VCSGISREPO_DATA1"."DAT_REVNUMBER", "VCSGISREPO_DATA1"."DAT_OPERATION"
	having not (
	  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 0 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and (MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0  or max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 ))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and (max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1) and "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE" <= max("VCSGISREPO_DATA2"."DAT_EFECTIVEDATE") and "VCSGISREPO_DATA1"."DAT_REVNUMBER" <> max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and max("VCSGISREPO_DATA2"."DAT_OPERATION") = 2 and "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE" <= max("VCSGISREPO_DATA2"."DAT_EFECTIVEDATE") and "VCSGISREPO_DATA1"."DAT_REVNUMBER" <> max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))  )
)
@end getDataOfEntityFromEfectiveDate

@begin getDataOfEntityFromEfectiveDateAndRoi
@param entity_code
@param efective_date
@param roi
@param data_table_name
@const DELETE=0
@const UPDATE=1
@const INSERT=2
select * from "%data_table_name$s" where 
        "%data_table_name$s"."COD_ENTITY" = '%entity_code$s' AND
        "%data_table_name$s"."COD_DATA" in (
	select 
	  MIN("VCSGISREPO_DATA1"."COD_DATA")
	from "%data_table_name$s" AS "VCSGISREPO_DATA1"
	  left join "%data_table_name$s" AS "VCSGISREPO_DATA2" on
	    "VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE" = "VCSGISREPO_DATA2"."DAT_FEATURERELATEDCODE"
	    and "VCSGISREPO_DATA2"."DAT_EFECTIVEDATE" <= to_date('%efective_date$s', 'YYYY-MM-DD HH24:MI:SS') 
	where 
	  "VCSGISREPO_DATA1"."COD_ENTITY" = '%entity_code$s'
	  and "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE" <= to_date('%efective_date$s', 'YYYY-MM-DD HH24:MI:SS')   
          and ("VCSGISREPO_DATA1"."DAT_GEOM" is null or (ST_Intersects("VCSGISREPO_DATA1"."DAT_GEOM",%roi$s)) )
	group by "VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE", "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE", "VCSGISREPO_DATA1"."DAT_REVNUMBER", "VCSGISREPO_DATA1"."DAT_OPERATION"
	having not (
	  ("VCSGISREPO_DATA1"."DAT_OPERATION" = %DELETE$s )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = %UPDATE$s and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = %DELETE$s )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = %INSERT$s and (MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = %DELETE$s  or max("VCSGISREPO_DATA2"."DAT_OPERATION") = %UPDATE$s or min("VCSGISREPO_DATA2"."DAT_OPERATION") = %UPDATE$s ))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = %UPDATE$s and (max("VCSGISREPO_DATA2"."DAT_OPERATION") = %UPDATE$s or min("VCSGISREPO_DATA2"."DAT_OPERATION") = %UPDATE$s) and "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE" <= max("VCSGISREPO_DATA2"."DAT_EFECTIVEDATE") and "VCSGISREPO_DATA1"."DAT_REVNUMBER" <> max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = %INSERT$s and max("VCSGISREPO_DATA2"."DAT_OPERATION") = %INSERT$s and "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE" <= max("VCSGISREPO_DATA2"."DAT_EFECTIVEDATE") and "VCSGISREPO_DATA1"."DAT_REVNUMBER" <> max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))  )
)
@end getDataOfEntityFromEfectiveDateAndRoi

@begin dateFormat
yyyy-MM-dd HH24:mm:ss.S
@end dateFormat

@begin createWorkspaceIndex1
create index if not exists idx_wschanges_1 on VCSGIS_WSCHANGES (COD_ENTITY ASC, WSCH_OPERATION DESC, COD_WSCHANGE ASC)
@end createWorkspaceIndex1

@begin createWorkspaceIndex2
create index if not exists idx_wschanges_2 on VCSGIS_WSCHANGES (WSCH_SELECTED ASC, WSCH_OPERATION ASC)
@end createWorkspaceIndex2

@begin createWorkspaceIndex3
create index if not exists idx_remotechanges_3 on VCSGIS_REMOTECHANGES (COD_ENTITY ASC, RCH_SELECTED ASC)
@end createWorkspaceIndex3

@begin updateStateFromLocalChanges
@param status
update VCSGIS_REMOTECHANGES 
set RCH_STATUS = %status$d 
where exists (select 1 from VCSGIS_WSCHANGES where RCH_DATACODE = WSCH_FEATURECODE LIMIT 1)
@end updateStateFromLocalChanges

@begin removeLocalChangesRelatedToSelectedRemoteChanges
@param entityCode
delete from VCSGIS_WSCHANGES 
where COD_ENTITY = '%entityCode$s' and WSCH_FEATURECODE in (
    select RCH_DATACODE from VCSGIS_REMOTECHANGES where RCH_DATACODE = WSCH_FEATURECODE and CAST(RCH_SELECTED as INT)=1)
@end removeLocalChangesRelatedToSelectedRemoteChanges

@begin getChangesWidthUserData
@param EntityName
@param FeatureIdFieldName
@param RelatedFeatureCode
@param filter
SELECT * FROM VCSGIS_WSCHANGES left join "%EntityName$s" on WSCH_FEATURECODE = "%FeatureIdFieldName$s" WHERE "%FeatureIdFieldName$s" <> '%RelatedFeatureCode$s' AND (%filter$s)
@end getChangesWidthUserData

@begin alterTableAddColumnVCSGISCODE
@param EntityName
ALTER TABLE "%EntityName$s" ADD COLUMN "VCSGISCODE" VARCHAR(40)
@end alterTableAddColumnVCSGISCODE

@begin alterTableDropPrimaryKey
@param EntityName
ALTER TABLE "%EntityName$s" DROP PRIMARY KEY
@end alterTableDropPrimaryKey

@begin alterTableAlterColumnVCSGISCODESetNotNull
@param EntityName
ALTER TABLE "%EntityName$s" ALTER COLUMN "VCSGISCODE" SET NOT NULL
@end alterTableAlterColumnVCSGISCODESetNotNull

@begin alterTableAddPrimaryKeyVCSGISCODE
@param EntityName
ALTER TABLE "%EntityName$s" ADD PRIMARY KEY ("VCSGISCODE")
@end alterTableAddPrimaryKeyVCSGISCODE

@begin defaultCheckoutMode
USESELECT (posible values USEDBFUNCTION, USESELECT, USEAPPFILTER)
@end defaultCheckoutMode


@begin getDataOfEntityFromFeatureRelatedCode
@param featureRelatedCode
@param entity_code
@param data_table_name
select *, "VCSGISREPO_REVISIONS"."REV_COMMENT"
from "%data_table_name$s" 
left join "VCSGISREPO_REVISIONS" on "%data_table_name$s"."COD_REVISION" = "VCSGISREPO_REVISIONS"."COD_REVISION"
where 
        "%data_table_name$s"."COD_ENTITY" = '%entity_code$s' AND
        "%data_table_name$s"."DATA_FEATURERELATEDCODE" = '%featureRelatedCode$s';
order by "data_table_name$s"."DATA_EFECTIVEDATE" asc
@end getDataOfEntityFromFeatureRelatedCode