/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.creation.model;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractListModel;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.creation.MakePluginPackageService;
import org.gvsig.installer.lib.api.creation.MakePluginPackageServiceException;

public class PluginListModel
extends AbstractListModel {
    private static final long serialVersionUID = -6434919440184484361L;
    private PackageInfo[] plugins;

    public PluginListModel(MakePluginPackageService installerCreationService) throws MakePluginPackageServiceException {
        this.plugins = new PackageInfo[installerCreationService.getPluginPackageCount()];
        for (int i = 0; i < this.plugins.length; ++i) {
            this.plugins[i] = installerCreationService.getPluginPackageInfo(i);
        }
        Arrays.sort(this.plugins, new Comparator<PackageInfo>(){

            @Override
            public int compare(PackageInfo info1, PackageInfo info2) {
                if (info2 == null) {
                    return info1 == null ? 0 : 1;
                }
                if (info1 == null) {
                    return -1;
                }
                return info1.getCode().compareTo(info2.getCode());
            }
        });
    }

    @Override
    public Object getElementAt(int index) {
        return this.plugins[index];
    }

    @Override
    public int getSize() {
        return this.plugins.length;
    }

    public void refresh() {
        this.fireContentsChanged(this, 0, this.getSize());
    }
}

