/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.creation.wizard;

import java.io.File;
import javax.swing.JPanel;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.swing.impl.creation.DefaultMakePluginPackageWizard;
import org.gvsig.installer.swing.impl.creation.panel.SelectPluginToInstallPanel;

public class SelectPlugintoInstallWizard
extends SelectPluginToInstallPanel
implements OptionPanel {
    private static final long serialVersionUID = 3735333214491700782L;
    private DefaultMakePluginPackageWizard installerCreationWizard;

    public SelectPlugintoInstallWizard(DefaultMakePluginPackageWizard installerCreationWizard) {
        this.installerCreationWizard = installerCreationWizard;
        installerCreationWizard.setNextButtonEnabled(false);
        installerCreationWizard.setBackButtonEnabled(false);
    }

    public JPanel getJPanel() {
        return this;
    }

    public String getPanelTitle() {
        return this.swingInstallerManager.getText("_plugin_to_install");
    }

    public void lastPanel() {
    }

    public void nextPanel() {
        PackageInfo selectedPackageInfo = super.getSelectedInstallerInfo();
        String selectedPackageCode = super.getSelectedInstallerInfo().getCode();
        InstallerManager manager = InstallerLocator.getInstallerManager();
        this.installerCreationWizard.setSelectedPackageInfo(selectedPackageInfo);
        this.installerCreationWizard.setOriginalPluginFolder(manager.getAddonFolder(selectedPackageCode));
        this.installerCreationWizard.setBackButtonEnabled(true);
    }

    public void updatePanel() {
    }

    @Override
    public void setSelectedInstallerInfo(PackageInfo installerInfo) {
        super.setSelectedInstallerInfo(installerInfo);
        InstallerManager installManager = InstallerLocator.getInstallerManager();
        File file = installManager.getAddonFolder(installerInfo.getCode());
        if (file != null) {
            String type = installManager.getDefaultLocalRepositoryType(file);
            installerInfo.setType(type);
        }
        this.installerCreationWizard.setNextButtonEnabled(installerInfo != null);
    }
}

