/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.execution.panel.renderers;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import org.gvsig.installer.swing.impl.execution.panel.SelectPackagesPanel;
import org.gvsig.installer.swing.impl.execution.panel.model.PackagesTableModel;

public class InstallStatusCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 1271382732175530111L;
    PackagesTableModel.PackageStatus status;
    SelectPackagesPanel panel;

    public InstallStatusCellEditor(SelectPackagesPanel selectPackagesPanel) {
        super(new JCheckBox());
        this.panel = selectPackagesPanel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable arg0, Object value, boolean isSelected, int row, int col) {
        JCheckBox check = (JCheckBox)this.getComponent();
        this.status = (PackagesTableModel.PackageStatus)((Object)value);
        switch (this.status) {
            case INSTALLED: {
                check.setEnabled(true);
                check.setSelected(false);
                break;
            }
            case TO_REINSTALL: {
                check.setEnabled(true);
                check.setSelected(true);
                break;
            }
            case NOT_INSTALLED: {
                check.setEnabled(true);
                check.setSelected(false);
                break;
            }
            case TO_INSTALL: {
                check.setEnabled(true);
                check.setSelected(true);
                break;
            }
            case INSTALLED_NOT_INSTALLABLE: {
                check.setEnabled(false);
                break;
            }
            case INSTALLATION_NOT_AVAILABLE: {
                check.setEnabled(false);
                check.setSelected(false);
                break;
            }
            case BROKEN: {
                check.setEnabled(false);
                check.setSelected(false);
                break;
            }
            default: {
                check.setSelected(false);
                check.setEnabled(false);
            }
        }
        return check;
    }

    @Override
    public Object getCellEditorValue() {
        JCheckBox check = (JCheckBox)this.getComponent();
        switch (this.status) {
            case INSTALLED: {
                if (!check.isSelected()) break;
                this.status = PackagesTableModel.PackageStatus.TO_REINSTALL;
                break;
            }
            case TO_REINSTALL: {
                if (check.isSelected()) break;
                this.status = PackagesTableModel.PackageStatus.INSTALLED;
                break;
            }
            case NOT_INSTALLED: {
                if (!check.isSelected()) break;
                this.status = PackagesTableModel.PackageStatus.TO_INSTALL;
                break;
            }
            case TO_INSTALL: {
                if (check.isSelected()) break;
                this.status = PackagesTableModel.PackageStatus.NOT_INSTALLED;
                break;
            }
        }
        return this.status;
    }
}

