/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.execution.panel.renderers;

import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.impl.DefaultSwingInstallerManager;
import org.gvsig.installer.swing.impl.execution.panel.model.PackagesTableModel;

public class InstallStatusCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1195015856704835320L;
    private DefaultSwingInstallerManager swingInstallerManager = (DefaultSwingInstallerManager)SwingInstallerLocator.getSwingInstallerManager();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        PackagesTableModel.PackageStatus status = (PackagesTableModel.PackageStatus)((Object)value);
        JLabel check = new JLabel();
        switch (status) {
            case INSTALLED: {
                URL resource = this.getClass().getResource("/images/installed.png");
                ImageIcon icon = new ImageIcon(resource);
                check.setIcon(icon);
                check.setToolTipText(this.swingInstallerManager.getText("_already_installed,_check_to_reinstall"));
                return check;
            }
            case TO_REINSTALL: {
                URL resource = this.getClass().getResource("/images/toReinstall.png");
                ImageIcon icon = new ImageIcon(resource);
                check.setIcon(icon);
                check.setToolTipText(this.swingInstallerManager.getText("_checked_to_reinstall"));
                return check;
            }
            case NOT_INSTALLED: {
                URL resource = this.getClass().getResource("/images/notInstalled.png");
                ImageIcon icon = new ImageIcon(resource);
                check.setIcon(icon);
                check.setToolTipText(this.swingInstallerManager.getText("_not_installed,_check_to_install"));
                return check;
            }
            case TO_INSTALL: {
                URL resource = this.getClass().getResource("/images/toInstall.png");
                ImageIcon icon = new ImageIcon(resource);
                check.setIcon(icon);
                check.setToolTipText(this.swingInstallerManager.getText("_checked_to_install"));
                return check;
            }
            case INSTALLED_NOT_INSTALLABLE: {
                URL resource = this.getClass().getResource("/images/installedNotInstallable.png");
                ImageIcon icon = new ImageIcon(resource);
                check.setIcon(icon);
                check.setToolTipText(this.swingInstallerManager.getText("_already_installed_but_not_installable"));
                return check;
            }
            case BROKEN: {
                URL resource = this.getClass().getResource("/images/broken.png");
                ImageIcon icon = new ImageIcon(resource);
                check.setIcon(icon);
                check.setToolTipText(this.swingInstallerManager.getText("_broken_package"));
                return check;
            }
            case INSTALLATION_NOT_AVAILABLE: {
                URL resource = this.getClass().getResource("/images/broken.png");
                ImageIcon icon = new ImageIcon(resource);
                check.setIcon(icon);
                check.setToolTipText(this.swingInstallerManager.getText("_can_install_package_at_this_moment"));
                return check;
            }
        }
        return check;
    }
}

