/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.execution.wizard;

import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gvsig.gui.beans.wizard.panel.NotContinueWizardException;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.installer.lib.api.Dependencies;
import org.gvsig.installer.lib.api.DependenciesCalculator;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.SwingInstallerManager;
import org.gvsig.installer.swing.api.execution.JShowPackageStatusAndAskContinuePanel;
import org.gvsig.installer.swing.api.execution.JShowRequiredPackagesAndAskContinuePanel;
import org.gvsig.installer.swing.impl.execution.InstallWizardPanel_ext;
import org.gvsig.installer.swing.impl.execution.panel.SelectPackagesPanel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectPackagesWizardPage
implements OptionPanel {
    private static final long serialVersionUID = -4678172923039393643L;
    private static final Logger LOG = LoggerFactory.getLogger(SelectPackagesWizardPage.class);
    private final InstallWizardPanel_ext wizardPanel;
    private SelectPackagesPanel selectPackagesPanel = null;

    public SelectPackagesWizardPage(InstallWizardPanel_ext wizardPanel) {
        this.wizardPanel = wizardPanel;
        this.selectPackagesPanel = new SelectPackagesPanel(this);
    }

    public JPanel getJPanel() {
        return this.selectPackagesPanel;
    }

    public String getPanelTitle() {
        return this.wizardPanel.getTranslation("_select_plugins");
    }

    public void lastPanel() {
        this.selectPackagesPanel.clearPanel();
    }

    public void nextPanel() throws NotContinueWizardException {
        SwingInstallerManager swingManager = SwingInstallerLocator.getSwingInstallerManager();
        this.checkDevelAndUnoficialPackages(swingManager);
        this.checkDependencies(swingManager);
        this.wizardPanel.setNextButtonEnabled(false);
    }

    private void checkDependencies(SwingInstallerManager swingManager) throws NotContinueWizardException {
        WindowManager wm;
        JShowRequiredPackagesAndAskContinuePanel dlg;
        Dependencies unresolvedDependencies;
        List troubledPackages;
        List requiredPackages;
        block9: {
            requiredPackages = null;
            troubledPackages = null;
            unresolvedDependencies = null;
            try {
                InstallerManager manager = InstallerLocator.getInstallerManager();
                DependenciesCalculator calculator = manager.createDependenciesCalculator(this.wizardPanel.getInstallerExecutionService());
                calculator.addPackageToInstall(this.wizardPanel.getPackagesToInstall());
                PackageInfo[] pkgs = manager.getInstalledPackages();
                calculator.addInstalledPackage(pkgs);
                calculator.calculate();
                requiredPackages = calculator.getRequiredPackages();
                unresolvedDependencies = calculator.getUnresolvedDependencies();
                troubledPackages = calculator.getConflictPackages();
            }
            catch (Throwable e) {
                LOG.warn(this.wizardPanel.getTranslation("_an_error_has_occurred_when_calculating_the_dependecies_of_the_packages_to_install"), e);
                int resp = JOptionPane.showConfirmDialog(null, this.wizardPanel.getTranslation("_an_error_has_occurred_when_calculating_the_dependecies_of_the_selected_packages") + "\n" + this.wizardPanel.getTranslation("_it_is_not_possible_to_verify_if_any_additional_package_is_needed_to_install_the_selected_packages") + "\n" + this.wizardPanel.getTranslation("_if_you_want_you_can_select_again_manually_the_packets_that_might_be_necessary") + this.wizardPanel.getTranslation("_do_you_want_to_continue_and_install_the_packages_you_already_have_selected"), this.wizardPanel.getTranslation("_a_problem_has_occurred_when_calculating_the_dependencies"), 0, 2);
                if (resp != 1) break block9;
                throw new NotContinueWizardException("", null, false);
            }
        }
        if (troubledPackages != null && troubledPackages.size() > 0 && (dlg = swingManager.createJShowTroubledPackagesAndAskContinuePanel(troubledPackages, this.wizardPanel.getTranslation("_Some_of_the_selected_addons_should_not_be_installed_simultaneously") + ". " + this.wizardPanel.getTranslation("_Installing_these_addons_may_cause_errors") + "\n" + this.wizardPanel.getTranslation("_do_you_want_to_continue"))).needShow()) {
            wm = ToolsSwingLocator.getWindowManager();
            wm.showWindow((JComponent)dlg, this.wizardPanel.getTranslation("_do_you_want_to_continue"), WindowManager.MODE.DIALOG);
            if (dlg.cancelled()) {
                throw new NotContinueWizardException("", null, false);
            }
        }
        if (requiredPackages != null && requiredPackages.size() > 0 && (dlg = swingManager.createJShowRequiredPackagesAndAskContinuePanel(requiredPackages, this.wizardPanel.getTranslation("_the_selected_packages_require_to_install_or_update_the_following_packages") + ":\n" + this.wizardPanel.getTranslation("_do_you_want_to_continue"))).needShow()) {
            wm = ToolsSwingLocator.getWindowManager();
            wm.showWindow((JComponent)dlg, this.wizardPanel.getTranslation("_do_you_want_to_continue"), WindowManager.MODE.DIALOG);
            if (dlg.cancelled()) {
                throw new NotContinueWizardException("", null, false);
            }
        }
        if (unresolvedDependencies != null && unresolvedDependencies.size() > 0 && (dlg = swingManager.createJShowUnresolvedDependenciesAndAskContinuePanel(unresolvedDependencies, this.wizardPanel.getTranslation("_the_following_dependencies_have_not_been_possible_to_resolve") + ". " + this.wizardPanel.getTranslation("_This_may_cause_issues_in_gvSIG") + "\n" + this.wizardPanel.getTranslation("_do_you_want_to_continue_anyway"))).needShow()) {
            wm = ToolsSwingLocator.getWindowManager();
            wm.showWindow((JComponent)dlg, this.wizardPanel.getTranslation("_do_you_want_to_continue"), WindowManager.MODE.DIALOG);
            if (dlg.cancelled()) {
                throw new NotContinueWizardException("", null, false);
            }
        }
        for (PackageInfo pkg : requiredPackages) {
            this.selectPackagesPanel.getModel().selectPackage(pkg);
            LOG.info("Automatic selection of required package " + pkg.getCode());
        }
    }

    private void checkDevelAndUnoficialPackages(SwingInstallerManager swingManager) throws NotContinueWizardException {
        List<PackageInfo> packagesToInstall = this.wizardPanel.getPackagesToInstall();
        JShowPackageStatusAndAskContinuePanel dlg = swingManager.createJShowPackageStatusAndAskContinuePanel(packagesToInstall, this.wizardPanel.getTranslation("_you_have_selected_in_development_or_not_official_versions") + ". " + this.wizardPanel.getTranslation("_Installing_devel_addons_may_cause_errors") + "\n" + this.wizardPanel.getTranslation("_do_you_want_to_continue_anyway"));
        if (dlg.needShow()) {
            WindowManager wm = ToolsSwingLocator.getWindowManager();
            wm.showWindow((JComponent)dlg, this.wizardPanel.getTranslation("_do_you_want_to_continue"), WindowManager.MODE.DIALOG);
            if (dlg.cancelled()) {
                throw new NotContinueWizardException("", null, false);
            }
        }
    }

    public void updatePanel() {
        this.selectPackagesPanel.updatePanel();
        this.selectPackagesPanel.setInitialFilter();
        if (this.wizardPanel.getSelectDefaultPackages()) {
            this.selectPackagesPanel.selectPackages();
        }
        this.wizardPanel.setFinishButtonEnabled(true);
        this.wizardPanel.setBackButtonEnabled(true);
        this.wizardPanel.setNextButtonEnabled(false);
        this.wizardPanel.setCancelButtonEnabled(true);
        this.selectPackagesPanel.setBaseFilter(this.wizardPanel.getPackageFilter());
        if (this.wizardPanel.getSkipSelectPackagesWizardPage() && !this.getPackagesToInstall().isEmpty()) {
            this.wizardPanel.skip();
            return;
        }
        this.checkIfPluginSelected();
    }

    public void checkIfPluginSelected() {
        this.wizardPanel.setNextButtonEnabled(this.selectPackagesPanel.isPackageSelected());
    }

    public List<PackageInfo> getPackagesToInstall() {
        return this.selectPackagesPanel.getPackagesToInstall();
    }

    public Boolean isDefaultPackagesSelectionSet() {
        return this.wizardPanel.getSelectDefaultPackages();
    }

    public InstallWizardPanel_ext getWizardPanel() {
        return this.wizardPanel;
    }
}

