/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.packagebuilder.options;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.creation.MakePackageService;
import org.gvsig.installer.lib.api.creation.MakePackageServiceException;
import org.gvsig.installer.swing.api.JProgressPanel;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.packagebuilder.PackageBuildder;
import org.gvsig.installer.swing.impl.packagebuilder.BasePackageWizard;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressOption
implements OptionPanel {
    private static final Logger logger = LoggerFactory.getLogger(ProgressOption.class);
    private final BasePackageWizard wizard;
    private final JProgressPanel progressPanel;

    public ProgressOption(BasePackageWizard wizard) {
        this.wizard = wizard;
        this.progressPanel = SwingInstallerLocator.getSwingInstallerManager().createProgressPanel();
    }

    private String getText(String msg) {
        return Messages.getText((String)msg);
    }

    public JPanel getJPanel() {
        return this.progressPanel;
    }

    public String getPanelTitle() {
        return Messages.getText((String)"_Installer_progress");
    }

    public void lastPanel() {
        this.wizard.setFinishButtonEnabled(false);
        this.wizard.setCancelButtonEnabled(true);
    }

    public void nextPanel() {
    }

    public void updatePanel() {
        for (PackageBuildder.BeforePackingListener beforePackingListener : this.wizard.getBeforePackingListeners()) {
            try {
                beforePackingListener.perfrom((PackageBuildder)this.wizard);
            }
            catch (Throwable throwable) {}
        }
        OutputStream outputStream = this.openFileOutputStream(this.wizard.getPackageFile());
        if (outputStream == null) {
            return;
        }
        OutputStream indexOutputStream = null;
        if (this.wizard.shouldCreateIndex() && (indexOutputStream = this.openFileOutputStream(this.wizard.getPackageIndexFile())) == null) {
            return;
        }
        this.wizard.setFinishButtonEnabled(false);
        this.wizard.setCancelButtonEnabled(false);
        SimpleTaskStatus taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(this.wizard.getPackageInfo().getName());
        this.progressPanel.bind((TaskStatus)taskStatus);
        try {
            String downloadURL = this.wizard.getPackageInfo().getDownloadURLAsString();
            this.wizard.getPackageInfo().setDownloadURL("");
            MakePackageService makePackageService = InstallerLocator.getInstallerManager().createMakePackage(this.wizard.getFolderToPackaging(), (PackageInfo)this.wizard.getPackageInfo());
            taskStatus.message(this.getText("_Compressing"));
            makePackageService.preparePackage();
            makePackageService.createPackage(outputStream);
            if (indexOutputStream != null) {
                taskStatus.message(this.getText("_Creating_index"));
                makePackageService.createPackageIndex(this.wizard.getDownloadURL(), indexOutputStream);
            }
            this.wizard.getPackageInfo().setDownloadURL(downloadURL);
            taskStatus.terminate();
            taskStatus.message(this.getText("_Finished"));
        }
        catch (MakePackageServiceException e) {
            logger.info("Error while creating package.", (Throwable)e);
            JOptionPane.showMessageDialog(null, this.getText("_cant_create_the_package") + "\n\n" + e.getLocalizedMessageStack(), this.getText("_create_package"), 0);
        }
        this.wizard.setFinishButtonEnabled(true);
        this.wizard.setCancelButtonEnabled(false);
    }

    private OutputStream openFileOutputStream(File file) {
        FileOutputStream os;
        try {
            os = new FileOutputStream(file);
        }
        catch (FileNotFoundException e1) {
            JOptionPane.showMessageDialog(null, this.getText("_cant_create_the_package") + " (" + file + ").", this.getText("_create_package"), 2);
            return null;
        }
        return os;
    }
}

