/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami;

import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.GlobalKeyEventDispatcher;
import org.gvsig.andami.Launcher;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.plugins.ExclusiveUIExtension;
import org.gvsig.andami.plugins.ExtensionDecorator;
import org.gvsig.andami.plugins.IExtension;
import org.gvsig.andami.plugins.PluginClassLoader;
import org.gvsig.andami.preferences.DlgPreferences;
import org.gvsig.andami.ui.mdiFrame.MDIFrame;
import org.gvsig.andami.ui.mdiFrame.MainFrame;
import org.gvsig.andami.ui.mdiManager.MDIManager;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseRuntimeException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.AddDefinitionException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.gvsig.utils.XMLEntity;
import org.gvsig.utils.swing.threads.IMonitorableTask;
import org.gvsig.utils.swing.threads.IProgressMonitorIF;
import org.gvsig.utils.swing.threads.SwingWorker;
import org.gvsig.utils.swing.threads.TaskMonitorTimerListener;
import org.gvsig.utils.swing.threads.UndefinedProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginServices {
    private static Logger logger = LoggerFactory.getLogger(PluginServices.class);
    private static String[] arguments;
    private static ExclusiveUIExtension exclusiveUIExtension;
    private PluginClassLoader loader;
    private XMLEntity persistentXML;
    private DynObject pluginPersistence = null;
    private String[] alternativeNames = null;

    public PluginServices(PluginClassLoader loader) {
        this.loader = loader;
    }

    public PluginServices(PluginClassLoader loader, String[] alternativeNames) {
        this(loader);
        this.alternativeNames = alternativeNames;
    }

    public String[] getAlternativeNames() {
        return this.alternativeNames;
    }

    public String getText(String key) {
        if (key == null) {
            return null;
        }
        String translation = Messages.getText((String)key, (boolean)false);
        if (translation != null) {
            return translation;
        }
        logger.debug("Can't find translation for ''{}'' in plugin ''{}''.", (Object)key, (Object)this.getPluginName());
        return key;
    }

    public PluginClassLoader getClassLoader() {
        return this.loader;
    }

    public String getPluginName() {
        return this.loader.getPluginName();
    }

    @Deprecated
    public static PluginServices getPluginServices(Object pluginClassInstance) {
        try {
            PluginClassLoader loader = pluginClassInstance instanceof Class ? (PluginClassLoader)((Class)pluginClassInstance).getClassLoader() : (PluginClassLoader)pluginClassInstance.getClass().getClassLoader();
            return Launcher.getPluginServices(loader.getPluginName());
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Deprecated
    public static PluginServices getPluginServices(String pluginName) {
        return Launcher.getPluginServices(pluginName);
    }

    @Deprecated
    public static MDIManager getMDIManager() {
        MDIFrame frame = Launcher.getFrame();
        if (frame == null) {
            return null;
        }
        return frame.getMDIManager();
    }

    @Deprecated
    public static MainFrame getMainFrame() {
        return Launcher.getFrame();
    }

    public static void registerKeyStroke(KeyStroke key, KeyEventDispatcher a) {
        GlobalKeyEventDispatcher.getInstance().registerKeyStroke(key, a);
    }

    public static void unRegisterKeyStroke(KeyStroke key) {
        GlobalKeyEventDispatcher.getInstance().removeKeyStrokeBinding(key);
    }

    @Deprecated
    public static IExtension getExtension(Class extensionClass) {
        ExtensionDecorator extAux = (ExtensionDecorator)Launcher.getClassesExtensions().get(extensionClass);
        try {
            return extAux.getExtension();
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Deprecated
    public static ExtensionDecorator getDecoratedExtension(Class extensionClass) {
        return (ExtensionDecorator)Launcher.getClassesExtensions().get(extensionClass);
    }

    @Deprecated
    public static ExtensionDecorator[] getDecoratedExtensions() {
        HashMap map = Launcher.getClassesExtensions();
        ExtensionDecorator[] extensions = map.values().toArray(new ExtensionDecorator[0]);
        return extensions;
    }

    @Deprecated
    public static Iterator getExtensions() {
        return Launcher.getClassesExtensions().values().iterator();
    }

    public static String getText(Object pluginObject, String key) {
        if (key == null) {
            return null;
        }
        String translation = Messages.getText((String)key, (boolean)false);
        if (translation != null) {
            return translation;
        }
        logger.debug("Can't find translation for ''{}''.", (Object)key);
        return key;
    }

    public void setPersistentXML(XMLEntity entity) {
        this.persistentXML = entity;
    }

    @Deprecated
    public XMLEntity getPersistentXML() {
        if (this.persistentXML == null) {
            this.persistentXML = new XMLEntity();
        }
        return this.persistentXML;
    }

    public void addPopupMenuListener(String name, Component c, ActionListener listener) {
        MDIFrame frame = Launcher.getFrame();
        if (frame == null) {
            throw new RuntimeException("MDIFrame not loaded yet");
        }
        frame.addPopupMenuListener(name, c, listener, this.loader);
    }

    public File getPluginDirectory() {
        return Launcher.getPluginFolder(this.getPluginName());
    }

    public static Thread backgroundExecution(Runnable r) {
        Thread t = new Thread(new RunnableDecorator(r));
        t.start();
        return t;
    }

    public static void cancelableBackgroundExecution(final IMonitorableTask task) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                try {
                    task.run();
                    return task;
                }
                catch (Exception e) {
                    NotificationManager.addError(null, e);
                    return null;
                }
            }

            public void finished() {
                task.finished();
            }
        };
        Component mainFrame = (Component)((Object)PluginServices.getMainFrame());
        UndefinedProgressMonitor progressMonitor = null;
        String title = PluginServices.getText(null, "PluginServices.Procesando");
        progressMonitor = new UndefinedProgressMonitor((Frame)mainFrame, title);
        progressMonitor.setIndeterminated(!task.isDefined());
        progressMonitor.setInitialStep(task.getInitialStep());
        progressMonitor.setLastStep(task.getFinishStep());
        progressMonitor.setCurrentStep(task.getCurrentStep());
        progressMonitor.setMainTitleLabel(task.getStatusMessage());
        progressMonitor.setNote(task.getNote());
        progressMonitor.open();
        int delay = 500;
        TaskMonitorTimerListener timerListener = new TaskMonitorTimerListener((IProgressMonitorIF)progressMonitor, task);
        Timer timer = new Timer(delay, (ActionListener)timerListener);
        timerListener.setTimer(timer);
        timer.start();
        worker.start();
    }

    public static void closeApplication() {
        Launcher.closeApplication();
    }

    @Deprecated
    public static String[] getArguments() {
        return arguments;
    }

    @Deprecated
    public static void setArguments(String[] arguments) {
        PluginServices.arguments = arguments;
    }

    public static String getArgumentByName(String name) {
        name = StringUtils.removeStart((String)name, (String)"-");
        name = StringUtils.removeStart((String)name, (String)"-");
        for (int i = 2; i < arguments.length; ++i) {
            String arg = arguments[i];
            arg = StringUtils.removeStart((String)arg, (String)"-");
            int n = (arg = StringUtils.removeStart((String)arg, (String)"-")).indexOf(61);
            if (n > 0) {
                String argname = arg.substring(0, n);
                if (!StringUtils.equalsIgnoreCase((CharSequence)argname, (CharSequence)name)) continue;
                if (n == arg.length()) {
                    return "";
                }
                return arg.substring(n + 1);
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)arg, (CharSequence)name)) continue;
            return "true";
        }
        return null;
    }

    @Deprecated
    public static Logger getLogger() {
        return logger;
    }

    @Deprecated
    public static DlgPreferences getDlgPreferences() {
        return DlgPreferences.getInstance();
    }

    public static void putInClipboard(String data) {
        StringSelection ss = new StringSelection(data);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
    }

    @Deprecated
    public static String getFromClipboard() {
        try {
            return (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public static ExclusiveUIExtension getExclusiveUIExtension() {
        return exclusiveUIExtension;
    }

    @Deprecated
    public static void setExclusiveUIExtension(ExclusiveUIExtension extension) {
        exclusiveUIExtension = extension;
    }

    public static void addLoaders(ArrayList classLoaders) {
        PluginClassLoader.addLoaders(classLoaders);
    }

    public static IconThemeManager getIconThemeManager() {
        return ToolsSwingLocator.getIconThemeManager();
    }

    public static IconTheme getIconTheme() {
        return PluginServices.getIconThemeManager().getCurrent();
    }

    public static boolean runningInDevelopment() {
        String andamiPath;
        Properties props = System.getProperties();
        try {
            try {
                andamiPath = new File(Launcher.class.getResource(".").getFile() + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + "..").getCanonicalPath();
            }
            catch (IOException e) {
                andamiPath = new File(Launcher.class.getResource(".").getFile() + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + "..").getAbsolutePath();
            }
        }
        catch (Exception e1) {
            andamiPath = (String)props.get("user.dir");
        }
        File andamiJar = new File(andamiPath + File.separator + "andami.jar");
        if (!andamiJar.exists()) {
            return false;
        }
        File projectFile = new File(andamiPath + File.separator + ".project");
        File classpathFile = new File(andamiPath + File.separator + ".classpath");
        return projectFile.exists() && classpathFile.exists();
    }

    @Deprecated
    public PluginsManager getManager() {
        return PluginsLocator.getManager();
    }

    private String[] getAllPluginNames() {
        String[] names = new String[this.alternativeNames.length + 1];
        names[0] = this.getPluginName();
        for (int n = 0; n < this.alternativeNames.length; ++n) {
            names[n + 1] = this.alternativeNames[n];
        }
        return names;
    }

    public DynObject getPluginProperties() {
        if (this.pluginPersistence == null) {
            File persistenceFile;
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            DynStruct dynStruct = manager.getDynObjectDefinition(this.getPluginName());
            if (dynStruct == null) {
                File persistenceDefinitionFile = new File(this.getPluginDirectory(), "plugin-persistence.def");
                String[] names = this.getAllPluginNames();
                for (int i = 0; i < names.length; ++i) {
                    try {
                        dynStruct = manager.addDefinition(DynObject.class, names[i], (InputStream)new FileInputStream(persistenceDefinitionFile), (ClassLoader)this.getClassLoader(), null, null);
                        break;
                    }
                    catch (FileNotFoundException e) {
                        throw new PluginPersistenceNeedDefinitionException(this.getPluginName(), e);
                    }
                    catch (AddDefinitionException e) {
                        if (i + 1 < names.length) continue;
                        throw new PluginPersistenceAddDefinitionException(this.getPluginName(), e);
                    }
                }
            }
            if ((persistenceFile = this.getPluginPersistenceFile()).exists()) {
                try {
                    PersistentState state = manager.loadState((InputStream)new FileInputStream(persistenceFile));
                    this.pluginPersistence = (DynObject)manager.create(state);
                }
                catch (Throwable e) {
                    logger.info("Can't retrieve persistent values from plugin " + this.getPluginName(), e);
                    this.showMessageDialogDelayed(Messages.getText((String)"_Unable_to_read_persistence_for_plugin") + ": " + this.getPluginName() + "\n" + Messages.getText((String)"_Perhaps_saved_data_refers_to_missing_plugin"), Messages.getText((String)"_Persistence"), 2);
                }
            }
            if (this.pluginPersistence == null) {
                logger.info("Creating default values for plugin persistence (" + this.getPluginName() + ").");
                this.pluginPersistence = ToolsLocator.getDynObjectManager().createDynObject(dynStruct);
            }
        }
        return this.pluginPersistence;
    }

    private void showMessageDialogDelayed(final String msg, final String title, final int type) {
        PluginsManager pluginManger = PluginsLocator.getManager();
        pluginManger.addStartupTask("Persistence_" + this.getPluginName(), new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)((Object)PluginServices.getMainFrame()), msg, title, type);
            }
        }, true, 100);
    }

    public void savePluginProperties() {
        if (this.pluginPersistence == null) {
            return;
        }
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        File persistenceFile = this.getPluginPersistenceFile();
        try {
            PersistentState state = manager.getState((Object)this.pluginPersistence);
            manager.saveState(state, (OutputStream)new FileOutputStream(persistenceFile));
        }
        catch (Exception e) {
            throw new PluginSaveDataException(this.getPluginName(), e);
        }
    }

    private File getPluginPersistenceFile() {
        return new File(this.getPluginHomeFolder(), "plugin-persistence.dat");
    }

    public File getPluginHomeFolder() {
        return PluginsLocator.getManager().getPluginHomeFolder(this.getPluginName());
    }

    public String toString() {
        return super.toString() + " " + this.getPluginName();
    }

    public void addDependencyWithPlugin(PluginServices otherPlugin) {
        if (otherPlugin == null) {
            return;
        }
        this.getClassLoader().addPluginClassLoader(otherPlugin.getClassLoader());
    }

    static {
        exclusiveUIExtension = null;
    }

    public class PluginSaveDataException
    extends BaseRuntimeException {
        private static final long serialVersionUID = 4893241183911774542L;
        private static final String MESSAGE_FORMAT = "Can't save data of plugin %(name).";
        private static final String MESSAGE_KEY = "_cant_save_data_of_plugin_XnameX";

        PluginSaveDataException(String name) {
            super(MESSAGE_FORMAT, MESSAGE_KEY, 4893241183911774542L);
            this.setValue("name", name);
        }

        public PluginSaveDataException(String name, Throwable cause) {
            super(MESSAGE_FORMAT, cause, MESSAGE_KEY, 4893241183911774542L);
            this.setValue("name", name);
        }
    }

    public class PluginLoadDataException
    extends BaseRuntimeException {
        private static final long serialVersionUID = 1168749231143949111L;

        PluginLoadDataException(String name) {
            super("Can't load data of plugin %(name).", "_cant_load_data_of_plugin_XnameX", 1168749231143949111L);
            this.setValue("name", name);
        }
    }

    public class PluginPersistenceAddDefinitionException
    extends BaseRuntimeException {
        private static final long serialVersionUID = 2227722796640780361L;

        PluginPersistenceAddDefinitionException(String name, Throwable cause) {
            super("Can't add persistence definition of plugin %(name).", "_cant_add_persistence_definition_of_plugin_XnameX", 2227722796640780361L);
            this.initCause(cause);
            this.setValue("name", name);
        }
    }

    public class PluginPersistenceNeedDefinitionException
    extends BaseRuntimeException {
        private static final long serialVersionUID = -2036279527440882712L;

        PluginPersistenceNeedDefinitionException(String name, Throwable cause) {
            super("Can't load persistence definition of plugin %(name).", "_cant_load_persistence_definition_of_plugin_XnameX", -2036279527440882712L);
            this.initCause(cause);
            this.setValue("name", name);
        }
    }

    private static class RunnableDecorator
    implements Runnable {
        private Runnable r;

        public RunnableDecorator(Runnable r) {
            this.r = r;
        }

        @Override
        public void run() {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            r.run();
                        }
                        catch (RuntimeException e) {
                            NotificationManager.addError(Messages.getText((String)"PluginServices.Bug_en_el_codigo"), e);
                        }
                        catch (Error e) {
                            NotificationManager.addError(Messages.getText((String)"PluginServices.Error_grave_de_la_aplicaci\u00ef\u00bf\u00bdn"), e);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                NotificationManager.addWarning(Messages.getText((String)"PluginServices.No_se_pudo_poner_el_reloj_de_arena"), e);
            }
            catch (InvocationTargetException e) {
                NotificationManager.addWarning(Messages.getText((String)"PluginServices.No_se_pudo_poner_el_reloj_de_arena"), e);
            }
        }
    }
}

