/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.ui;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.Messages;
import org.gvsig.andami.messages.NotificationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndamiEventQueue
extends EventQueue {
    private static Logger logger = LoggerFactory.getLogger(AndamiEventQueue.class);

    @Override
    protected void dispatchEvent(AWTEvent event) {
        try {
            super.dispatchEvent(event);
        }
        catch (RuntimeException e) {
            if (this.canShowWindow(e, event)) {
                NotificationManager.addError(e);
            }
            try {
                PluginServices.getMainFrame().getStatusBar().message(e.getMessage(), 0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            logger.info("Error dispaching event", (Throwable)e);
        }
        catch (Error e) {
            NotificationManager.addError(Messages.getString("Error de la applicacion.  \nEs conveniente que salga de la aplicaci\u00f3n\n\n" + e.getLocalizedMessage()), e);
        }
    }

    private boolean canShowWindow(Throwable th, AWTEvent event) {
        try {
            MouseEvent me;
            if (event instanceof MouseEvent && (me = (MouseEvent)event).getButton() == 0 && me.getClickCount() == 0) {
                return false;
            }
            StackTraceElement[] stack_ee = th.getStackTrace();
            for (int i = 0; i < stack_ee.length; ++i) {
                StackTraceElement se = stack_ee[i];
                if (!se.getClassName().startsWith("org.gvsig.fmap.mapcontrol.MapControl")) continue;
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }
}

