/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.MDIManager;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.tools.swing.api.WindowPanel;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.impl.windowmanager.DefaultDialog;
import org.gvsig.tools.util.PropertiesSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolsWindowManager
implements WindowManager_v2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolsWindowManager.class);

    private int getAlign(WindowManager.MODE mode) {
        switch (mode) {
            case DIALOG: {
                return 10;
            }
            case TOOL: {
                return 24;
            }
        }
        return 23;
    }

    public void showWindow(JComponent contents, String title, WindowManager.MODE mode) {
        int flags = this.getFlags(contents);
        this.showWindow(contents, title, mode, this.getAlign(mode), null, flags, null);
    }

    public void showWindow(JComponent contents, String title, WindowManager.MODE mode, Image icon, int flags) {
        this.showWindow(contents, title, mode, this.getAlign(mode), icon, flags, null);
    }

    public void showWindow(JComponent contents, String title, WindowManager.MODE mode, int align, Image icon, int flags, Map<String, Object> props) {
        if (!SwingUtilities.isEventDispatchThread()) {
            int falign = align;
            switch (mode) {
                case DIALOG: {
                    try {
                        SwingUtilities.invokeAndWait(() -> this.showWindow(contents, title, mode, falign, null, flags, props));
                    }
                    catch (InterruptedException | InvocationTargetException exception) {}
                    break;
                }
                default: {
                    SwingUtilities.invokeLater(() -> this.showWindow(contents, title, mode, falign, null, flags, props));
                }
            }
            return;
        }
        switch (mode) {
            case SDIWINDOW: {
                ExternalFrame frame = new ExternalFrame(contents, title, mode, icon, props);
                frame.setVisible(true);
                break;
            }
            default: {
                MDIManager manager = PluginServices.getMDIManager();
                Window window = new Window(contents, title, mode, flags);
                align = this.getPropertyInt(props, "align", align);
                try {
                    window.getWindowInfo().setMaximized((Boolean)this.getProperty(props, "maximized", Boolean.class, false));
                }
                catch (Throwable th) {
                    LOGGER.warn("Can't process properties", th);
                }
                manager.addWindow(window, align);
            }
        }
    }

    public Dialog createDialog(JComponent component, String title, String header, int buttons) {
        DefaultDialog dialog = new DefaultDialog(component, title, header, buttons);
        return dialog;
    }

    public void showWindow(JComponent contents, String title, WindowManager.MODE mode, Image icon) {
        int align;
        switch (mode) {
            case DIALOG: {
                align = 10;
                break;
            }
            case TOOL: {
                align = 24;
                break;
            }
            default: {
                align = 23;
            }
        }
        this.showWindow(contents, title, mode, align, icon, 0, null);
    }

    private int getFlags(JComponent comp) {
        try {
            if (!(comp instanceof PropertiesSupport)) {
                return 0;
            }
            int flags = ((Number)((PropertiesSupport)comp).getProperty("WindowInfo.Flags")).intValue();
            return flags;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public void showWindow(JComponent contents, String tittle, WindowManager.MODE mode, Map<String, Object> props) {
        if (props == null || props.isEmpty()) {
            this.showWindow(contents, tittle, mode);
            return;
        }
        int flags = this.getPropertyInt(props, "flags", this.getFlags(contents));
        Image icon = (Image)this.getProperty(props, "icon", Image.class);
        this.showWindow(contents, tittle, mode, this.getAlign(mode), icon, flags, props);
    }

    private int getPropertyInt(Map<String, Object> props, String name, int defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        Object o = props.get(name);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return defaultValue;
    }

    private Object getProperty(Map<String, Object> props, String name, Class type) {
        return this.getProperty(props, name, type, null);
    }

    private Object getProperty(Map<String, Object> props, String name, Class type, Object defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        Object o = props.get(name);
        if (o == null) {
            return defaultValue;
        }
        if (type.isAssignableFrom(o.getClass())) {
            return o;
        }
        return null;
    }

    public class Window
    extends WindowPanel
    implements IWindow,
    ComponentListener {
        private static final long serialVersionUID = -6688594664366192449L;
        protected WindowInfo windowInfo;
        protected Object profile;

        public Window(JComponent contents, String title, WindowManager.MODE mode, int flags) {
            int code = flags == 0 ? 7 : flags;
            switch (mode) {
                case DIALOG: {
                    code |= 8;
                    this.profile = WindowInfo.DIALOG_PROFILE;
                    break;
                }
                case TOOL: {
                    code |= 0x10;
                    this.profile = WindowInfo.TOOL_PROFILE;
                    break;
                }
                default: {
                    this.profile = WindowInfo.EDITOR_PROFILE;
                }
            }
            this.contents = contents;
            this.windowInfo = new WindowInfo(code);
            this.windowInfo.setTitle(title);
            this.windowInfo.setNeedPack(true);
            Dimension size = this.contents.getPreferredSize();
            this.windowInfo.setHeight(size.height);
            this.windowInfo.setWidth(size.width);
            this.setLayout(new BorderLayout());
            this.add(this.contents, "Center");
            this.contents.addComponentListener(this);
        }

        public void fireClosingWindow() {
            this.contents.removeComponentListener(this);
            ComponentListener[] l = this.contents.getComponentListeners();
            for (int i = 0; i < l.length; ++i) {
                l[i].componentHidden(new ComponentEvent((Component)((Object)this), i));
            }
        }

        @Override
        public WindowInfo getWindowInfo() {
            return this.windowInfo;
        }

        @Override
        public Object getWindowProfile() {
            return this.profile;
        }

        @Override
        public void componentHidden(ComponentEvent arg0) {
            MDIManager manager = PluginServices.getMDIManager();
            manager.closeWindow(this);
        }

        @Override
        public void componentMoved(ComponentEvent arg0) {
        }

        @Override
        public void componentResized(ComponentEvent arg0) {
        }

        @Override
        public void componentShown(ComponentEvent arg0) {
        }
    }

    public class ExternalFrame
    extends JFrame
    implements ComponentListener {
        private JComponent contents;

        public ExternalFrame(final JComponent contents, String title, WindowManager.MODE mode, Image icon, Map<String, Object> props) {
            super(title);
            this.contents = contents;
            this.setContentPane(this.contents);
            this.contents.addComponentListener(this);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    contents.setVisible(false);
                }
            });
            if (icon != null) {
                this.setIconImage(icon);
            } else {
                this.setIconImage(PluginsLocator.getMainFrame().getIconImage());
            }
            this.pack();
            Component relativeTo = (Component)ToolsWindowManager.this.getProperty(props, "relativeTo", Component.class, null);
            if (relativeTo != null) {
                this.setLocationRelativeTo(relativeTo);
            }
        }

        @Override
        public void componentHidden(ComponentEvent arg0) {
            if (this.isVisible()) {
                this.contents.setVisible(false);
                this.contents.removeComponentListener(this);
                this.contents = null;
                this.setVisible(false);
                this.dispose();
            }
        }

        public void setComponentPane(Component component) {
        }

        @Override
        public void componentMoved(ComponentEvent arg0) {
        }

        @Override
        public void componentResized(ComponentEvent arg0) {
        }

        @Override
        public void componentShown(ComponentEvent arg0) {
        }
    }
}

