/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.ui.fonts;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.UIManager;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontUtils {
    private static Logger logger = LoggerFactory.getLogger(FontUtils.class);

    public static void setFont(String fontName) {
        String[] fieldList = new String[]{"Button.font", "CheckBox.font", "CheckBoxMenuItem.font", "ColorChooser.font", "ComboBox.font", "DesktopIcon.font", "EditorPane.font", "FormattedTextField.font", "Label.font", "List.font", "Menu.font", "MenuBar.font", "MenuItem.font", "OptionPane.font", "Panel.font", "PasswordField.font", "PopupMenu.font", "ProgressBar.font", "RadioButton.font", "RadioButtonMenuItem.font", "ScrollPane.font", "Slider.font", "Spinner.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextArea.font", "TextField.font", "TextPane.font", "TitledBorder.font", "ToggleButton.font", "ToolBar.font", "ToolTip.font", "Tree.font", "Viewport.font", "InternalFrame.titleFont"};
        for (int i = fieldList.length - 1; i >= 0; --i) {
            Font font = UIManager.getFont(fieldList[i]);
            if (font == null) continue;
            UIManager.put(fieldList[i], new Font(fontName, 0, font.getSize()));
        }
    }

    public static void initFonts() {
        Font defaultFont = UIManager.getFont("Label.font");
        if (defaultFont == null) {
            return;
        }
        if (defaultFont.canDisplayUpTo(Messages.getString("MDIFrame.quiere_salir")) == -1) {
            logger.debug("Fonts configuration was not necessary");
            return;
        }
        Font[] allfonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        HashSet<String> workingFonts = new HashSet<String>();
        for (int i = allfonts.length - 1; i >= 0; --i) {
            if (allfonts[i].canDisplayUpTo(Messages.getString("MDIFrame.quiere_salir")) != -1) continue;
            workingFonts.add(allfonts[i].getName());
        }
        String[] preferredFonts = FontUtils.getPreferedFonts(Locale.getDefault().getLanguage());
        for (int i = 0; i < preferredFonts.length; ++i) {
            if (!workingFonts.contains(preferredFonts[i])) continue;
            FontUtils.setFont(preferredFonts[i]);
            PluginServices.getLogger().info("FontSet: " + preferredFonts[i]);
            return;
        }
        Iterator iterator = workingFonts.iterator();
        if (iterator.hasNext()) {
            String fontName = (String)iterator.next();
            FontUtils.setFont(fontName);
            PluginServices.getLogger().info("FontSet: " + fontName);
        }
    }

    private static String[] getPreferedFonts(String lang) {
        if (lang.equals("zh")) {
            String[] preferredChineseFonts = new String[]{"AR PL KaitiM GB", "AR PL SungtiL GB", "Kochi Gothic", "SimSun"};
            return preferredChineseFonts;
        }
        return new String[0];
    }

    private static void listSystemFonts() {
        Font[] allfonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = allfonts.length - 1; i >= 0; --i) {
            System.out.println(allfonts[i].getName() + " --- " + allfonts[i].getFontName());
        }
    }
}

