/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util;

import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxUndoableEdit;
import java.util.ArrayList;
import java.util.List;

public class mxUndoManager
extends mxEventSource {
    protected int size;
    protected List<mxUndoableEdit> history;
    protected int indexOfNextAdd;

    public mxUndoManager() {
        this(100);
    }

    public mxUndoManager(int size) {
        this.size = size;
        this.clear();
    }

    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    public void clear() {
        this.history = new ArrayList<mxUndoableEdit>(this.size);
        this.indexOfNextAdd = 0;
        this.fireEvent(new mxEventObject("clear"));
    }

    public boolean canUndo() {
        return this.indexOfNextAdd > 0;
    }

    public void undo() {
        while (this.indexOfNextAdd > 0) {
            mxUndoableEdit edit = this.history.get(--this.indexOfNextAdd);
            edit.undo();
            if (!edit.isSignificant()) continue;
            this.fireEvent(new mxEventObject("undo", "edit", edit));
            break;
        }
    }

    public boolean canRedo() {
        return this.indexOfNextAdd < this.history.size();
    }

    public void redo() {
        int n = this.history.size();
        while (this.indexOfNextAdd < n) {
            mxUndoableEdit edit = this.history.get(this.indexOfNextAdd++);
            edit.redo();
            if (!edit.isSignificant()) continue;
            this.fireEvent(new mxEventObject("redo", "edit", edit));
            break;
        }
    }

    public void undoableEditHappened(mxUndoableEdit undoableEdit) {
        this.trim();
        if (this.size > 0 && this.size == this.history.size()) {
            this.history.remove(0);
        }
        this.history.add(undoableEdit);
        this.indexOfNextAdd = this.history.size();
        this.fireEvent(new mxEventObject("add", "edit", undoableEdit));
    }

    protected void trim() {
        while (this.history.size() > this.indexOfNextAdd) {
            mxUndoableEdit edit = this.history.remove(this.indexOfNextAdd);
            edit.die();
        }
    }
}

