/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.list;

import com.jeta.forms.store.properties.ListItemProperty;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class ListItemRenderer
extends JLabel
implements ListCellRenderer {
    private Color m_sel_bg;
    private Color m_sel_fg;
    private Color m_bg;
    private Color m_fg;
    private LookAndFeel m_laf;

    public ListItemRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf != this.m_laf) {
            this.m_laf = laf;
            this.updateColorCache();
        }
        if (isSelected) {
            this.setBackground(this.m_sel_bg);
            this.setForeground(this.m_sel_fg);
        } else {
            this.setBackground(this.m_bg);
            this.setForeground(this.m_fg);
        }
        if (value instanceof ListItemProperty) {
            ListItemProperty prop = (ListItemProperty)value;
            this.setIcon(prop.icon());
            String txt = prop.getLabel();
            if (txt == null) {
                txt = "";
            }
            this.setText(txt);
        } else {
            if (value == null) {
                value = "";
            }
            this.setText(value.toString());
        }
        return this;
    }

    private void updateColorCache() {
        this.m_sel_fg = UIManager.getColor("List.selectionForeground");
        this.m_sel_bg = UIManager.getColor("List.selectionBackground");
        this.m_bg = UIManager.getColor("List.background");
        this.m_fg = UIManager.getColor("List.foreground");
        this.setOpaque(true);
    }
}

