/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.ComponentConstraints;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridView;
import com.jeta.forms.gui.form.ReadOnlyConstraints;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Insets;
import java.lang.reflect.Field;
import java.util.Map;

public class GridComponentConstraints
implements ComponentConstraints {
    private Map m_constraintmap;
    private GridComponent m_gc;
    private GridView m_parentview;

    public GridComponentConstraints(GridComponent gc) {
        this.m_gc = gc;
        FormUtils.safeAssert(this.m_gc != null);
        FormUtils.safeAssert(this.m_gc.getParentView() != null);
    }

    public Object clone() {
        return new ReadOnlyConstraints(this.getColumn(), this.getRow(), this.getColumnSpan(), this.getRowSpan());
    }

    public CellConstraints createCellConstraints() {
        return (CellConstraints)this.getConstraints().clone();
    }

    private CellConstraints getConstraints() {
        CellConstraints constraints;
        if (this.m_parentview != this.m_gc.getParentView()) {
            this.initializeConstraintMap();
        }
        if ((constraints = (CellConstraints)this.m_constraintmap.get(this.m_gc)) == null) {
            this.m_gc.print();
            throw new NullPointerException("Component has not been added to the container.");
        }
        return constraints;
    }

    public int getColumn() {
        return this.getConstraints().gridX;
    }

    public int getRow() {
        return this.getConstraints().gridY;
    }

    public int getColumnSpan() {
        return this.getConstraints().gridWidth;
    }

    public int getRowSpan() {
        return this.getConstraints().gridHeight;
    }

    public Insets getInsets() {
        return this.getConstraints().insets;
    }

    public CellConstraints.Alignment getHorizontalAlignment() {
        return this.getConstraints().hAlign;
    }

    public CellConstraints.Alignment getVerticalAlignment() {
        return this.getConstraints().vAlign;
    }

    private void initializeConstraintMap() {
        try {
            this.m_parentview = this.m_gc.getParentView();
            FormLayout fl = this.m_parentview.getFormLayout();
            try {
                this.m_constraintmap = fl.getConstraintMap();
            }
            catch (Throwable t) {
                Field cmfield = FormLayout.class.getDeclaredField("constraintMap");
                cmfield.setAccessible(true);
                this.m_constraintmap = (Map)cmfield.get(fl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NullPointerException("Reflection error.");
        }
    }
}

