/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.memento;

import com.jeta.forms.store.AbstractJETAPersistable;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.support.PropertyMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class PropertiesMemento
extends AbstractJETAPersistable {
    static final long serialVersionUID = -3299575217906477613L;
    public static final int VERSION = 2;
    private String m_class_name;
    private PropertyMap m_props = new PropertyMap();

    public PropertiesMemento() {
    }

    public PropertiesMemento(String className) {
        this.m_class_name = className;
    }

    public String getBeanClassName() {
        return this.m_class_name;
    }

    public void addProperty(String name, Serializable value) {
        this.m_props.put(name, value);
    }

    public boolean containsProperty(String propName) {
        return this.m_props.containsKey(propName);
    }

    public String getComponentName() {
        Object obj = this.getPropertyValue("name");
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public Collection getPropertyNames() {
        return this.m_props.keySet();
    }

    public Object getPropertyValue(String propName) {
        return this.m_props.get(propName);
    }

    public void print() {
        System.out.println("................ properties memento: " + this.getBeanClassName() + "   ..............");
        Iterator iter = this.m_props.keySet().iterator();
        while (iter.hasNext()) {
            String pname = (String)iter.next();
            System.out.println("          " + pname + " = " + this.m_props.get(pname));
        }
    }

    public void setBeanClassName(String cname) {
        this.m_class_name = cname;
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        int version = in.readVersion();
        this.m_class_name = (String)in.readObject("classname");
        if (version <= 1) {
            HashMap custom_props;
            Object obj = in.readObject("properties");
            this.m_props = obj instanceof HashMap ? new PropertyMap((HashMap)obj) : (PropertyMap)obj;
            if (this.m_props == null) {
                this.m_props = new PropertyMap();
            }
            if ((custom_props = (HashMap)in.readObject("customproperties")) != null) {
                Iterator iter = custom_props.keySet().iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    this.m_props.put(key, custom_props.get(key));
                }
            }
        } else {
            Object obj = in.readObject("properties");
            this.m_props = obj instanceof HashMap ? new PropertyMap((HashMap)obj) : (PropertyMap)obj;
        }
    }

    public void write(JETAObjectOutput out) throws IOException {
        out.writeVersion(2);
        out.writeObject("classname", this.m_class_name);
        out.writeObject("properties", this.m_props);
    }
}

