/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.BorderProperty;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.forms.store.properties.ColorProxy;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class BevelBorderProperty
extends BorderProperty {
    static final long serialVersionUID = -9171261099090722557L;
    public static final int VERSION = 2;
    private int m_type;
    private ColorProperty m_highlightOuter = new ColorProperty("default");
    private ColorProperty m_highlightInner = new ColorProperty("default");
    private ColorProperty m_shadowOuter = new ColorProperty("default");
    private ColorProperty m_shadowInner = new ColorProperty("default");
    static final /* synthetic */ boolean $assertionsDisabled;

    public BevelBorderProperty() {
        this.setBorder(new BevelBorder(0));
    }

    public BevelBorderProperty(int bevelType) {
        this.setBorder(new BevelBorder(bevelType));
    }

    public Border createBorder(Component comp) {
        ColorProxy h_outer = null;
        ColorProxy h_inner = null;
        ColorProxy s_outer = null;
        ColorProxy s_inner = null;
        ColorProperty cprop = this.getHighlightOuterColorProperty();
        if (cprop != null && !cprop.getColorKey().equals("default") && cprop.getColor() != null) {
            h_outer = new ColorProxy(cprop);
        }
        if ((cprop = this.getHighlightInnerColorProperty()) != null && !cprop.getColorKey().equals("default") && cprop.getColor() != null) {
            h_inner = new ColorProxy(cprop);
        }
        if ((cprop = this.getShadowOuterColorProperty()) != null && !cprop.getColorKey().equals("default") && cprop.getColor() != null) {
            s_outer = new ColorProxy(cprop);
        }
        if ((cprop = this.getShadowInnerColorProperty()) != null && !cprop.getColorKey().equals("default") && cprop.getColor() != null) {
            s_inner = new ColorProxy(cprop);
        }
        BevelBorder b = new BevelBorder(this.getBevelType(), h_outer, h_inner, s_outer, s_inner);
        return this.createTitle(b);
    }

    public int getBevelType() {
        return this.m_type;
    }

    public Color getHighlightOuterColor() {
        return this.m_highlightOuter.getColor();
    }

    public Color getHighlightInnerColor() {
        return this.m_highlightInner.getColor();
    }

    public Color getShadowInnerColor() {
        return this.m_shadowInner.getColor();
    }

    public Color getShadowOuterColor() {
        return this.m_shadowOuter.getColor();
    }

    public ColorProperty getHighlightOuterColorProperty() {
        return this.m_highlightOuter;
    }

    public ColorProperty getHighlightInnerColorProperty() {
        return this.m_highlightInner;
    }

    public ColorProperty getShadowInnerColorProperty() {
        return this.m_shadowInner;
    }

    public ColorProperty getShadowOuterColorProperty() {
        return this.m_shadowOuter;
    }

    private void setBorder(BevelBorder bb) {
        this.m_type = bb.getBevelType();
    }

    public void setBevelType(int type) {
        this.m_type = type;
    }

    public void setHighlightOuterColorProperty(ColorProperty c) {
        this.m_highlightOuter = c;
    }

    public void setHighlightInnerColorProperty(ColorProperty c) {
        this.m_highlightInner = c;
    }

    public void setShadowInnerColorProperty(ColorProperty c) {
        this.m_shadowInner = c;
    }

    public void setShadowOuterColorProperty(ColorProperty c) {
        this.m_shadowOuter = c;
    }

    public void setValue(Object prop) {
        super.setValue(prop);
        if (prop instanceof BevelBorderProperty) {
            BevelBorderProperty bp = (BevelBorderProperty)prop;
            this.m_type = bp.m_type;
            this.m_highlightOuter.setValue(bp.m_highlightOuter);
            this.m_highlightInner.setValue(bp.m_highlightInner);
            this.m_shadowOuter.setValue(bp.m_shadowOuter);
            this.m_shadowInner.setValue(bp.m_shadowInner);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_type = in.readInt("type");
        if (version == 1) {
            this.m_highlightOuter.setConstantColor((Color)in.readObject("highlightouter"));
            this.m_highlightInner.setConstantColor((Color)in.readObject("highlightinner"));
            this.m_shadowOuter.setConstantColor((Color)in.readObject("shadowouter"));
            this.m_shadowInner.setConstantColor((Color)in.readObject("shadowinner"));
        } else {
            this.m_highlightOuter = (ColorProperty)in.readObject("highlightouter");
            this.m_highlightInner = (ColorProperty)in.readObject("ightlightinner");
            this.m_shadowOuter = (ColorProperty)in.readObject("shadowouter");
            this.m_shadowInner = (ColorProperty)in.readObject("shadowinner");
        }
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(BorderProperty.class));
        out.writeVersion(2);
        out.writeInt("type", this.m_type);
        out.writeObject("highlightouter", this.m_highlightOuter);
        out.writeObject("highlightinner", this.m_highlightInner);
        out.writeObject("shadowouter", this.m_shadowOuter);
        out.writeObject("shadowinner", this.m_shadowInner);
    }

    public String toString() {
        return "BEVEL";
    }

    static {
        $assertionsDisabled = !BevelBorderProperty.class.desiredAssertionStatus();
    }
}

