/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.components.list.ListItemRenderer;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.JETAProperty;
import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListModel;

public class ItemsProperty
extends JETAProperty {
    static final long serialVersionUID = -382961445445803877L;
    public static final int VERSION = 1;
    private Collection m_items;
    public static final String PROPERTY_ID = "items";
    static final /* synthetic */ boolean $assertionsDisabled;

    public ItemsProperty() {
        super(PROPERTY_ID);
    }

    public ItemsProperty(Collection items) {
        super(PROPERTY_ID);
        this.setItems(items);
    }

    public Collection getItems() {
        return this.m_items;
    }

    private void setItems(Collection items) {
        this.m_items = items == null ? null : new LinkedList(items);
    }

    public void setValue(Object prop) {
        if (prop instanceof ItemsProperty) {
            ItemsProperty ip = (ItemsProperty)prop;
            this.setItems(ip.getItems());
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void updateBean(JETABean jbean) {
        block6: {
            JList list;
            ListModel lm;
            Component comp;
            block5: {
                comp = null;
                if (jbean != null) {
                    comp = jbean.getDelegate();
                }
                if (!(comp instanceof JComboBox)) break block5;
                JComboBox jbox = (JComboBox)comp;
                jbox.setRenderer(new ListItemRenderer());
                jbox.removeAllItems();
                if (this.m_items == null) break block6;
                Iterator iter = this.m_items.iterator();
                while (iter.hasNext()) {
                    jbox.addItem(iter.next());
                }
                break block6;
            }
            if (comp instanceof JList && (lm = (list = (JList)comp).getModel()) instanceof DefaultListModel) {
                list.setCellRenderer(new ListItemRenderer());
                DefaultListModel lmodel = (DefaultListModel)lm;
                lmodel.removeAllElements();
                if (this.m_items != null) {
                    Iterator iter = this.m_items.iterator();
                    while (iter.hasNext()) {
                        lmodel.addElement(iter.next());
                    }
                }
            }
        }
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_items = (Collection)in.readObject(PROPERTY_ID);
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(JETAProperty.class));
        out.writeVersion(1);
        out.writeObject(PROPERTY_ID, this.m_items);
    }

    public String toString() {
        if (this.m_items == null) {
            return "Items Property:  null " + this.hashCode();
        }
        return "Items Property:  size: " + this.m_items.size() + "   " + this.hashCode();
    }

    static {
        $assertionsDisabled = !ItemsProperty.class.desiredAssertionStatus();
    }
}

