/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties.effects;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.effects.Paintable;
import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.gui.effects.TexturePainter;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.IconProperty;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.effects.PaintSupport;
import com.jeta.open.i18n.I18N;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class TextureProperty
extends JETAProperty
implements PaintSupport {
    static final long serialVersionUID = 6397209471447777696L;
    public static final int VERSION = 1;
    private IconProperty m_icon;
    private transient BufferedImage m_buffered_image;
    private transient TexturePainter m_painter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Painter createPainter() {
        if (this.m_painter == null) {
            this.m_painter = new TexturePainter(this);
        }
        return this.m_painter;
    }

    public BufferedImage getBufferedImage() {
        if (this.m_buffered_image == null && this.m_icon != null) {
            int width = this.m_icon.getIconWidth();
            int height = this.m_icon.getIconHeight();
            this.m_buffered_image = new BufferedImage(width, height, 1);
            Graphics2D bg = this.m_buffered_image.createGraphics();
            bg.drawImage(this.m_icon.imageIcon().getImage(), 0, 0, bg.getColor(), null);
            bg.dispose();
        }
        return this.m_buffered_image;
    }

    public IconProperty getIconProperty() {
        return this.m_icon;
    }

    public void setIconProperty(IconProperty icon) {
        this.m_icon = icon;
        this.m_buffered_image = null;
        this.m_painter = null;
    }

    public void setValue(Object prop) {
        if (prop instanceof TextureProperty) {
            TextureProperty tp = (TextureProperty)prop;
            this.m_icon = tp.m_icon;
            this.m_painter = null;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void updateBean(JETABean jbean) {
        Component comp;
        TexturePainter painter = (TexturePainter)this.createPainter();
        if (jbean != null && (comp = jbean.getDelegate()) instanceof Paintable) {
            ((Paintable)((Object)comp)).setBackgroundPainter(painter);
        }
    }

    public String toString() {
        return I18N.getLocalizedMessage("Texture");
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_icon = (IconProperty)in.readObject("icon");
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(JETAProperty.class));
        out.writeVersion(1);
        out.writeObject("icon", this.m_icon);
    }

    static {
        $assertionsDisabled = !TextureProperty.class.desiredAssertionStatus();
    }
}

