/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.support;

import com.jeta.open.support.ComponentFinder;
import com.jeta.open.support.EmptyCollection;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;

public class DefaultComponentFinder
implements ComponentFinder,
ContainerListener {
    private HashMap m_components;
    private WeakReference m_container_ref;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultComponentFinder(Container parent) {
        this.m_container_ref = new WeakReference<Container>(parent);
    }

    protected void buildNames(Container container) {
        if (container != null) {
            if (container instanceof JMenu) {
                this.buildNames(((JMenu)container).getPopupMenu());
            } else {
                this.registerComponent(container);
                container.removeContainerListener(this);
                container.addContainerListener(this);
                int count = container.getComponentCount();
                for (int index = 0; index < count; ++index) {
                    Component comp = container.getComponent(index);
                    if (comp instanceof Container) {
                        this.buildNames((Container)comp);
                        continue;
                    }
                    this.registerComponent(comp);
                }
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void componentAdded(ContainerEvent e) {
        Component child = e.getChild();
        if (child instanceof TableCellRenderer || child instanceof ListCellRenderer) {
            return;
        }
        if (child instanceof Container) {
            this.buildNames((Container)child);
        } else if (child instanceof Component) {
            this.registerComponent(child);
        }
    }

    public void componentRemoved(ContainerEvent e) {
        Component child = e.getChild();
        if (child instanceof TableCellRenderer || child instanceof ListCellRenderer) {
            return;
        }
        if (child instanceof Component) {
            this.unregisterComponent(child);
        }
    }

    public void enableComponent(String commandId, boolean bEnable) {
        Component comp = this.getComponentByName(commandId);
        if (comp != null) {
            comp.setEnabled(bEnable);
        }
    }

    public Component getComponentByName(String componentName) {
        WeakReference wref;
        if (this.m_components == null) {
            this.m_components = new HashMap();
            this.buildNames((Container)this.m_container_ref.get());
        }
        if ((wref = (WeakReference)this.m_components.get(componentName)) != null) {
            return (Component)wref.get();
        }
        return null;
    }

    public Collection getComponentsByName(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp == null) {
            return EmptyCollection.getInstance();
        }
        LinkedList<Component> list = new LinkedList<Component>();
        list.add(comp);
        return list;
    }

    public Container getContainer() {
        return (Container)this.m_container_ref.get();
    }

    private void registerComponent(Component comp) {
        if (comp == null) {
            return;
        }
        String name = comp.getName();
        if (name != null && name.length() > 0) {
            this.m_components.put(name, new WeakReference<Component>(comp));
        }
    }

    public void unregisterComponent(Component c) {
        if (c instanceof Container) {
            ((Container)c).removeContainerListener(this);
        }
        Iterator iter = this.m_components.values().iterator();
        while (iter.hasNext()) {
            WeakReference wref = (WeakReference)iter.next();
            if (wref != null && wref.get() != c) continue;
            iter.remove();
        }
    }

    public void setVisible(String commandId, boolean bVisible) {
        Component comp = this.getComponentByName(commandId);
        if (comp != null) {
            comp.setVisible(bVisible);
        }
    }

    public void reset() {
        this.m_components = null;
    }

    public Collection getAllNamedComponents() {
        if (this.m_components == null) {
            this.m_components = new HashMap();
            this.buildNames((Container)this.m_container_ref.get());
        }
        LinkedList<Component> components = new LinkedList<Component>();
        Iterator names = this.m_components.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            WeakReference wref = (WeakReference)this.m_components.get(name);
            if (wref == null) continue;
            components.addLast((Component)wref.get());
        }
        return components;
    }

    static {
        $assertionsDisabled = !DefaultComponentFinder.class.desiredAssertionStatus();
    }
}

