/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.swing.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.swing.Icon;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractElement
implements Element {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractElement.class);
    private final Object value;
    private final String iconName;
    protected Icon icon;
    private String name;
    private ExpressionBuilderConfig config;

    protected AbstractElement(String name) {
        this(name, name, null);
    }

    protected AbstractElement(String name, Object value) {
        this(name, value, null);
    }

    protected AbstractElement(String name, Object value, String iconName) {
        this.name = name == null ? Objects.toString(value) : name;
        this.value = value == null ? name : value;
        this.iconName = iconName;
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        this.icon = theme.exists(iconName) ? theme.get(iconName) : (this instanceof Element.GroupElement ? theme.get("expressionbuilder-element-group") : theme.get("expressionbuilder-element"));
    }

    @Override
    public Element setConfig(ExpressionBuilderConfig config) {
        this.config = config;
        return this;
    }

    @Override
    public ExpressionBuilderConfig getConfig() {
        return this.config;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Collection<Element> getValues() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean hasMoreValues() {
        return false;
    }

    @Override
    public String getRenderedValue() {
        return Objects.toString(this.value);
    }

    @Override
    public String getDescription() {
        return null;
    }

    public String getLabel() {
        return Objects.toString(this.value, "");
    }

    public int compareTo(Object other) {
        String thisLabel;
        String otherLabel = null;
        if (other != null) {
            otherLabel = other.toString();
        }
        if ((thisLabel = this.getLabel()) == otherLabel) {
            return 0;
        }
        if (thisLabel == null) {
            return -1;
        }
        if (otherLabel == null) {
            return 1;
        }
        return thisLabel.compareTo(otherLabel);
    }

    @Override
    public String getIconName() {
        return this.iconName;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void used() {
    }

    @Override
    public Component getAditionalPanel(JExpressionBuilder expressionBuilder) {
        return null;
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public void reload() {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public void dispose() {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Element cloneElement() {
        try {
            return (Element)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }
}

