/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.compat.se.net.downloader.se;

import java.io.File;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Executor;
import org.apache.http.entity.ContentType;
import org.gvsig.compat.se.net.downloader.se.AbstractSEDownloaderTask;
import org.gvsig.compat.se.net.downloader.se.SEDownloader;

final class SEDownloaderTask
extends AbstractSEDownloaderTask
implements Runnable {
    public SEDownloaderTask(SEDownloader downloader, Executor executor, URL url, String data, File dstFile, Object groupID) {
        super(downloader, executor, url, data, dstFile, groupID);
    }

    public SEDownloaderTask(SEDownloader downloader, Executor executor, URL url, String method, ContentType contenttype, String data, File dstFile, Object groupID) {
        super(downloader, executor, url, method, contenttype, data, dstFile, groupID);
    }

    @Override
    public void run() {
        LOGGER.info("downloading '" + this.url.toString() + "' to: " + this.dstFile.getAbsolutePath());
        int timeout = this.getTimeout();
        try {
            OutputStreamWriter os = null;
            HttpURLConnection connection = null;
            if (this.url.getProtocol().equals("https")) {
                this.disableHttsValidation();
            }
            connection = (HttpURLConnection)this.url.openConnection();
            connection.setUseCaches(false);
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (gvSIG) like Gecko");
            connection.setConnectTimeout(timeout);
            if (this.data != null) {
                connection.setRequestProperty("SOAPAction", "post");
                connection.setRequestMethod(this.method);
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", this.contenttype.toString());
                os = new OutputStreamWriter(connection.getOutputStream());
                os.write(this.data);
                os.flush();
            }
            this.download(connection.getInputStream());
            if (os != null) {
                os.close();
            }
            this.postdownload();
        }
        catch (Exception e) {
            this.exception(e);
        }
    }
}

