/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl.info;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.PackageInfoWriter;
import org.gvsig.installer.lib.impl.utils.SignUtil;
import org.gvsig.installer.lib.spi.InstallerInfoFileException;

public class InstallerInfoFileWriter
implements PackageInfoWriter {
    public void write(PackageInfo installInfo, String fileName) throws InstallerInfoFileException {
        this.write(installInfo, new File(fileName));
    }

    public void write(PackageInfo installInfo, File file) throws InstallerInfoFileException {
        try {
            this.write(installInfo, new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new InstallerInfoFileException("install_infofile_not_found", (Throwable)e);
        }
        SignUtil signutil = new SignUtil();
        if (signutil.canSign()) {
            signutil.sign(file);
        }
    }

    public void write(PackageInfo installInfo, OutputStream os) throws InstallerInfoFileException {
        try {
            Properties properties = new Properties();
            properties.setProperty("code", this.toStr(installInfo.getCode()));
            properties.setProperty("name", this.toStr(installInfo.getName()));
            properties.setProperty("description", this.toStr(installInfo.getDescription()));
            properties.setProperty("version", installInfo.getVersion().toString());
            properties.setProperty("buildNumber", Integer.toString(installInfo.getBuild()));
            properties.setProperty("state", this.toStr(installInfo.getState()));
            properties.setProperty("official", Boolean.toString(installInfo.isOfficial()));
            properties.setProperty("type", this.toStr(installInfo.getType()));
            properties.setProperty("operating-system", this.toStr(installInfo.getOperatingSystem()));
            properties.setProperty("architecture", this.toStr(installInfo.getArchitecture()));
            properties.setProperty("java-version", this.toStr(installInfo.getJavaVM()));
            properties.setProperty("gvSIG-version", this.toStr(installInfo.getGvSIGVersion()));
            properties.setProperty("owner", this.toStr(installInfo.getOwner()));
            properties.setProperty("categories", this.toStr(installInfo.getCategoriesAsString()));
            properties.setProperty("dependencies", this.toStr(installInfo.getDependencies()));
            properties.setProperty("sources-url", this.toStr(installInfo.getSourcesURL()));
            properties.setProperty("web-url", this.toStr(installInfo.getWebURL()));
            properties.setProperty("owner-url", this.toStr(installInfo.getOwnerURL()));
            properties.setProperty("model-version", this.toStr(installInfo.getModelVersion()));
            if (!StringUtils.isBlank((CharSequence)installInfo.getDownloadURLAsString())) {
                properties.setProperty("download-url", this.toStr(installInfo.getDownloadURLAsString()));
            }
            properties.store(os, "");
            os.close();
        }
        catch (IOException e) {
            throw new InstallerInfoFileException("install_infofile_writing_error", (Throwable)e);
        }
    }

    private String toStr(Object s) {
        return s == null ? "" : s.toString();
    }
}

