/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.gvsig.gui.beans.Messages;

public class AcceptCancelPanel
extends JPanel {
    private static final long serialVersionUID = -1834568346328338410L;
    private JButton btnOk = null;
    private JButton btnCancel = null;

    public AcceptCancelPanel(ActionListener okAction, ActionListener cancelAction) {
        this.initialize(okAction, cancelAction);
    }

    public AcceptCancelPanel() {
        this.initialize(null, null);
    }

    private void initialize(ActionListener okAction, ActionListener cancelAction) {
        this.setLayout(new BorderLayout());
        JPanel aux = new JPanel();
        aux.add((Component)this.getBtnOk(okAction), "East");
        aux.add((Component)this.getCancelButton(cancelAction), "East");
        this.add((Component)aux, "East");
    }

    private JButton getBtnOk(ActionListener okAction) {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setText(Messages.getText("aceptar"));
            this.btnOk.setActionCommand("OK");
            if (okAction != null) {
                this.btnOk.addActionListener(okAction);
            }
        }
        return this.btnOk;
    }

    private JButton getCancelButton(ActionListener cancelAction) {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(Messages.getText("cancel"));
            this.btnCancel.setActionCommand("CANCEL");
            if (cancelAction != null) {
                this.btnCancel.addActionListener(cancelAction);
            }
        }
        return this.btnCancel;
    }

    public void addCancelButtonActionListener(ActionListener l) {
        this.btnCancel.addActionListener(l);
    }

    public void setOkButtonActionListener(ActionListener l) {
        ActionListener[] listeners = this.btnOk.getActionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.btnOk.removeActionListener(listeners[i]);
        }
        this.btnOk.addActionListener(l);
    }

    public void setCancelButtonActionListener(ActionListener l) {
        ActionListener[] listeners = this.btnCancel.getActionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.btnCancel.removeActionListener(listeners[i]);
        }
        this.btnCancel.addActionListener(l);
    }

    public void addOkButtonActionListener(ActionListener l) {
        this.btnOk.addActionListener(l);
    }

    public JButton getOkButton() {
        return this.btnOk;
    }

    public boolean isOkButtonEnabled() {
        return this.btnOk.isEnabled();
    }

    public boolean isCancelButtonEnabled() {
        return this.btnCancel.isEnabled();
    }

    public void setOkButtonEnabled(boolean b) {
        this.btnOk.setEnabled(b);
    }

    public void setCancelButtonEnabled(boolean b) {
        this.btnCancel.setEnabled(b);
    }
}

