/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.colorslideredition;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.gvsig.gui.beans.colorslideredition.ColorSliderEvent;
import org.gvsig.gui.beans.colorslideredition.ColorSliderListener;
import org.gvsig.gui.beans.colorslideredition.ItemColorSlider;

public class ColorSliderEdition
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 663355422780987493L;
    private ArrayList<ColorSliderListener> actionCommandListeners = new ArrayList();
    private ArrayList<ColorSliderListener> actionSelectionListeners = new ArrayList();
    private ArrayList<ItemColorSlider> items = new ArrayList();
    private final int LEFT_PAD = 3;
    private final int RIGHT_PAD = 3;
    private Image bufferImage = null;
    private int width = 0;
    private int height = 0;
    private Graphics bufferGraphics = null;
    private boolean interpolated = true;

    public ColorSliderEdition() {
        this.setPreferredSize(new Dimension(100, 46));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.refreshImage();
    }

    public void addItem(ItemColorSlider value) {
        this.addItem(value, true);
    }

    public void addItem(ItemColorSlider value, boolean repaint) {
        this.items.add(value);
        if (repaint) {
            this.refreshImage();
        }
    }

    private Color interpolatedColor(ArrayList newItems, double value, int pos) {
        double perc2;
        double perc1;
        Color color2;
        Color color1;
        if (newItems.size() <= 0) {
            return Color.black;
        }
        if (pos + 1 == newItems.size()) {
            return ((ItemColorSlider)newItems.get(pos)).getColor();
        }
        if (value <= ((ItemColorSlider)newItems.get(0)).getValue()) {
            return ((ItemColorSlider)newItems.get(0)).getColor();
        }
        ItemColorSlider item1 = (ItemColorSlider)newItems.get(pos);
        ItemColorSlider item2 = (ItemColorSlider)newItems.get(pos + 1);
        double percValue = (value - item1.getValue()) * 100.0 / (item2.getValue() - item1.getValue());
        Color halfColor = new Color(item2.getColor().getRed() + item1.getColor().getRed() >> 1, item2.getColor().getGreen() + item1.getColor().getGreen() >> 1, item2.getColor().getBlue() + item1.getColor().getBlue() >> 1, item2.getColor().getAlpha() + item1.getColor().getAlpha() >> 1);
        if (percValue > item2.getInterpolated()) {
            color1 = halfColor;
            color2 = item2.getColor();
            perc1 = item2.getInterpolated();
            perc2 = 100.0;
        } else {
            color1 = item1.getColor();
            color2 = halfColor;
            perc1 = 0.0;
            perc2 = item2.getInterpolated();
        }
        double percNew = (percValue - perc1) / (perc2 - perc1);
        Color newColor = new Color((int)((double)color1.getRed() + (double)(color2.getRed() - color1.getRed()) * percNew) & 0xFF, (int)((double)color1.getGreen() + (double)(color2.getGreen() - color1.getGreen()) * percNew) & 0xFF, (int)((double)color1.getBlue() + (double)(color2.getBlue() - color1.getBlue()) * percNew) & 0xFF, (int)((double)color1.getAlpha() + (double)(color2.getAlpha() - color1.getAlpha()) * percNew) & 0xFF);
        return newColor;
    }

    private Graphics getBufferGraphics() {
        int width2 = this.getBounds().width;
        int height2 = this.getBounds().height;
        if (width2 <= 0) {
            width2 = 1;
        }
        if (height2 <= 0) {
            height2 = 1;
        }
        if (this.width != width2 || this.height != height2) {
            this.bufferImage = this.createImage(width2, height2);
            if (this.bufferImage == null) {
                return null;
            }
            this.bufferGraphics = this.bufferImage.getGraphics();
        }
        this.width = width2;
        this.height = height2;
        return this.bufferGraphics;
    }

    private void sortItems() {
        for (int i = 0; i < this.items.size(); ++i) {
            for (int j = i + 1; j < this.items.size(); ++j) {
                if (!(this.items.get(j).getValue() < this.items.get(i).getValue())) continue;
                ItemColorSlider aux = this.items.get(i);
                this.items.set(i, this.items.get(j));
                this.items.set(j, aux);
            }
        }
    }

    private int getPosForValue(double value, ArrayList newArray) {
        int pos = 0;
        for (int j = 1; j <= newArray.size(); ++j) {
            if (j < newArray.size()) {
                if (!(value < ((ItemColorSlider)newArray.get(j)).getValue())) continue;
                pos = j - 1;
                break;
            }
            pos = j - 1;
            break;
        }
        return pos;
    }

    private Color convertColor(Color value) {
        if (this.isEnabled()) {
            return value;
        }
        int aux = (value.getRed() + value.getGreen() + value.getBlue()) / 3;
        aux = (int)((double)aux * 91.0 / 255.0 + 164.0);
        return new Color(aux, aux, aux, value.getAlpha());
    }

    private void redrawBuffer() {
        int i;
        if (this.getBufferGraphics() == null) {
            return;
        }
        this.sortItems();
        this.getBufferGraphics().setColor(this.getBackground());
        this.getBufferGraphics().fillRect(0, 0, this.width, this.height);
        this.getBufferGraphics().setColor(Color.black);
        this.getBufferGraphics().drawRect(3, 0, this.width - 1 - 3 - 3, this.height - 18);
        Shape oldClip = this.getBufferGraphics().getClip();
        this.getBufferGraphics().setClip(5, 2, this.width - 4 - 3 - 3, this.height - 21);
        int i2 = 0;
        while (i2 * 4 + 2 <= this.width - 3 - 3 - 3) {
            int j = 0;
            while (j * 4 + 2 <= this.height - 20) {
                if ((i2 + j) % 2 == 0) {
                    this.getBufferGraphics().setColor(Color.white);
                } else {
                    this.getBufferGraphics().setColor(new Color(204, 204, 204));
                }
                this.getBufferGraphics().fillRect(i2 * 4 + 2 + 3, j * 4 + 2, 4, 4);
                ++j;
            }
            ++i2;
        }
        Color newColor = Color.black;
        ArrayList newArray = this.getItemsShowed();
        for (int i3 = 5; i3 <= this.width - 2 - 3; ++i3) {
            int pos = this.getPosForValue(this.pixelToValue(i3), newArray);
            if (this.isInterpolated()) {
                newColor = this.interpolatedColor(newArray, this.pixelToValue(i3), pos);
            } else {
                double max;
                double min;
                if (pos + 1 < newArray.size() && (min = ((ItemColorSlider)newArray.get(pos)).getValue()) + ((max = ((ItemColorSlider)newArray.get(pos + 1)).getValue()) - min) * ((ItemColorSlider)newArray.get(pos + 1)).getInterpolated() / 100.0 < this.pixelToValue(i3)) {
                    ++pos;
                }
                if (pos < newArray.size()) {
                    newColor = ((ItemColorSlider)newArray.get(pos)).getColor();
                }
            }
            if (newColor == null) continue;
            this.getBufferGraphics().setColor(this.convertColor(newColor));
            this.getBufferGraphics().drawLine(i3, 2, i3, this.height - 18);
        }
        this.getBufferGraphics().setClip(oldClip);
        boolean paintNext = false;
        for (i = 0; i < this.items.size(); ++i) {
            ItemColorSlider aux = this.items.get(i);
            if (!aux.isVisible()) continue;
            if (aux.getSelected() != -1) {
                paintNext = true;
            }
            if (paintNext && this.isEnabled()) {
                if (i != 0) {
                    double value = this.items.get(i - 1).getValue() + (this.items.get(i).getValue() - this.items.get(i - 1).getValue()) * this.items.get(i).getInterpolated() / 100.0;
                    this.drawSliderInterpolation(this.valueToPixel(value), this.height - 17, aux.getColor(), aux.getSelected() == 2);
                }
                paintNext = false;
            }
            if (aux.getSelected() != 1) continue;
            paintNext = true;
        }
        for (i = this.items.size() - 1; i >= 0; --i) {
            ItemColorSlider aux = this.items.get(i);
            if (!aux.isVisible()) continue;
            this.drawSliderColor(this.valueToPixel(aux.getValue()), this.height - 17, this.convertColor(aux.getColor()), aux.getSelected() == 1 && this.isEnabled());
        }
    }

    private int valueToPixel(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 100.0) {
            value = 100.0;
        }
        return (int)((double)(this.width - 5 - 3 - 3) * value / 100.0) + 2 + 3;
    }

    private double pixelToValue(int value) {
        double aux = value - 3 - 1;
        return aux * 100.0 / (double)((float)(this.width - 3 - 3) - 4.0f);
    }

    private void drawSliderColor(int x, int y, Color color, boolean isSelected) {
        if (color == null) {
            return;
        }
        Polygon p = new Polygon();
        p.addPoint(x, y);
        p.addPoint(x - 5, y + 6);
        p.addPoint(x - 5, y + 16);
        p.addPoint(x + 5, y + 16);
        p.addPoint(x + 5, y + 6);
        if (!isSelected) {
            this.getBufferGraphics().setColor(this.getBackground());
            this.getBufferGraphics().fillPolygon(p);
            this.getBufferGraphics().setColor(new Color(172, 168, 153));
            this.getBufferGraphics().drawLine(x + 1, y + 2, x + 4, y + 6);
            this.getBufferGraphics().drawLine(x - 4, y + 6, x + 4, y + 6);
        } else {
            this.getBufferGraphics().setColor(Color.black);
            this.getBufferGraphics().fillPolygon(p);
        }
        this.getBufferGraphics().setColor(Color.black);
        this.getBufferGraphics().drawPolygon(p);
        this.getBufferGraphics().setColor(new Color(172, 168, 153));
        this.getBufferGraphics().drawLine(x - 3, y + 15, x + 4, y + 15);
        this.getBufferGraphics().drawLine(x + 4, y + 8, x + 4, y + 15);
        this.getBufferGraphics().setColor(Color.white);
        this.getBufferGraphics().drawLine(x - 4, y + 7, x - 4, y + 15);
        this.getBufferGraphics().drawLine(x - 4, y + 7, x + 4, y + 7);
        this.getBufferGraphics().setColor(new Color(color.getRed(), color.getGreen(), color.getBlue()));
        this.getBufferGraphics().fillRect(x - 3, y + 8, 7, 7);
    }

    private void drawSliderInterpolation(int x, int y, Color color, boolean isSelected) {
        Polygon p = new Polygon();
        p.addPoint(x, y);
        p.addPoint(x - 3, y + 3);
        p.addPoint(x, y + 6);
        p.addPoint(x + 3, y + 3);
        if (isSelected) {
            this.getBufferGraphics().setColor(new Color(color.getRed(), color.getGreen(), color.getBlue()));
        } else {
            this.getBufferGraphics().setColor(this.getBackground());
        }
        this.getBufferGraphics().fillPolygon(p);
        this.getBufferGraphics().setColor(Color.black);
        this.getBufferGraphics().drawPolygon(p);
    }

    private void refreshImage() {
        this.redrawBuffer();
        if (this.bufferImage != null) {
            this.getGraphics().drawImage(this.bufferImage, 0, 0, this);
        }
        super.paint(this.getGraphics());
    }

    @Override
    public void paint(Graphics g) {
        this.redrawBuffer();
        g.drawImage(this.bufferImage, 0, 0, this);
        super.paint(g);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int onmask = 1024;
        if ((e.getModifiersEx() & onmask) != onmask) {
            return;
        }
        onmask = 512;
        boolean newItem = false;
        if ((e.getModifiersEx() & onmask) == onmask) {
            newItem = true;
        }
        if (e.getY() > this.height || e.getY() < this.height - 18) {
            this.clearSelected();
            this.refreshImage();
            return;
        }
        int type = 1;
        ItemColorSlider itemSelected = this.getItem(e.getX(), e.getY());
        if (itemSelected == null || newItem) {
            itemSelected = this.getItemInterpolated(e.getX(), e.getY());
            if (itemSelected == null || newItem) {
                int pos = this.getPosForValue(this.pixelToValue(e.getX()), this.items);
                Color newColor = this.interpolatedColor(this.items, this.pixelToValue(e.getX()), pos);
                itemSelected = new ItemColorSlider(this.pixelToValue(e.getX()), newColor);
                this.items.add(itemSelected);
            } else {
                type = 2;
            }
        }
        this.setItemSelected(itemSelected, type);
        this.callSelectionChangedListeners();
        this.callValueChangedListeners();
        this.refreshImage();
    }

    private void clearSelected() {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            this.items.get(i).setSelected(-1);
        }
    }

    private void setItemSelected(ItemColorSlider aux, int type) {
        this.clearSelected();
        aux.setSelected(type);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            for (int i = this.items.size() - 1; i >= 0; --i) {
                if (this.items.size() <= 2) {
                    return;
                }
                if (this.items.get(i).isVisible()) continue;
                this.items.remove(i);
            }
        }
        finally {
            this.callValueChangedListeners();
        }
    }

    public ItemColorSlider getSelectedItem() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i).getSelected() == -1) continue;
            return this.items.get(i);
        }
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        ItemColorSlider aux = this.getSelectedItem();
        if (aux != null) {
            if (aux.getSelected() == 1) {
                aux.setValue(this.pixelToValue(e.getX()));
                this.refreshImage();
                this.setMouseCursor(e.getX(), e.getY());
                aux.setVisible(e.getY() <= this.height && e.getY() >= 0 || this.items.size() <= 2);
                this.callValueDraggedListeners();
                return;
            }
            if (aux.getSelected() == 2) {
                int pos = -1;
                for (int i = 0; i < this.items.size(); ++i) {
                    if (this.items.get(i) != aux) continue;
                    pos = i;
                }
                if (pos > 0) {
                    double min = this.items.get(pos - 1).getValue();
                    double max = this.items.get(pos).getValue();
                    double newValue = 100.0 * (this.pixelToValue(e.getX()) - min) / (max - min);
                    aux.setInterpolated(newValue);
                    this.refreshImage();
                    this.setMouseCursor(e.getX(), e.getY());
                    this.callValueDraggedListeners();
                }
                return;
            }
        }
    }

    private ItemColorSlider getItem(int x, int y) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (x < this.valueToPixel(this.items.get(i).getValue()) - 5 || x > this.valueToPixel(this.items.get(i).getValue()) + 5 || y > this.height || y < this.height - 18) continue;
            return this.items.get(i);
        }
        return null;
    }

    private ItemColorSlider getItemInterpolated(int x, int y) {
        for (int i = 1; i < this.items.size(); ++i) {
            int value = this.valueToPixel(this.items.get(i - 1).getValue() + (this.items.get(i).getValue() - this.items.get(i - 1).getValue()) * this.items.get(i).getInterpolated() / 100.0);
            if (x < value - 3 || x > value + 3 || y > this.height - 11 || y < this.height - 18) continue;
            if (this.items.get(i).getSelected() != -1) {
                return this.items.get(i);
            }
            if (this.items.get(i - 1).getSelected() != 1) continue;
            return this.items.get(i);
        }
        return null;
    }

    private void setMouseCursor(int x, int y) {
        if (this.getItem(x, y) != null) {
            this.setCursor(new Cursor(11));
            return;
        }
        if (this.getItemInterpolated(x, y) != null) {
            this.setCursor(new Cursor(11));
            return;
        }
        if (y <= this.height && y >= this.height - 18) {
            this.setCursor(new Cursor(12));
            return;
        }
        this.setCursor(new Cursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.setMouseCursor(e.getX(), e.getY());
    }

    public boolean isInterpolated() {
        return this.interpolated;
    }

    public void setInterpolated(boolean interpolated) {
        this.interpolated = interpolated;
        this.refreshImage();
    }

    public void addValueChangedListener(ColorSliderListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void removeValueChangedListener(ColorSliderListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    public void addSelectionChangedListener(ColorSliderListener listener) {
        if (!this.actionSelectionListeners.contains(listener)) {
            this.actionSelectionListeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ColorSliderListener listener) {
        this.actionSelectionListeners.remove(listener);
    }

    private void callSelectionChangedListeners() {
        for (ColorSliderListener listener : this.actionSelectionListeners) {
            listener.actionSelectionChanged(new ColorSliderEvent(this));
        }
    }

    private void callValueChangedListeners() {
        for (ColorSliderListener listener : this.actionCommandListeners) {
            listener.actionValueChanged(new ColorSliderEvent(this));
        }
    }

    private void callValueDraggedListeners() {
        for (ColorSliderListener listener : this.actionCommandListeners) {
            listener.actionValueDragged(new ColorSliderEvent(this));
        }
    }

    public void removeAllItems() {
        this.items.clear();
    }

    public ArrayList getItems() {
        return this.items;
    }

    public ArrayList getItemsShowed() {
        ArrayList newArray = (ArrayList)this.items.clone();
        for (int i = newArray.size() - 1; i >= 0; --i) {
            if (((ItemColorSlider)newArray.get(i)).isVisible()) continue;
            newArray.remove(i);
        }
        return newArray;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.refreshImage();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

