/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.doubleslider;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.gvsig.gui.beans.doubleslider.DoubleSliderEvent;
import org.gvsig.gui.beans.doubleslider.DoubleSliderListener;

public class DoubleSlider
extends JComponent
implements MouseMotionListener,
MouseListener,
MouseWheelListener {
    private static final long serialVersionUID = 663355422780987493L;
    private ArrayList<DoubleSliderListener> actionCommandListeners = new ArrayList();
    private final int LEFT_PAD = 2;
    private final int RIGHT_PAD = 2;
    private Image bufferImage = null;
    private int width = 0;
    private int height = 0;
    private Graphics bufferGraphics;
    private double x1 = 0.0;
    private double x2 = 100.0;
    private Color color1 = Color.BLACK;
    private Color color2 = Color.WHITE;
    private double minimum = 0.0;
    private double maximum = 100.0;
    private boolean twoSliders = true;
    int valuePressed = 0;

    public DoubleSlider() {
        this.setPreferredSize(new Dimension(100, 21));
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
    }

    public void setMaximum(int value) {
        this.maximum = value;
        this.validateValues();
        this.refreshImage();
    }

    public void setMinimum(int value) {
        this.minimum = value;
        this.validateValues();
        this.refreshImage();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.refreshImage();
    }

    private Graphics getBufferGraphics() {
        int width2 = this.getBounds().width;
        int height2 = this.getBounds().height;
        if (width2 <= 0) {
            width2 = 1;
        }
        if (height2 <= 0) {
            height2 = 1;
        }
        if (this.width != width2 || this.height != height2) {
            this.bufferImage = this.createImage(width2, height2);
            if (this.bufferImage == null) {
                return null;
            }
            this.bufferGraphics = this.bufferImage.getGraphics();
        }
        this.width = width2;
        this.height = height2;
        return this.bufferGraphics;
    }

    public Color getColorPosition(int pos) {
        double value;
        int r;
        Color color1 = this.color1;
        Color color2 = this.color2;
        if (!this.isEnabled()) {
            r = Color.DARK_GRAY.getRed();
            color1 = new Color(r, r, r);
            r = Color.WHITE.getRed();
            color2 = new Color(r, r, r);
        }
        if ((value = (this.pixeltovalue(pos) - this.minimum) / (this.maximum - this.minimum)) < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        r = (int)((double)color1.getRed() + (double)(color2.getRed() - color1.getRed()) * value);
        int g = (int)((double)color1.getGreen() + (double)(color2.getGreen() - color1.getGreen()) * value);
        int b = (int)((double)color1.getBlue() + (double)(color2.getBlue() - color1.getBlue()) * value);
        int a = (int)((double)color1.getAlpha() + (double)(color2.getAlpha() - color1.getAlpha()) * value);
        return new Color(r, g, b, a);
    }

    public void redrawBuffer() {
        int i;
        if (this.getBufferGraphics() == null) {
            return;
        }
        this.getBufferGraphics().setColor(this.getBackground());
        this.getBufferGraphics().fillRect(0, 0, this.width, this.height);
        int top = (this.height - 11) / 2;
        Shape oldClip = this.getBufferGraphics().getClip();
        this.getBufferGraphics().setClip(3, (top -= 6) + 1, this.width - 2 - 2 - 2, 9);
        if (this.color1.getAlpha() != 255 || this.color2.getAlpha() != 255) {
            i = 0;
            while (i * 4 <= this.width - 1 - 2) {
                int j = 0;
                while (j * 4 <= top + 6) {
                    if ((i + j) % 2 == 0) {
                        this.getBufferGraphics().setColor(Color.white);
                    } else {
                        this.getBufferGraphics().setColor(new Color(204, 204, 204));
                    }
                    this.getBufferGraphics().fillRect(3 + i * 4, top + 1 + j * 4, 4, 4);
                    ++j;
                }
                ++i;
            }
        }
        for (i = 3; i < this.width - 1 - 2; ++i) {
            this.getBufferGraphics().setColor(this.getColorPosition(i));
            this.getBufferGraphics().drawLine(i, top, i, top + 10);
        }
        this.getBufferGraphics().setClip(oldClip);
        if (!this.isEnabled()) {
            this.getBufferGraphics().setColor(Color.LIGHT_GRAY);
        } else {
            this.getBufferGraphics().setColor(Color.BLACK);
        }
        this.getBufferGraphics().drawRect(2, top, this.width - 1 - 2 - 2, 10);
        this.drawTriangle(this.valuetopixel(this.x1), top, this.getColorPosition(this.valuetopixel(this.x1)));
        if (this.twoSliders) {
            this.drawTriangle(this.valuetopixel(this.x2), top, this.getColorPosition(this.valuetopixel(this.x2)));
        }
    }

    private void drawTriangle(int x, int y, Color color) {
        if (this.isEnabled()) {
            this.getBufferGraphics().setColor(color);
            this.getBufferGraphics().drawLine(x, y + 12, x, y + 16);
            this.getBufferGraphics().drawLine(x - 1, y + 14, x - 1, y + 16);
            this.getBufferGraphics().drawLine(x + 1, y + 14, x + 1, y + 16);
            this.getBufferGraphics().drawLine(x - 2, y + 16, x - 2, y + 16);
            this.getBufferGraphics().drawLine(x + 2, y + 16, x + 2, y + 16);
        }
        if (this.isEnabled()) {
            this.getBufferGraphics().setColor(Color.BLACK);
        } else {
            this.getBufferGraphics().setColor(Color.GRAY);
        }
        this.getBufferGraphics().drawLine(x, y + 10, x - 3, y + 17);
        this.getBufferGraphics().drawLine(x, y + 10, x + 3, y + 17);
        this.getBufferGraphics().drawLine(x - 3, y + 17, x + 3, y + 17);
    }

    public void refreshImage() {
        this.redrawBuffer();
        if (this.getGraphics() == null) {
            return;
        }
        if (this.bufferImage != null) {
            this.getGraphics().drawImage(this.bufferImage, 0, 0, this);
        }
        super.paint(this.getGraphics());
    }

    private int valuetopixel(double value) {
        return (int)((value - this.minimum) * ((double)this.width - 3.0 - 2.0 - 2.0) / (this.maximum - this.minimum) + 1.0 + 2.0);
    }

    private double pixeltovalue(int value) {
        return (double)(value - 1 - 2) * (this.maximum - this.minimum) / ((double)this.width - 3.0 - 2.0 - 2.0) + this.minimum;
    }

    @Override
    public void paint(Graphics g) {
        this.redrawBuffer();
        g.drawImage(this.bufferImage, 0, 0, this);
        super.paint(g);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        double aux2;
        if (!this.isEnabled()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        double aux = this.pixeltovalue(e.getX());
        double aux3 = this.x2 - aux;
        this.valuePressed = aux3 < (aux2 = aux - this.x1) ? 2 : 1;
        if (!this.twoSliders) {
            this.valuePressed = 1;
        }
        this.changeValue(e.getX());
        this.callValueDraggedListeners();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.valuePressed = 0;
        this.callValueChangedListeners();
    }

    private void validateValues() {
        if (this.x1 < this.minimum) {
            this.x1 = this.minimum;
        }
        if (this.x1 > this.maximum) {
            this.x1 = this.maximum;
        }
        if (this.twoSliders) {
            if (this.x2 < this.minimum) {
                this.x2 = this.minimum;
            }
            if (this.x2 > this.maximum) {
                this.x2 = this.maximum;
            }
        }
    }

    public void setX1(int value) {
        this.setX1((double)value);
    }

    public void setX1(double value) {
        this.x1 = value;
        if (this.twoSliders && this.x1 > this.x2) {
            this.x2 = this.x1;
        }
        this.validateValues();
        this.refreshImage();
    }

    public void setValue(int value) {
        this.setX1(value);
    }

    public void setX2(int value) {
        this.setX2((double)value);
    }

    public void setX2(double value) {
        this.x2 = value;
        if (this.x2 < this.x1) {
            this.x1 = this.x2;
        }
        this.validateValues();
        this.refreshImage();
    }

    public int getX1() {
        return (int)this.x1;
    }

    public int getValue() {
        return this.getX1();
    }

    public int getX2() {
        return (int)this.x2;
    }

    private void changeValue(int pos) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.valuePressed == 0) {
            return;
        }
        double aux = this.pixeltovalue(pos);
        if (this.valuePressed == 1) {
            this.setX1(aux);
        }
        if (this.valuePressed == 2) {
            this.setX2(aux);
        }
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        if (!this.isEnabled()) {
            return;
        }
        this.changeValue(arg0.getX());
        this.callValueDraggedListeners();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void addValueChangedListener(DoubleSliderListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void removeValueChangedListener(DoubleSliderListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    private void callValueChangedListeners() {
        for (DoubleSliderListener listener : this.actionCommandListeners) {
            listener.actionValueChanged(new DoubleSliderEvent(this));
        }
    }

    private void callValueDraggedListeners() {
        for (DoubleSliderListener listener : this.actionCommandListeners) {
            listener.actionValueDragged(new DoubleSliderEvent(this));
        }
    }

    public boolean isTwoSliders() {
        return this.twoSliders;
    }

    public void setTwoSliders(boolean twoSliders) {
        this.twoSliders = twoSliders;
        this.refreshImage();
    }

    public void setColor1(Color color1, boolean refresh) {
        this.color1 = color1;
        if (refresh) {
            this.refreshImage();
        }
    }

    public void setColor2(Color color2, boolean refresh) {
        this.color2 = color2;
        if (refresh) {
            this.refreshImage();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.refreshImage();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double aux2;
        if (!this.isEnabled()) {
            return;
        }
        double aux = this.pixeltovalue(e.getX());
        double aux3 = this.x2 - aux;
        this.valuePressed = aux3 < (aux2 = aux - this.x1) ? 2 : 1;
        if (!this.twoSliders) {
            this.valuePressed = 1;
        }
        if (this.valuePressed == 1) {
            this.setX1(this.getX1() - e.getWheelRotation());
        } else {
            this.setX2(this.getX2() - e.getWheelRotation());
        }
        this.valuePressed = 0;
        this.callValueChangedListeners();
    }
}

